/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.vm;

import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.IModuleSourceInfo;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationUtil;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.utilities.ASTNode;

public class UnitLocation {
    private static final int UNDEF_LINE_NUM = -2;
    private int fLineNum = -2;
    private final int fOffset;
    private final int fDepth;
    private final ASTNode fElement;
    private final Module fModule;
    private final ImperativeOperation fOperation;
    private final QvtOperationalEvaluationEnv fEvalEnv;
    private IModuleSourceInfo fSrcInfo;

    public UnitLocation(int position, QvtOperationalEvaluationEnv evalEnv, ASTNode element) {
        this.fEvalEnv = evalEnv;
        this.fElement = element;
        this.fOffset = position;
        this.fDepth = UnitLocation.calcStackDepth(evalEnv);
        this.fOperation = evalEnv.getOperation();
        InternalEvaluationEnv internEnv = (InternalEvaluationEnv)this.fEvalEnv.getAdapter(InternalEvaluationEnv.class);
        if (internEnv.getCurrentModule() != null) {
            this.fModule = internEnv.getCurrentModule().getModule();
        } else if (element instanceof Module) {
            this.fModule = (Module)element;
        } else {
            throw new IllegalArgumentException("Module-less evaluation environment");
        }
    }

    public boolean isDeferredExecution() {
        return ((InternalEvaluationEnv)this.fEvalEnv.getAdapter(InternalEvaluationEnv.class)).isDeferredExecution();
    }

    public URI getURI() {
        return this.getSourceInfo().getSourceURI();
    }

    public Module getModule() {
        return this.fModule;
    }

    public ImperativeOperation getOperation() {
        return this.fOperation;
    }

    public QvtOperationalEvaluationEnv getEvalEnv() {
        return this.fEvalEnv;
    }

    public int getLineNum() {
        if (this.fLineNum == -2) {
            int newLine = -1;
            if (this.fOffset >= 0) {
                newLine = this.getSourceInfo().getLineNumberProvider().getLineNumber(this.fOffset);
            }
            this.fLineNum = newLine;
            return this.fLineNum;
        }
        return this.fLineNum;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getStackDepth() {
        return this.fDepth;
    }

    public ASTNode getElement() {
        return this.fElement;
    }

    public boolean isTheSameLine(UnitLocation location) {
        return this.fEvalEnv == location.fEvalEnv && this.getLineNum() == location.getLineNum();
    }

    public boolean equals(Object another) {
        if (!(another instanceof UnitLocation)) {
            return false;
        }
        UnitLocation location = (UnitLocation)another;
        return this == location || this.fOffset == location.fOffset && this.fDepth == location.fDepth && this.fEvalEnv == location.fEvalEnv && this.fElement.equals(location.fElement);
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.fOffset;
        hash = 37 * hash + this.fDepth;
        hash = 37 * hash + this.fElement.hashCode();
        return hash;
    }

    public String toString() {
        return String.valueOf(this.fModule.getName()) + " - line:" + this.getLineNum() + " offset:" + this.fOffset + " depth:" + this.fDepth + ")";
    }

    private IModuleSourceInfo getSourceInfo() {
        if (this.fSrcInfo == null) {
            this.fSrcInfo = ASTBindingHelper.getModuleSourceBinding((Module)this.getModule());
        }
        return this.fSrcInfo;
    }

    private static int calcStackDepth(QvtOperationalEvaluationEnv currentEvalEnv) {
        int depth = 0;
        QvtOperationalEvaluationEnv evalEnv = currentEvalEnv;
        while (evalEnv != null) {
            depth += evalEnv.getDepth();
            evalEnv = EvaluationUtil.getAggregatingContext((QvtOperationalEvaluationEnv)evalEnv);
        }
        return depth;
    }
}

