/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.ocl.emf.libraries;

import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ocl.ecore.internal.OCLStandardLibraryImpl;
import org.osgi.framework.BundleContext;

public class LibrariesPlugin
extends Plugin {
    public static final String OCL_LIBRARY_PACKAGE = OCLStandardLibraryImpl.stdlibPackage.getName();
    private static final String LOGLEVEL_OPTION = "/loglevel";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        String logLevelString = Platform.getDebugOption((String)(String.valueOf(this.getBundle().getSymbolicName()) + LOGLEVEL_OPTION));
        Logger.getLogger("org.eclipse.m2m.qvt.oml.ocl").setLevel(this.getLogLevel(logLevelString, Level.SEVERE));
        Logger.getLogger("org.eclipse.m2m.qvt.oml.ocl").addHandler(new PluginLogHandler());
    }

    private Level getLogLevel(String level, Level def) {
        if (level == null || level.trim().equals("")) {
            return def;
        }
        level = level.trim().toUpperCase();
        try {
            return Level.parse(level);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return def;
        }
    }

    private class PluginLogHandler
    extends StreamHandler {
        private PluginLogHandler() {
        }

        public void publish(LogRecord record) {
            int severity = 0;
            if (record.getLevel() == Level.SEVERE) {
                severity = 4;
            } else if (record.getLevel() == Level.WARNING) {
                severity = 2;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.setOutputStream(outputStream);
            super.publish(record);
            super.close();
            LibrariesPlugin.this.getLog().log((IStatus)new Status(severity, LibrariesPlugin.this.getBundle().getSymbolicName(), 0, outputStream.toString(), record.getThrown()));
        }

        public void flush() {
        }

        public void close() throws SecurityException {
        }
    }
}

