/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.mappings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.RootXMLContentHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.qvt.declarative.ecore.Activator;
import org.eclipse.qvt.declarative.ecore.adapters.AdaptingEFactory;
import org.eclipse.qvt.declarative.ecore.adapters.AdaptingXMIResourceFactory;
import org.eclipse.qvt.declarative.ecore.mappings.EStructuralFeatureMap;
import org.eclipse.qvt.declarative.ecore.mappings.IMappingMetaData;
import org.eclipse.qvt.declarative.ecore.mappings.IMappingMetaDataRegistry;
import org.eclipse.qvt.declarative.ecore.mappings.MappingMetaDataRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappingMetaData
implements IMappingMetaData.Install {
    protected final EPackage adaptingEPackage;
    protected final EPackage ecoreEPackage;
    protected final String[] uriAliases;
    protected List<IMappingMetaData> imports = null;
    protected List<IMappingMetaData> merges = null;

    protected MappingMetaData(EPackage adaptingEPackage, EPackage ecoreEPackage, String[] uriAliases) {
        this.adaptingEPackage = adaptingEPackage;
        this.ecoreEPackage = ecoreEPackage;
        this.uriAliases = uriAliases;
        if (IMappingMetaDataRegistry.REGISTRY.getMappingMetaDataRegistryFactory() == null) {
            IMappingMetaDataRegistry.REGISTRY.setMappingMetaDataRegistry(new RegistryFactory());
        }
        IMappingMetaDataRegistry.REGISTRY.putMappingMetaData(adaptingEPackage, this);
        if (uriAliases != null) {
            String[] stringArray = uriAliases;
            int n = uriAliases.length;
            int n2 = 0;
            while (n2 < n) {
                String uriAlias = stringArray[n2];
                EPackage.Registry.INSTANCE.put((Object)uriAlias, (Object)adaptingEPackage);
                ++n2;
            }
        }
    }

    protected List<IMappingMetaData> computeImports(Stack<IMappingMetaData> forMappingMetadatas) {
        return new ArrayList<IMappingMetaData>();
    }

    protected List<IMappingMetaData> computeImports(Stack<IMappingMetaData> forMappingMetaDatas, List<IMappingMetaData> imports, IMappingMetaData.Install ... importedMetaDatas) {
        ArrayList<IMappingMetaData.Install> newImports = null;
        IMappingMetaData.Install[] installArray = importedMetaDatas;
        int n = importedMetaDatas.length;
        int n2 = 0;
        while (n2 < n) {
            IMappingMetaData.Install importedMetaData = installArray[n2];
            if (!imports.contains(importedMetaData)) {
                if (newImports == null) {
                    newImports = new ArrayList<IMappingMetaData.Install>();
                }
                newImports.add(importedMetaData);
            }
            ++n2;
        }
        if (newImports != null) {
            HashSet<IMappingMetaData> allImports = new HashSet<IMappingMetaData>();
            for (IMappingMetaData.Install newImport : newImports) {
                allImports.addAll(newImport.getImports(forMappingMetaDatas));
            }
            ArrayList<IMappingMetaData> sortedImports = new ArrayList<IMappingMetaData>(allImports);
            Collections.sort(sortedImports, ImportComparator.INSTANCE);
            return sortedImports;
        }
        return imports;
    }

    protected List<IMappingMetaData> computeMerges() {
        return new ArrayList<IMappingMetaData>();
    }

    @Override
    public void configure(ResourceSet resourceSet, IMappingMetaDataRegistry mappingMetaDataRegistry) {
        Map contentTypeToFactoryMap = resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap();
        EList contentHandlers = resourceSet.getURIConverter().getContentHandlers();
        String adaptingContentTypeIdentifier = this.getAdaptingContentTypeIdentifier();
        String ecoreContentTypeIdentifier = this.getEcoreContentTypeIdentifier();
        if (ecoreContentTypeIdentifier != null) {
            Resource.Factory ecoreResourceFactory = this.getEcoreResourceFactory();
            contentTypeToFactoryMap.put(ecoreContentTypeIdentifier, ecoreResourceFactory);
            contentHandlers.add((Object)new RootXMLContentHandlerImpl(ecoreContentTypeIdentifier, null, "xmi", this.ecoreEPackage.getNsURI(), null));
        }
        if (adaptingContentTypeIdentifier != null) {
            Resource.Factory adaptingResourceFactory = this.getAdaptingResourceFactory(mappingMetaDataRegistry);
            contentTypeToFactoryMap.put(adaptingContentTypeIdentifier, adaptingResourceFactory);
            contentHandlers.add((Object)new RootXMLContentHandlerImpl(adaptingContentTypeIdentifier, null, "xmi", this.adaptingEPackage.getNsURI(), null));
            if (this.uriAliases != null) {
                String[] stringArray = this.uriAliases;
                int n = this.uriAliases.length;
                int n2 = 0;
                while (n2 < n) {
                    String uriAlias = stringArray[n2];
                    contentHandlers.add((Object)new RootXMLContentHandlerImpl(adaptingContentTypeIdentifier, null, "xmi", uriAlias, null));
                    ++n2;
                }
            }
        }
    }

    @Override
    public abstract String getAdaptingContentTypeIdentifier();

    @Override
    public EPackage getAdaptingEPackage() {
        return this.adaptingEPackage;
    }

    public EStructuralFeatureMap<? extends EStructuralFeature> getAdaptingFeatureMap(IMappingMetaDataRegistry.Install mappingMetaDataRegistry, EClass adaptingEClass, EStructuralFeature adaptingFeature) {
        return mappingMetaDataRegistry.getAdaptingEStructuralFeatureMap(adaptingFeature);
    }

    @Override
    public abstract Resource.Factory getAdaptingResourceFactory(IMappingMetaDataRegistry var1);

    @Override
    public abstract String getEcoreContentTypeIdentifier();

    @Override
    public EPackage getEcoreEPackage() {
        return this.ecoreEPackage;
    }

    @Override
    public Resource.Factory getEcoreResourceFactory() {
        return new XMIResourceFactoryImpl();
    }

    public EStructuralFeatureMap<? extends EStructuralFeature> getEcoreFeatureMap(IMappingMetaDataRegistry.Install mappingMetaDataRegistry, EClass ecoreEClass, EStructuralFeature ecoreFeature) {
        return mappingMetaDataRegistry.getEcoreEStructuralFeatureMap(ecoreFeature);
    }

    @Override
    public IMappingMetaData.Factory getFactory(IMappingMetaDataRegistry mappingMetaDataRegistry) {
        return mappingMetaDataRegistry.getMappingMetaDataFactory(this);
    }

    @Override
    public List<IMappingMetaData> getImports() {
        if (this.imports != null) {
            return this.imports;
        }
        return this.getImports(new Stack<IMappingMetaData>());
    }

    @Override
    public List<IMappingMetaData> getImports(Stack<IMappingMetaData> forMappingMetaDatas) {
        if (this.imports == null) {
            if (forMappingMetaDatas.contains(this)) {
                Activator.logError("Cyclic mapping import for " + this, null);
            } else {
                forMappingMetaDatas.push(this);
                List<IMappingMetaData> computedImports = this.computeImports(forMappingMetaDatas);
                computedImports.add(this);
                this.imports = Collections.unmodifiableList(computedImports);
                forMappingMetaDatas.pop();
            }
        }
        return this.imports;
    }

    @Override
    public List<IMappingMetaData> getMerges() {
        if (this.merges == null) {
            this.merges = Collections.unmodifiableList(this.computeMerges());
        }
        return this.merges;
    }

    public String toString() {
        return "Mapping(" + this.adaptingEPackage.getName() + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Factory
    extends AdaptingEFactory
    implements IMappingMetaData.Factory {
        protected final IMappingMetaDataRegistry.Install mappingMetaDataRegistry;
        protected final IMappingMetaData mappingMetaData;

        protected Factory(IMappingMetaDataRegistry.Install mappingMetaDataRegistry, IMappingMetaData mappingMetaData) {
            super(mappingMetaData.getAdaptingEPackage());
            this.mappingMetaDataRegistry = mappingMetaDataRegistry;
            this.mappingMetaData = mappingMetaData;
            mappingMetaDataRegistry.addMappingMetaData(this);
        }

        public EObject create(EClass adaptingClass) {
            throw new IllegalArgumentException("Creation of class '" + adaptingClass.getName() + "' objects is not supported");
        }

        protected EObject getAdapter(EObject ecoreObject) {
            return this.mappingMetaDataRegistry.getAdapter(ecoreObject);
        }

        public EStructuralFeatureMap<? extends EStructuralFeature> getFeatureMap(EClass ecoreEClass, EStructuralFeature ecoreFeature) {
            return this.mappingMetaDataRegistry.getEcoreEStructuralFeatureMap(ecoreFeature);
        }

        @Override
        public IMappingMetaData getMappingMetaData() {
            return this.mappingMetaData;
        }

        @Override
        public IMappingMetaDataRegistry getMappingMetaDataRegistry() {
            return this.mappingMetaDataRegistry;
        }

        public String toString() {
            return "Factory(" + this.mappingMetaData + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportComparator
    implements Comparator<IMappingMetaData> {
        public static final ImportComparator INSTANCE = new ImportComparator();

        @Override
        public int compare(IMappingMetaData o1, IMappingMetaData o2) {
            List<IMappingMetaData> s1 = o1.getImports();
            List<IMappingMetaData> s2 = o2.getImports();
            if (s2.containsAll(s1)) {
                return -1;
            }
            if (s1.containsAll(s2)) {
                return 1;
            }
            return 0;
        }
    }

    public static class RegistryFactory
    implements IMappingMetaDataRegistry.RegistryFactory {
        public IMappingMetaDataRegistry createMappingMetaDataRegistry(EPackage rootEPackage, AdaptingXMIResourceFactory resourceAdapterFactory) {
            return new MappingMetaDataRegistry(rootEPackage, resourceAdapterFactory);
        }
    }
}

