/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lpg.runtime.Monitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.CollectionTypeCS;
import org.eclipse.ocl.cst.IterateExpCS;
import org.eclipse.ocl.cst.IteratorExpCS;
import org.eclipse.ocl.cst.LetExpCS;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.ocl.cst.OperationCallExpCS;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.PrimitiveTypeCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.cst.TupleTypeCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.LetExp;
import org.eclipse.ocl.ecore.LoopExp;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.parser.AbstractOCLAnalyzer;
import org.eclipse.ocl.parser.AbstractOCLParser;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.parser.environment.ICSTEnvironment;
import org.eclipse.qvt.declarative.parser.qvt.cst.IdentifiedCS;
import org.eclipse.qvt.declarative.parser.qvt.cst.IdentifierCS;
import org.eclipse.qvt.declarative.parser.qvt.environment.IQVTNodeEnvironment;
import org.eclipse.qvt.declarative.parser.qvt.environment.MoreEcoreForeignMethods;
import org.eclipse.qvt.declarative.parser.utils.CSTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQVTAnalyzer<E extends IQVTNodeEnvironment>
extends AbstractOCLAnalyzer<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> {
    private Monitor monitor;
    private EClass iteratorsClass = null;

    public AbstractQVTAnalyzer(AbstractOCLParser parser, Monitor monitor) {
        super(parser);
        this.monitor = monitor;
    }

    public void ERROR(ICSTEnvironment env, CSTNode cstNode, String rule, String problemMessage) {
        CSTUtils.setASTErrorNode(cstNode, problemMessage);
        this.ERROR(cstNode, rule, problemMessage);
    }

    public void WARNING(ICSTEnvironment env, CSTNode cstNode, String rule, String problemMessage) {
        CSTUtils.setASTErrorNode(cstNode, problemMessage);
        this.WARNING(cstNode, rule, problemMessage);
    }

    public void WARNING(Object problemObject, String rule, String problemMessage) {
        this.getEnvironment().analyzerWarning(problemMessage, rule, problemObject);
    }

    protected boolean assignableElementToFrom(EClassifier variableType, EClassifier initialiserType) {
        if (variableType == null) {
            return false;
        }
        if (initialiserType == null) {
            return false;
        }
        if (variableType == initialiserType) {
            return true;
        }
        return initialiserType instanceof EClass && variableType instanceof EClass && ((EClass)variableType).isSuperTypeOf((EClass)initialiserType);
    }

    protected boolean assignableToFrom(EClassifier variableType, EClassifier initialiserType) {
        if (variableType == null) {
            return false;
        }
        if (initialiserType == null) {
            return false;
        }
        if (variableType == initialiserType) {
            return true;
        }
        CollectionKind variableKind = null;
        EClassifier variableElementType = variableType;
        if (variableType instanceof CollectionType) {
            variableKind = ((CollectionType)variableType).getKind();
            variableElementType = (EClassifier)((CollectionType)variableType).getElementType();
        }
        CollectionKind initialiserKind = null;
        EClassifier initialiserElementType = initialiserType;
        if (initialiserType instanceof CollectionType) {
            initialiserKind = ((CollectionType)initialiserType).getKind();
            initialiserElementType = (EClassifier)((CollectionType)initialiserType).getElementType();
        }
        if (!this.assignableElementToFrom(variableElementType, initialiserElementType)) {
            return false;
        }
        if (initialiserKind == null) {
            return true;
        }
        return variableKind != null;
    }

    protected abstract E createdNestedEnvironment(CSTNode var1, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> var2);

    protected OperationCallExp<EClassifier, EOperation> genOperationCallExp(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, OperationCallExpCS operationCallExpCS, String rule, String operName, OCLExpression<EClassifier> source, EClassifier ownerType, List<OCLExpression<EClassifier>> args) {
        OperationCallExp opCall = super.genOperationCallExp(env, operationCallExpCS, rule, operName, source, (Object)ownerType, args);
        if (source != null && source.getType() == this.getStandardLibrary().getString() && "+".equals(operName)) {
            opCall.setOperationCode(OCLStandardLibraryUtil.getOperationCode((String)"concat"));
        }
        return opCall;
    }

    protected void resolveIteratorOperation(SimpleNameCS simpleNameCS, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
        if (this.iteratorsClass == null) {
            EPackage iteratorsPackage = EcoreFactory.eINSTANCE.createEPackage();
            iteratorsPackage.setName("iterators");
            this.iteratorsClass = EcoreFactory.eINSTANCE.createEClass();
            this.iteratorsClass.setName("Iterators");
            iteratorsPackage.getEClassifiers().add((Object)this.iteratorsClass);
        }
        EOperation oper = EcoreFactory.eINSTANCE.createEOperation();
        oper.setName(simpleNameCS.getValue());
        this.iteratorsClass.getEOperations().add((Object)oper);
        simpleNameCS.setAst((Object)oper);
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    protected EClassifier getTypeType(CSTNode cstNode, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, EClassifier type) {
        if (type instanceof Transformation) {
            return type;
        }
        return (EClassifier)super.getTypeType(cstNode, env, (Object)type);
    }

    protected String identifierCS(IdentifierCS identifierCS) {
        return identifierCS != null ? identifierCS.getValue() : null;
    }

    protected boolean isCancelled() {
        return this.monitor != null ? this.monitor.isCancelled() : false;
    }

    protected boolean isLocallyDefined(Variable variable) {
        EObject container = variable.eContainer();
        if (container instanceof LetExp) {
            return true;
        }
        return container instanceof LoopExp;
    }

    protected IterateExp<EClassifier, EParameter> iterateExpCS(IterateExpCS iterateExpCS, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
        return super.iterateExpCS(iterateExpCS, this.createdNestedEnvironment((CSTNode)iterateExpCS, env));
    }

    protected IteratorExp<EClassifier, EParameter> iteratorExpCS(IteratorExpCS iteratorExpCS, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
        return super.iteratorExpCS(iteratorExpCS, this.createdNestedEnvironment((CSTNode)iteratorExpCS, env));
    }

    protected OCLExpression<EClassifier> letExp(LetExpCS letExpCS, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
        return super.letExp(letExpCS, this.createdNestedEnvironment((CSTNode)letExpCS, env));
    }

    @Deprecated
    protected EClassifier lookupClassifier(CSTNode cstNode, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, List<String> className) {
        return this.lookupClassifier(cstNode, (IQVTNodeEnvironment)env, className);
    }

    protected EClassifier lookupClassifier(CSTNode cstNode, E env, List<String> className) {
        EClassifier classifier = null;
        try {
            classifier = (EClassifier)env.tryLookupClassifier(className);
        }
        catch (LookupException e) {
            this.ERROR(cstNode, "lookupClassifier", env.formatLookupException(e));
            List matches = e.getAmbiguousMatches();
            Collections.sort(matches, new Comparator<EClassifier>(){

                @Override
                public int compare(EClassifier o1, EClassifier o2) {
                    String n1 = String.valueOf(EcoreUtil.getURI((EObject)o1));
                    String n2 = String.valueOf(EcoreUtil.getURI((EObject)o2));
                    return n1.compareTo(n2);
                }
            });
            classifier = matches.isEmpty() ? env.getUnresolvedEnvironment().getUnresolvedEClass(className) : (EClassifier)matches.get(0);
        }
        cstNode.setAst((Object)classifier);
        return classifier;
    }

    @Deprecated
    protected EOperation lookupOperation(CSTNode cstNode, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) {
        return this.lookupOperation(cstNode, (IQVTNodeEnvironment)env, owner, name, args);
    }

    protected EOperation lookupOperation(CSTNode cstNode, E env, EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) {
        EOperation operation = null;
        try {
            operation = (EOperation)env.tryLookupOperation((Object)owner, name, args);
        }
        catch (LookupException e) {
            this.ERROR(cstNode, "lookupOperation", env.formatLookupException(e));
            List matches = e.getAmbiguousMatches();
            EOperation eOperation = operation = matches.isEmpty() ? env.getUnresolvedEnvironment().getUnresolvedEOperation(owner, name) : (EOperation)matches.get(0);
        }
        if (cstNode != null) {
            cstNode.setAst((Object)operation);
        }
        return operation;
    }

    @Deprecated
    protected EStructuralFeature lookupProperty(CSTNode cstNode, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, EClassifier owner, String name) {
        return this.lookupProperty(cstNode, (IQVTNodeEnvironment)env, owner, name);
    }

    protected EStructuralFeature lookupProperty(CSTNode cstNode, E env, EClassifier owner, String name) {
        try {
            return (EStructuralFeature)env.tryLookupProperty((Object)owner, name);
        }
        catch (LookupException e) {
            this.ERROR(cstNode, "lookupProperty", env.formatLookupException(e));
            List matches = e.getAmbiguousMatches();
            return matches.isEmpty() ? env.getUnresolvedEnvironment().getUnresolvedEReference(owner, name) : (EStructuralFeature)matches.get(0);
        }
    }

    protected OCLExpression<EClassifier> oclExpressionCS(OCLExpressionCS oclExpressionCS, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
        try {
            return super.oclExpressionCS(oclExpressionCS, env);
        }
        catch (Exception e) {
            this.ERROR(oclExpressionCS, "oclExpressionCS", "Failed to parse expression : " + e.getClass().getName() + " - " + e.getMessage());
            e.printStackTrace();
            return this.createDummyInvalidLiteralExp(env, (CSTNode)oclExpressionCS);
        }
    }

    protected EClass resolveClass(E env, String rule, TypeCS typeCS) {
        EClassifier referredClassifier = (EClassifier)this.typeCS(typeCS, (Environment)env);
        if (referredClassifier instanceof EClass) {
            if (env.isResolved((EObject)referredClassifier)) {
                return (EClass)referredClassifier;
            }
        } else if (referredClassifier == null) {
            this.ERROR(typeCS, rule, "Missing class");
        } else if (referredClassifier != env.getOCLStandardLibrary().getOclVoid() && env.isResolved((EObject)referredClassifier)) {
            this.ERROR(typeCS, rule, "Non Class type '" + this.formatType(referredClassifier) + "'");
        }
        return env.getUnresolvedEnvironment().getUnresolvedEClass((EClassifier)null);
    }

    protected EClassifier resolveClassifier(E env, String rule, TypeCS typeCS) {
        E typeEnv = env;
        EClassifier referredClassifier = (EClassifier)this.typeCS(typeCS, (Environment)typeEnv);
        if (referredClassifier != null) {
            if (!(referredClassifier instanceof CollectionType)) {
                return referredClassifier;
            }
            if (((CollectionType)referredClassifier).getElementType() == null) {
                this.ERROR(typeCS, "typeCS", "Undefined element type");
                ((CollectionType)referredClassifier).setElementType((Object)env.getUnresolvedEnvironment().getUnresolvedEClass(referredClassifier));
            }
            return referredClassifier;
        }
        StringBuffer s = new StringBuffer();
        if (typeCS instanceof PrimitiveTypeCS) {
            String name = ((PrimitiveTypeCS)typeCS).getValue();
            s.append("Undefined primitive type '" + name + "'");
            this.ERROR(typeCS, rule, s.toString());
            return env.getUnresolvedEnvironment().getUnresolvedEDataType(null, name);
        }
        if (typeCS instanceof PathNameCS) {
            s.append("Undefined type '");
            boolean isFirst = true;
            EList names = AbstractQVTAnalyzer.createSequenceOfNames((PathNameCS)((PathNameCS)typeCS), null);
            for (String name : names) {
                if (!isFirst) {
                    s.append("::");
                }
                s.append(name);
                isFirst = false;
            }
            s.append("'");
            this.ERROR(typeCS, rule, s.toString());
            return env.getUnresolvedEnvironment().getUnresolvedEClass((List<String>)names);
        }
        if (typeCS instanceof CollectionTypeCS) {
            s.append("Undefined collection type '" + ((CollectionTypeCS)typeCS).getCollectionTypeIdentifier() + "'");
            this.ERROR(typeCS, rule, s.toString());
            return env.getUnresolvedEnvironment().getUnresolvedEClass((EClassifier)null);
        }
        if (typeCS instanceof TupleTypeCS) {
            s.append("Undefined tuple type");
            this.ERROR(typeCS, rule, s.toString());
            return env.getUnresolvedEnvironment().getUnresolvedEClass((EClassifier)null);
        }
        s.append("Undefined ");
        this.ERROR(typeCS, rule, s.toString());
        return env.getUnresolvedEnvironment().getUnresolvedEClass((EClassifier)null);
    }

    protected EDataType resolveDataType(E env, String rule, TypeCS typeCS) {
        E typeEnv = env;
        EClassifier referredClassifier = (EClassifier)this.typeCS(typeCS, (Environment)typeEnv);
        if (referredClassifier instanceof EDataType) {
            return (EDataType)referredClassifier;
        }
        if (referredClassifier != null) {
            if (env.isResolved((EObject)referredClassifier)) {
                this.ERROR(typeCS, rule, "Non Primitive type '" + this.formatType(referredClassifier) + "'");
            }
            return env.getUnresolvedEnvironment().getUnresolvedEDataType(referredClassifier.getEPackage(), referredClassifier.getName());
        }
        this.ERROR(typeCS, rule, "Missing primitive type");
        return env.getUnresolvedEnvironment().getUnresolvedEDataType(null, null);
    }

    protected EStructuralFeature resolveForwardProperty(E env, EClass parentType, String rule, IdentifiedCS propertyIdCS) {
        if (parentType == null) {
            return null;
        }
        String propertyName = this.identifierCS(propertyIdCS.getIdentifier());
        return MoreEcoreForeignMethods.getEStructuralFeature(parentType, propertyName);
    }

    protected EReference resolveReverseProperty(E env, EClass parentType, String rule, IdentifiedCS propertyIdCS) {
        EReference referredProperty;
        if (parentType == null) {
            return null;
        }
        String propertyName = this.identifierCS(propertyIdCS.getIdentifier());
        try {
            referredProperty = env.tryLookupOppositeProperty(parentType, propertyName);
            if (referredProperty == null && AbstractQVTAnalyzer.isEscaped((String)propertyName)) {
                referredProperty = env.tryLookupOppositeProperty(parentType, AbstractQVTAnalyzer.unescape((String)propertyName));
            }
        }
        catch (LookupException e) {
            env.analyzerError(env.formatLookupException(e), "lookup", (Object)propertyIdCS);
            List ambiguousMatches = e.getAmbiguousMatches();
            referredProperty = ambiguousMatches.size() > 0 ? (EReference)ambiguousMatches.get(0) : env.getUnresolvedEnvironment().getUnresolvedEReference((EClassifier)parentType, propertyName);
        }
        return referredProperty;
    }

    protected EStructuralFeature resolveUnresolvedProperty(E env, EClass parentType, String rule, IdentifiedCS propertyIdCS) {
        if (parentType == null) {
            return null;
        }
        String propertyName = this.identifierCS(propertyIdCS.getIdentifier());
        if (env.isResolved((EObject)parentType)) {
            this.ERROR(propertyIdCS, rule, "No '" + this.formatString(propertyName) + "' property in '" + this.formatName(parentType) + "'");
        }
        return env.getUnresolvedEnvironment().getUnresolvedEReference((EClassifier)parentType, propertyName);
    }

    protected OCLExpression<EClassifier> simpleNameCS(SimpleNameCS simpleNameCS, Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, OCLExpression<EClassifier> source) {
        if (source instanceof InvalidLiteralExp) {
            return source;
        }
        return super.simpleNameCS(simpleNameCS, this.createdNestedEnvironment((CSTNode)simpleNameCS, env), source);
    }
}

