/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.language;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.editor.EditorInputUtils;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageValidator;
import org.eclipse.imp.preferences.PreferenceCache;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageRegistry {
    private static Object sStatusCheckMutex = new Object();
    private static boolean sIsFullyInitialized = false;
    private static Map<String, Language> sRegister;
    private static IEditorDescriptor sUniversalEditor;
    private static EditorRegistry sEditorRegistry;

    private LanguageRegistry() {
    }

    private static Map<String, Language> getRegister() {
        if (sRegister == null) {
            sRegister = new HashMap<String, Language>();
        }
        return sRegister;
    }

    private static void preInitEditorRegistry() {
        try {
            sEditorRegistry = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
            LanguageRegistry.initializeUniversalEditorDescriptor(sEditorRegistry);
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.imp.runtime", "languageDescription");
            if (extensionPoint == null) {
                ErrorHandler.reportError("IMP language descriptor extension point 'org.eclipse.imp.runtime.languageDescription' non-existent?");
            } else {
                IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
                if (elements != null) {
                    IConfigurationElement[] iConfigurationElementArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement element = iConfigurationElementArray[n2];
                        Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
                        if (bundle != null) {
                            LanguageRegistry.register(new Language(element));
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (InvalidRegistryObjectException e) {
            if (PreferenceCache.emitMessages) {
                RuntimePlugin.getInstance().logException("IMP LanguageRegistry error in preInitEditorRegistry()", e);
            }
            ErrorHandler.reportError("IMP LanguageRegistry error", e);
        }
    }

    public static Language findLanguage(IEditorInput editorInput, IDocumentProvider docProvider) {
        if (!sIsFullyInitialized) {
            LanguageRegistry.initializeRegistryAsNeeded();
        }
        IPath path = EditorInputUtils.getPath(editorInput);
        return LanguageRegistry.findLanguage(path, docProvider.getDocument((Object)editorInput));
    }

    public static Language findLanguage(IPath path, IDocument doc) {
        String docContents;
        if (!LanguageRegistry.isFullyInitialized()) {
            LanguageRegistry.initializeRegistryAsNeeded();
        }
        String extension = path.getFileExtension();
        String string = docContents = doc != null ? doc.get() : null;
        if (extension != null) {
            for (Language lang : LanguageRegistry.getRegister().values()) {
                if (!lang.hasExtension(extension)) continue;
                LanguageValidator validator = lang.getValidator();
                if (validator != null && docContents != null) {
                    if (!validator.validate(docContents)) continue;
                    return lang;
                }
                return lang;
            }
        }
        if (PreferenceCache.emitMessages) {
            RuntimePlugin.getInstance().writeErrorMsg("No language support for text/source file of type '" + extension + "'.");
        } else {
            ErrorHandler.reportError("No language support for text/source file of type '" + extension + "'.");
        }
        return null;
    }

    public static Language findLanguageByNature(String natureID) {
        if (!LanguageRegistry.isFullyInitialized()) {
            LanguageRegistry.initializeRegistryAsNeeded();
        }
        for (Language lang : LanguageRegistry.getRegister().values()) {
            String aNatureID = lang.getNatureID();
            if (aNatureID == null || !aNatureID.equals(natureID)) continue;
            return lang;
        }
        return null;
    }

    public static Collection<Language> getLanguages() {
        if (!LanguageRegistry.isFullyInitialized()) {
            LanguageRegistry.initializeRegistryAsNeeded();
        }
        return Collections.unmodifiableCollection(LanguageRegistry.getRegister().values());
    }

    public static Language findLanguage(String languageName) {
        if (!LanguageRegistry.isFullyInitialized()) {
            LanguageRegistry.initializeRegistryAsNeeded();
        }
        return LanguageRegistry.getRegister().get(languageName.toLowerCase());
    }

    public static void registerLanguage(Language language) {
        if (!LanguageRegistry.isFullyInitialized()) {
            LanguageRegistry.initializeRegistryAsNeeded();
        }
        LanguageRegistry.register(language);
        ArrayList<IFileEditorMapping> mappings = new ArrayList<IFileEditorMapping>();
        Collections.addAll(mappings, LanguageRegistry.getEditorRegistry().getFileEditorMappings());
        LanguageRegistry.addUniversalEditorMappings(language.getName(), language.getIconPath(), language.getFilenameExtensions(), language.getBundleID(), mappings);
        LanguageRegistry.updateEditorRegistry(mappings);
    }

    private static EditorRegistry getEditorRegistry() {
        return sEditorRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeRegistryAsNeeded() {
        Object object = sStatusCheckMutex;
        synchronized (object) {
            if (LanguageRegistry.isFullyInitialized()) {
                return;
            }
            LanguageRegistry.preInitEditorRegistry();
            if (PreferenceCache.emitMessages) {
                RuntimePlugin.getInstance().writeInfoMsg("Looking for IMP language description extensions...");
            }
            ArrayList<IFileEditorMapping> newMap = new ArrayList<IFileEditorMapping>();
            LanguageRegistry.addNonUniversalEditorMappings(newMap);
            for (Language lang : LanguageRegistry.getRegister().values()) {
                LanguageRegistry.addUniversalEditorMappings(lang.getName(), lang.getIconPath(), lang.getFilenameExtensions(), lang.getBundleID(), newMap);
            }
            LanguageRegistry.updateEditorRegistry(newMap);
            LanguageRegistry.setFullyInitialized();
        }
    }

    private static void addNonUniversalEditorMappings(List<IFileEditorMapping> newMap) {
        IFileEditorMapping[] iFileEditorMappingArray = LanguageRegistry.getEditorRegistry().getFileEditorMappings();
        int n = iFileEditorMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFileEditorMapping mapping = iFileEditorMappingArray[n2];
            IEditorDescriptor defaultEditor = mapping.getDefaultEditor();
            if (defaultEditor == null || !defaultEditor.getId().equals("org.eclipse.imp.runtime.impEditor")) {
                newMap.add(mapping);
            }
            ++n2;
        }
    }

    private static void addUniversalEditorMappings(String langName, String langIcon, Iterable<String> extensions, String bundleID, List<IFileEditorMapping> newMap) {
        IFileEditorMapping[] mappings = sEditorRegistry.getFileEditorMappings();
        for (String ext : extensions) {
            Object mapping = LanguageRegistry.findMappingFor(ext, mappings);
            if (mapping == null || mapping != null && mapping.getDefaultEditor() != null && mapping.getDefaultEditor().getId().equals(sUniversalEditor.getId())) {
                mapping = new IMPFileEditorMapping(langName, ext, langIcon, bundleID);
            }
            IEditorDescriptor defaultEditor = mapping.getDefaultEditor();
            FileEditorMapping fem = (FileEditorMapping)mapping;
            if (defaultEditor == null || defaultEditor.getId().equals("")) {
                fem.setDefaultEditor((EditorDescriptor)sUniversalEditor);
            } else {
                IEditorDescriptor editor;
                boolean gotIt = false;
                IEditorDescriptor[] iEditorDescriptorArray = fem.getEditors();
                int n = iEditorDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    editor = iEditorDescriptorArray[n2];
                    if (editor == sUniversalEditor) {
                        gotIt = true;
                        break;
                    }
                    ++n2;
                }
                if (!gotIt) {
                    iEditorDescriptorArray = fem.getEditors();
                    n = iEditorDescriptorArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        editor = iEditorDescriptorArray[n2];
                        EditorDescriptor edDesc = (EditorDescriptor)editor;
                        String edClassName = edDesc.getClassName();
                        IConfigurationElement edElem = edDesc.getConfigurationElement();
                        Bundle edBundle = Platform.getBundle((String)edElem.getNamespaceIdentifier());
                        try {
                            Class edClass = edBundle.loadClass(edClassName);
                            if (UniversalEditor.class.isAssignableFrom(edClass)) {
                                gotIt = true;
                                break;
                            }
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        ++n2;
                    }
                }
                if (!gotIt) {
                    fem.addEditor((EditorDescriptor)sUniversalEditor);
                }
            }
            newMap.add((IFileEditorMapping)mapping);
        }
    }

    private void addEditorIfNeeded(IMPFileEditorMapping fem, EditorDescriptor editor) {
        boolean gotIt = false;
        IEditorDescriptor[] iEditorDescriptorArray = fem.getEditors();
        int n = iEditorDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorDescriptor fileEditor = iEditorDescriptorArray[n2];
            if (fileEditor.getId().equals(editor.getId())) {
                gotIt = true;
                break;
            }
            ++n2;
        }
        if (!gotIt) {
            fem.addEditor(editor);
        }
    }

    private static IFileEditorMapping findMappingFor(String ext, IFileEditorMapping[] mappings) {
        int i = 0;
        while (i < mappings.length) {
            if (mappings[i].getExtension().equals(ext)) {
                return mappings[i];
            }
            ++i;
        }
        return null;
    }

    private static void updateEditorRegistry(final List<IFileEditorMapping> newMap) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LanguageRegistry.getEditorRegistry().setFileEditorMappings(newMap.toArray(new FileEditorMapping[newMap.size()]));
                LanguageRegistry.getEditorRegistry().saveAssociations();
            }
        });
    }

    private static List<String> collectAllLanguageFileNameExtensions() {
        ArrayList<String> allExtens = new ArrayList<String>(LanguageRegistry.getRegister().size());
        for (Language lang : LanguageRegistry.getRegister().values()) {
            allExtens.addAll(lang.getFilenameExtensions());
        }
        return allExtens;
    }

    private static void initializeUniversalEditorDescriptor(EditorRegistry editorRegistry) {
        IEditorDescriptor[] allEditors;
        IEditorDescriptor[] iEditorDescriptorArray = allEditors = editorRegistry.getSortedEditorsFromPlugins();
        int n = allEditors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorDescriptor editor = iEditorDescriptorArray[n2];
            if (editor.getId().equals("org.eclipse.imp.runtime.impEditor")) {
                sUniversalEditor = editor;
                if (PreferenceCache.emitMessages) {
                    RuntimePlugin.getInstance().writeInfoMsg("Universal editor descriptor: " + sUniversalEditor.getId() + ":" + sUniversalEditor.getLabel());
                }
                return;
            }
            ++n2;
        }
        if (sUniversalEditor == null) {
            if (PreferenceCache.emitMessages) {
                RuntimePlugin.getInstance().writeErrorMsg("IMP LanguageRegistry error in initializeUniversalEditorDescroptor(): unable to initialize UniversalEditor");
            } else {
                ErrorHandler.reportError("Unable to locate Universal Editor descriptor", null);
            }
        }
    }

    private static void register(Language language) {
        LanguageRegistry.getRegister().put(language.getName().toLowerCase(), language);
        if (PreferenceCache.emitMessages) {
            RuntimePlugin.getInstance().writeInfoMsg("Registered language description: " + language.getName());
        }
    }

    private static void setFullyInitialized() {
        sIsFullyInitialized = true;
    }

    private static boolean isFullyInitialized() {
        return sIsFullyInitialized;
    }

    public static class BundleImageDescriptor
    extends ImageDescriptor {
        private final Bundle bundle;
        private final String iconPath;
        private final String langName;

        public BundleImageDescriptor(String iconPath, Bundle bundle, String langName) {
            this.langName = langName;
            this.bundle = bundle;
            this.iconPath = iconPath;
        }

        public ImageData getImageData() {
            ImageData result;
            block13: {
                InputStream in = this.getStream();
                result = null;
                if (in != null) {
                    try {
                        try {
                            result = new ImageData(in);
                        }
                        catch (SWTException e) {
                            if (e.code != 40) {
                                throw e;
                            }
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return result;
        }

        private InputStream getStream() {
            InputStream is = null;
            try {
                if (this.iconPath != null) {
                    is = this.bundle.getResource(this.iconPath).openStream();
                }
            }
            catch (IOException e) {
                RuntimePlugin.getInstance().logException("Unable to find icon for language " + this.langName, e);
                return null;
            }
            if (is == null) {
                return null;
            }
            return new BufferedInputStream(is);
        }
    }

    private static class IMPFileEditorMapping
    extends FileEditorMapping {
        private ImageDescriptor fImageDescriptor;
        private IEditorDescriptor fEditor;

        public IMPFileEditorMapping(String langName, String extension, String iconPath, String bundleID) {
            super(extension);
            Bundle bundle = Platform.getBundle((String)bundleID);
            this.fImageDescriptor = new BundleImageDescriptor(iconPath, bundle, langName);
        }

        public void setTheDefaultEditor(IEditorDescriptor editor) {
            this.fEditor = editor;
        }

        public IEditorDescriptor getDefaultEditor() {
            return this.fEditor;
        }

        public ImageDescriptor getImageDescriptor() {
            return this.fImageDescriptor;
        }
    }
}

