/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.evaluation.EvaluationCache;
import org.eclipse.ocl.pivot.internal.values.SetValueImpl;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.SetValue;
import org.eclipse.qvtd.runtime.evaluation.AbstractObjectManager;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.AbstractTypedModelInstance;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.DefaultInterval;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitable;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.InvalidEvaluationException;
import org.eclipse.qvtd.runtime.evaluation.InvocationFailedException;
import org.eclipse.qvtd.runtime.evaluation.InvocationManager;
import org.eclipse.qvtd.runtime.evaluation.ModeFactory;
import org.eclipse.qvtd.runtime.evaluation.ObjectManager;
import org.eclipse.qvtd.runtime.evaluation.TransformationExecutor;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.eclipse.qvtd.runtime.internal.evaluation.IncrementalInvocationManager;
import org.eclipse.qvtd.runtime.internal.evaluation.IncrementalObjectManager;
import org.eclipse.qvtd.runtime.internal.evaluation.LazyInvocationManager;
import org.eclipse.qvtd.runtime.internal.evaluation.LazyObjectManager;

public abstract class AbstractTransformerInternal
implements Transformer,
ExecutionVisitable {
    private static final @NonNull List<@NonNull Integer> EMPTY_INDEX_LIST = Collections.emptyList();
    private static final @NonNull List<@NonNull Object> EMPTY_EOBJECT_LIST = Collections.emptyList();
    protected final @NonNull TransformationExecutor executor;
    @Deprecated
    protected final @NonNull Evaluator evaluator;
    protected final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IdResolver.IdResolverExtension idResolver;
    protected final @NonNull Model @NonNull [] models;
    protected final @NonNull Map<@NonNull String, @NonNull Integer> modelIndexes = new HashMap<String, Integer>();
    protected final boolean debugAssignments = AbstractTransformer.ASSIGNMENTS.isActive();
    protected final boolean debugCreations = AbstractTransformer.CREATIONS.isActive();
    protected final boolean debugExceptions = AbstractTransformer.EXCEPTIONS.isActive();
    protected final boolean debugGettings = AbstractTransformer.GETTINGS.isActive();
    protected final boolean debugInvocations = AbstractTransformer.INVOCATIONS.isActive();
    private final @NonNull PropertyId @Nullable [] propertyIndex2propertyId;
    private final @Nullable Map<PropertyId, Integer> propertyId2propertyIndex;
    private final @Nullable EReference @Nullable [] propertyIndex2eReference;
    private final @NonNull Map<@NonNull Object, @NonNull Object> @Nullable [] object2oppositeObject;
    private final @NonNull Map<@NonNull ClassId, @NonNull Integer> classId2classIndex;
    private final @NonNull Map<@NonNull ClassId, @NonNull Set<@NonNull Integer>> classId2classIndexes;
    protected final @NonNull InvocationManager invocationManager;
    protected final @NonNull ObjectManager objectManager;
    protected final @NonNull EvaluationCache evaluationCache;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected AbstractTransformerInternal(@NonNull TransformationExecutor executor, @NonNull String @NonNull [] modelNames, @NonNull PropertyId @Nullable [] propertyIndex2propertyId, @NonNull ClassId @NonNull [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes) {
        this.executor = executor;
        this.evaluator = executor;
        this.idResolver = (IdResolver.IdResolverExtension)executor.getIdResolver();
        this.invocationManager = this.createInvocationManager();
        this.objectManager = this.createObjectManager();
        this.evaluationCache = this.createEvaluationCache();
        this.models = new Model[modelNames.length];
        Interval rootInterval = this.lazyCreateInterval(0);
        int i = 0;
        while (i < modelNames.length) {
            String modelName = modelNames[i];
            this.models[i] = this.createModel(modelName, propertyIndex2propertyId, classIndex2classId, classIndex2allClassIndexes, rootInterval);
            this.modelIndexes.put(modelName, i);
            ++i;
        }
        if (propertyIndex2propertyId != null) {
            int propertyIds = propertyIndex2propertyId.length;
            this.propertyIndex2propertyId = propertyIndex2propertyId;
            HashMap<@NonNull PropertyId, @NonNull Integer> propertyId2propertyIndex2 = new HashMap<PropertyId, Integer>(propertyIds);
            this.propertyId2propertyIndex = propertyId2propertyIndex2;
            this.propertyIndex2eReference = new EReference[propertyIds];
            int propertyIndex = 0;
            while (propertyIndex < propertyIds) {
                PropertyId propertyId = propertyIndex2propertyId[propertyIndex];
                propertyId2propertyIndex2.put(propertyId, propertyIndex);
                ++propertyIndex;
            }
            @NonNull @NonNull @NonNull Map @Nullable [] object2oppositeObject = new HashMap[propertyIds];
            this.object2oppositeObject = object2oppositeObject;
            int i2 = 0;
            while (i2 < propertyIds) {
                object2oppositeObject[i2] = new HashMap();
                ++i2;
            }
        } else {
            this.propertyIndex2propertyId = null;
            this.propertyId2propertyIndex = null;
            this.propertyIndex2eReference = null;
            this.object2oppositeObject = null;
        }
        assert (classIndex2allClassIndexes != null);
        int classIds = classIndex2classId.length;
        this.classId2classIndex = new HashMap<ClassId, Integer>(classIds);
        this.classId2classIndexes = new HashMap<ClassId, Set<Integer>>(classIds);
        int classIndex = 0;
        while (classIndex < classIds) {
            ClassId classId = classIndex2classId[classIndex];
            this.classId2classIndex.put(classId, classIndex);
            HashSet<@NonNull Integer> superClassIndexes = new HashSet<Integer>();
            int[] nArray = classIndex2allClassIndexes[classIndex];
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int allClassIndex = nArray[n2];
                superClassIndexes.add(allClassIndex);
                ++n2;
            }
            this.classId2classIndexes.put(classId, superClassIndexes);
            ++classIndex;
        }
    }

    @Override
    public <R> R accept(@NonNull ExecutionVisitor<R> visitor) {
        return visitor.visitTransformer(this);
    }

    @Override
    public void addRootObjects(@NonNull String modelName, @NonNull Iterable<@NonNull ? extends Object> eRootObjects) {
        this.getTypedModelInstance(modelName).addRootObjects(eRootObjects);
    }

    @Deprecated
    protected @NonNull Connection createConnection(@NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
        return this.createConnection(this.invocationManager.getRootInterval(), name, typeId, isStrict, this.getModeFactory());
    }

    protected @NonNull Connection createConnection(@NonNull Interval interval, @NonNull String name, @NonNull TypeId typeId, boolean isStrict, @NonNull ModeFactory modeFactory) {
        return interval.createConnection(name, typeId, isStrict, modeFactory);
    }

    protected @NonNull EvaluationCache createEvaluationCache() {
        return new EvaluationCache((Executor)this.executor);
    }

    protected @NonNull Interval createInterval(int intervalIndex) {
        return new DefaultInterval(this.getInvocationManager(), intervalIndex);
    }

    protected @NonNull InvocationManager createInvocationManager() {
        return new LazyInvocationManager(this.executor);
    }

    @Deprecated
    protected @NonNull Model createModel(@NonNull String modelName, @NonNull PropertyId @Nullable [] propertyIndex2propertyId, @NonNull ClassId @NonNull [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes) {
        return new Model(this, modelName, propertyIndex2propertyId, classIndex2classId, classIndex2allClassIndexes, this.getInvocationManager().getRootInterval());
    }

    protected @NonNull Model createModel(@NonNull String modelName, @NonNull PropertyId @Nullable [] propertyIndex2propertyId, @NonNull ClassId @NonNull [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes, @NonNull Interval rootInterval) {
        return new Model(this, modelName, propertyIndex2propertyId, classIndex2classId, classIndex2allClassIndexes, rootInterval);
    }

    @Deprecated
    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SetValue.Accumulator createUnenforcedSetAccumulatorValue(@NonNull CollectionTypeId typeId) {
        return new UnenforcedSetAccumulator(typeId);
    }

    protected @NonNull ObjectManager createObjectManager() {
        return new LazyObjectManager((LazyInvocationManager)this.invocationManager);
    }

    protected @NonNull TreeIterator<? extends Object> eAllContents(@NonNull Object object) {
        return ((EObject)object).eAllContents();
    }

    protected @NonNull EClass eClass(@NonNull Object object) {
        return ((EObject)object).eClass();
    }

    protected @Nullable Object eContainer(@NonNull Object object) {
        return ((EObject)object).eContainer();
    }

    protected @Nullable Object eGet(@NonNull Object object, @NonNull EStructuralFeature eFeature) {
        return ((EObject)object).eGet(eFeature);
    }

    public @NonNull Iterable<@NonNull Object> get(@NonNull Class type) {
        return this.models[0].getObjectsOfKind(type);
    }

    private @NonNull Set<@NonNull Integer> getClassIndexes(@NonNull EClass eClass) {
        EPackage ePackage = (EPackage)ClassUtil.nonNullEMF((Object)eClass.getEPackage());
        PackageId packageId = IdManager.getPackageId((EPackage)ePackage);
        String className = (String)ClassUtil.nonNullEMF((Object)eClass.getName());
        ClassId classId = packageId.getClassId(className, eClass.getETypeParameters().size());
        Map<@NonNull ClassId, @NonNull Set<@NonNull Integer>> classId2classIndexes2 = this.classId2classIndexes;
        assert (classId2classIndexes2 != null);
        Set<@NonNull Integer> classIndexes = classId2classIndexes2.get(classId);
        if (classIndexes == null) {
            classIndexes = new HashSet<Integer>();
            for (EClass eSuperClass : ClassUtil.nullFree((EList)eClass.getESuperTypes())) {
                Set<@NonNull Integer> partialResult = this.getClassIndexes(eSuperClass);
                classIndexes.addAll(partialResult);
            }
            classId2classIndexes2.put(classId, classIndexes);
        }
        return classIndexes;
    }

    @Override
    public @NonNull EvaluationCache getEvaluationCache() {
        return this.evaluationCache;
    }

    @Override
    public @NonNull TransformationExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public @NonNull InvocationManager getInvocationManager() {
        return this.invocationManager;
    }

    public @NonNull ModeFactory getModeFactory() {
        return ModeFactory.NON_INCREMENTAL;
    }

    @Override
    public @NonNull ObjectManager getObjectManager() {
        return this.objectManager;
    }

    private @NonNull List<@NonNull Integer> getOppositePropertyIndexes(@NonNull Map<@NonNull EReference, @NonNull Integer> eReference2propertyIndex, @NonNull EClass eClass) {
        List<@NonNull Integer> propertyIndexes = null;
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            if (!(eStructuralFeature instanceof EReference)) continue;
            EReference eReference = (EReference)eStructuralFeature;
            Integer propertyIndex = eReference2propertyIndex.get(eReference);
            if (propertyIndex == null) {
                if (!(eReference.getEOpposite() != null || eReference.isDerived() || eReference.isTransient() || eReference.isVolatile())) {
                    EClass eContainingClass = eReference.getEContainingClass();
                    EPackage ePackage = (EPackage)ClassUtil.nonNullEMF((Object)eContainingClass.getEPackage());
                    PackageId packageId = IdManager.getPackageId((EPackage)ePackage);
                    String className = (String)ClassUtil.nonNullEMF((Object)eContainingClass.getName());
                    ClassId classId = packageId.getClassId(className, eContainingClass.getETypeParameters().size());
                    String propertyName = (String)ClassUtil.nonNullEMF((Object)eReference.getName());
                    PropertyId propertyId = classId.getPropertyId(propertyName);
                    Map<PropertyId, Integer> propertyId2propertyIndex2 = this.propertyId2propertyIndex;
                    assert (propertyId2propertyIndex2 != null);
                    propertyIndex = propertyId2propertyIndex2.get(propertyId);
                }
                if (propertyIndex == null) {
                    propertyIndex = -1;
                }
                eReference2propertyIndex.put(eReference, propertyIndex);
            }
            if (propertyIndex < 0) continue;
            if (propertyIndexes == null) {
                propertyIndexes = new ArrayList<Integer>();
            }
            propertyIndexes.add(propertyIndex);
        }
        return propertyIndexes != null ? propertyIndexes : EMPTY_INDEX_LIST;
    }

    public @NonNull Collection<@NonNull EObject> getRootEObjects(@NonNull String modelName) {
        Model model = this.getTypedModelInstance(modelName);
        ArrayList<@NonNull EObject> rootEObjects = new ArrayList<EObject>();
        for (Object rootObject : model.getRootObjects()) {
            if (!(rootObject instanceof EObject)) continue;
            rootEObjects.add((EObject)rootObject);
        }
        return rootEObjects;
    }

    @Override
    public @NonNull Collection<@NonNull Object> getRootObjects(@NonNull String modelName) {
        return this.getTypedModelInstance(modelName).getRootObjects();
    }

    @Override
    public @NonNull Model getTypedModelInstance(@NonNull String modelName) {
        Integer modelIndex = this.modelIndexes.get(modelName);
        if (modelIndex == null) {
            throw new IllegalStateException("Unknown model name '" + modelName + "'");
        }
        return this.models[modelIndex];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleExecutionFailure(@NonNull String mappingName, @NonNull Throwable e) throws InvocationFailedException {
        if (e instanceof InvocationFailedException) {
            throw (InvocationFailedException)((Object)e);
        }
        if (e instanceof InvalidEvaluationException) {
            if (!this.debugExceptions) throw (InvalidEvaluationException)((Object)e);
            AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
            throw (InvalidEvaluationException)((Object)e);
        }
        if (e instanceof AssertionError) {
            if (!this.debugExceptions) throw (AssertionError)((Object)e);
            AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
        } else {
            if (e instanceof Error) {
                if (!this.debugExceptions) throw (Error)e;
                AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
                throw (Error)e;
            }
            if (e instanceof InvalidValueException) {
                if (this.debugExceptions) {
                    AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
                }
            } else if (e instanceof NullPointerException) {
                if (this.debugExceptions) {
                    AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
                }
            } else if (this.debugExceptions) {
                AbstractTransformer.EXCEPTIONS.println("Execution failure in '" + mappingName + "' : " + e);
            }
        }
        if (!(e instanceof Exception)) throw new InvalidEvaluationException(new RuntimeException(e));
        throw new InvalidEvaluationException((Exception)e);
    }

    protected @NonNull Interval lazyCreateInterval(int intervalIndex) {
        if (intervalIndex < 0) {
            return this.invocationManager.createInterval();
        }
        int i = this.invocationManager.getIntervalsSize();
        while (i < intervalIndex) {
            this.createInterval(i);
            ++i;
        }
        Interval interval = this.invocationManager.basicGetInterval(intervalIndex);
        return interval != null ? interval : this.createInterval(intervalIndex);
    }

    @Override
    public void setExternalURI(@NonNull String modelName, @NonNull URI modelURI) {
        Model model = this.getTypedModelInstance(modelName);
        for (Object object : model.getRootObjects()) {
            if (!(object instanceof org.eclipse.ocl.pivot.Model)) continue;
            ((org.eclipse.ocl.pivot.Model)object).setExternalURI(modelURI.toString());
        }
    }

    public @NonNull Object throwInvalidEvaluationException(@NonNull String message, Object ... bindings) {
        throw new InvalidEvaluationException(message, bindings);
    }

    protected @NonNull String toDebugString(@Nullable Object object) {
        return AbstractObjectManager.toDebugString(object);
    }

    public static abstract class Incremental
    extends AbstractTransformerInternal {
        protected Incremental(@NonNull TransformationExecutor executor, @NonNull String @NonNull [] modelNames, @NonNull PropertyId @Nullable [] propertyIndex2propertyId, @NonNull ClassId @NonNull [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes) {
            super(executor, modelNames, propertyIndex2propertyId, classIndex2classId, classIndex2allClassIndexes);
        }

        @Override
        @Deprecated
        protected @NonNull Connection createConnection(@NonNull String name, @NonNull TypeId typeId, boolean isStrict) {
            return this.createConnection(this.invocationManager.getRootInterval(), name, typeId, isStrict, ModeFactory.NON_INCREMENTAL);
        }

        @Override
        protected @NonNull Connection createConnection(@NonNull Interval interval, @NonNull String name, @NonNull TypeId typeId, boolean isStrict, @NonNull ModeFactory modeFactory) {
            return interval.createConnection(name, typeId, isStrict, modeFactory);
        }

        @Override
        protected @NonNull InvocationManager createInvocationManager() {
            return new IncrementalInvocationManager(this.executor);
        }

        @Override
        @Deprecated
        protected @NonNull Model createModel(@NonNull String modelName, @NonNull PropertyId @Nullable [] propertyIndex2propertyId, @NonNull ClassId @NonNull [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes) {
            return new Model.Incremental(this, modelName, propertyIndex2propertyId, classIndex2classId, classIndex2allClassIndexes, this.getInvocationManager().getRootInterval());
        }

        @Override
        protected @NonNull Model createModel(@NonNull String modelName, @NonNull PropertyId @Nullable [] propertyIndex2propertyId, @NonNull ClassId @NonNull [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes, @NonNull Interval rootInterval) {
            return new Model.Incremental(this, modelName, propertyIndex2propertyId, classIndex2classId, classIndex2allClassIndexes, rootInterval);
        }

        @Override
        protected @NonNull ObjectManager createObjectManager() {
            return new IncrementalObjectManager((IncrementalInvocationManager)this.invocationManager);
        }

        @Override
        public @NonNull ModeFactory getModeFactory() {
            return ModeFactory.INCREMENTAL;
        }
    }

    public static class Model
    extends AbstractTypedModelInstance {
        protected final @NonNull AbstractTransformerInternal transformer;
        protected final @NonNull String name;
        protected final @NonNull List<@NonNull Object> rootObjects = new ArrayList<Object>();
        protected final @NonNull List<@NonNull Object> potentialOrphanObjects = new ArrayList<Object>();
        protected final @NonNull Map<@NonNull EClass, @NonNull Set<@NonNull Integer>> eClass2allClassIndexes = new HashMap<EClass, Set<Integer>>();
        protected final @NonNull Connection[] classIndex2connection;
        private int isContainedCount = 0;
        private int isNotContainedCount = 0;
        private @Nullable Boolean trackAdditions = null;

        public Model(@NonNull AbstractTransformerInternal transformer, @NonNull String name, @NonNull PropertyId @Nullable [] propertyIndex2propertyId, @NonNull ClassId @NonNull [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes, @NonNull Interval rootInterval) {
            this.transformer = transformer;
            this.name = name;
            int classIds = classIndex2classId.length;
            this.classIndex2connection = new Connection[classIds];
            int i = 0;
            while (i < classIds) {
                ClassId classId = classIndex2classId[i];
                String connectionName = String.valueOf(name) + "!" + classId.getName();
                this.classIndex2connection[i] = rootInterval.createConnection(connectionName, (TypeId)classId, false, transformer.getModeFactory());
                ++i;
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void accumulateEObject1(@NonNull Object eObject, @NonNull EClass eClass) {
            @NonNull Set allClassIndexes = this.eClass2allClassIndexes.get(eClass);
            if (allClassIndexes == null) {
                allClassIndexes = this.transformer.getClassIndexes(eClass);
                this.eClass2allClassIndexes.put(eClass, allClassIndexes);
            }
            for (Integer classIndex : allClassIndexes) {
                this.classIndex2connection[classIndex].appendElement(eObject);
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void accumulateEObject2(@NonNull Object eObject, @NonNull EClass eClass, @NonNull Map<@NonNull EClass, @NonNull List<@NonNull Integer>> eClass2allPropertyIndexes, @Nullable Map<@NonNull EReference, @NonNull Integer> eReference2propertyIndex) {
            Map<@NonNull EReference, @NonNull Integer> eReference2propertyIndex2 = eReference2propertyIndex;
            assert (eReference2propertyIndex2 != null);
            @NonNull List allPropertyIndexes = eClass2allPropertyIndexes.get(eClass);
            if (allPropertyIndexes == null) {
                allPropertyIndexes = this.transformer.getOppositePropertyIndexes(eReference2propertyIndex2, eClass);
                eClass2allPropertyIndexes.put(eClass, allPropertyIndexes);
            }
            @NonNull @NonNull Map[] object2oppositeObject2 = this.transformer.object2oppositeObject;
            assert (object2oppositeObject2 != null);
            for (Integer propertyIndex : allPropertyIndexes) {
                EReference @Nullable [] propertyIndex2eReference2 = this.transformer.propertyIndex2eReference;
                assert (propertyIndex2eReference2 != null);
                EReference eReference = propertyIndex2eReference2[propertyIndex];
                if (eReference == null) {
                    PropertyId @Nullable [] propertyIndex2propertyId2 = this.transformer.propertyIndex2propertyId;
                    assert (propertyIndex2propertyId2 != null);
                    PropertyId propertyId = propertyIndex2propertyId2[propertyIndex];
                    assert (propertyId != null);
                    eReference = (EReference)NameUtil.getENamedElement((Iterable)eClass.getEAllStructuralFeatures(), (String)propertyId.getName());
                    assert (eReference != null);
                }
                Object object = this.transformer.eGet(eObject, (EStructuralFeature)eReference);
                assert (object != null);
                object2oppositeObject2[propertyIndex].put(object, eObject);
            }
        }

        @Deprecated
        public void add(@NonNull EObject eObject) {
            this.add(eObject, false);
        }

        public void add(@NonNull EObject eObject, boolean isContained) {
            if (this.trackAdditions == Boolean.FALSE || isContained && this.trackAdditions == null) {
                ++this.isContainedCount;
            } else {
                ++this.isNotContainedCount;
                assert (!this.potentialOrphanObjects.contains(eObject));
                this.potentialOrphanObjects.add(eObject);
            }
            EClass eClass = this.transformer.eClass(eObject);
            this.accumulateEObject1(eObject, eClass);
        }

        public void addRootObjects(@NonNull Iterable<@NonNull ? extends Object> eRootObjects) {
            HashMap<@NonNull EClass, @NonNull List<@NonNull Integer>> eClass2allPropertyIndexes = null;
            HashMap<@NonNull EReference, @NonNull Integer> eReference2propertyIndex = null;
            if (this.transformer.propertyIndex2propertyId != null) {
                eClass2allPropertyIndexes = new HashMap<EClass, List<Integer>>();
                eReference2propertyIndex = new HashMap<EReference, Integer>();
            }
            for (Object object : eRootObjects) {
                this.rootObjects.add(object);
                EClass eRootClass = this.transformer.eClass(object);
                this.accumulateEObject1(object, eRootClass);
                if (eClass2allPropertyIndexes != null) {
                    this.accumulateEObject2(object, eRootClass, eClass2allPropertyIndexes, eReference2propertyIndex);
                }
                TreeIterator<? extends Object> tit = this.transformer.eAllContents(object);
                while (tit.hasNext()) {
                    Object eObject = tit.next();
                    if (eObject == null) continue;
                    EClass eClass = this.transformer.eClass(eObject);
                    this.accumulateEObject1(eObject, eClass);
                    if (eClass2allPropertyIndexes == null) continue;
                    this.accumulateEObject2(eObject, eClass, eClass2allPropertyIndexes, eReference2propertyIndex);
                }
            }
        }

        @Deprecated
        public @NonNull Collection<@NonNull Object> getAllObjects() {
            return this.potentialOrphanObjects;
        }

        public @NonNull Connection getConnection(int classIndex) {
            return this.classIndex2connection[classIndex];
        }

        public @NonNull Iterable<@NonNull Object> getObjectsOfKind(@NonNull Class type) {
            TypeId classId = type.getTypeId();
            Integer classIndex = (Integer)this.transformer.classId2classIndex.get(classId);
            if (classIndex != null) {
                Iterable<@NonNull Object> typedIterable = this.classIndex2connection[classIndex].typedIterable(Object.class);
                return typedIterable;
            }
            return EMPTY_EOBJECT_LIST;
        }

        @Deprecated
        public @NonNull Collection<@NonNull Object> getObjectsOfType(@NonNull Class type) {
            throw new UnsupportedOperationException();
        }

        public @NonNull Collection<@NonNull Object> getRootObjects() {
            if (this.rootObjects.size() > 0) {
                return this.rootObjects;
            }
            ArrayList<@NonNull Object> rootObjects2 = new ArrayList<Object>();
            for (Object eObject : this.potentialOrphanObjects) {
                if (this.transformer.eContainer(eObject) != null) continue;
                rootObjects2.add(eObject);
            }
            if (AbstractTransformer.CONTAINMENTS.isActive()) {
                AbstractTransformer.CONTAINMENTS.println(String.valueOf(this.name) + " " + this.isContainedCount + "/" + (this.isContainedCount + this.isNotContainedCount));
            }
            return rootObjects2;
        }

        public String toString() {
            return String.valueOf(this.name) + " " + this.rootObjects.size();
        }

        @Override
        public @NonNull String getName() {
            return this.name;
        }

        public void setTrackAdditions(@Nullable Boolean trackAdditions) {
            this.trackAdditions = trackAdditions;
        }

        public <T> Iterable<T> typedIterable(java.lang.Class<T> javaClass, @NonNull Class pivotType) {
            TypeId typeId = pivotType.getTypeId();
            Integer classIndex = (Integer)this.transformer.classId2classIndex.get(typeId);
            if (classIndex != null) {
                Connection connection = this.classIndex2connection[classIndex];
                return connection.typedIterable(javaClass);
            }
            return null;
        }

        public static class Incremental
        extends Model {
            public Incremental(@NonNull AbstractTransformerInternal transformer, @NonNull String name, @NonNull PropertyId @Nullable [] propertyIndex2propertyId, @NonNull ClassId @NonNull [] classIndex2classId, int @Nullable [] @NonNull [] classIndex2allClassIndexes, @NonNull Interval rootInterval) {
                super(transformer, name, propertyIndex2propertyId, classIndex2classId, classIndex2allClassIndexes, rootInterval);
            }

            public void remove(@NonNull EObject eObject) {
                this.rootObjects.remove(eObject);
                this.potentialOrphanObjects.remove(eObject);
                this.unaccumulateEObject(this.eClass2allClassIndexes, null, null, eObject);
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            private void unaccumulateEObject(@Nullable Map<@NonNull EClass, @NonNull Set<@NonNull Integer>> eClass2allClassIndexes, @Nullable Map<@NonNull EClass, @NonNull List<@NonNull Integer>> eClass2allPropertyIndexes, @Nullable Map<@NonNull EReference, @NonNull Integer> eReference2propertyIndex, @NonNull Object eObject) {
                Set<Integer> allClassIndexes;
                EClass eClass = this.transformer.eClass(eObject);
                if (eClass2allClassIndexes != null && (allClassIndexes = eClass2allClassIndexes.get(eClass)) != null) {
                    for (Integer classIndex : allClassIndexes) {
                        Connection.Incremental connection = (Connection.Incremental)this.classIndex2connection[classIndex];
                        connection.removeElement(eObject);
                    }
                }
                if (eClass2allPropertyIndexes != null) {
                    Map<EReference, Integer> eReference2propertyIndex2 = eReference2propertyIndex;
                    assert (eReference2propertyIndex2 != null);
                    List<@NonNull Integer> allPropertyIndexes = eClass2allPropertyIndexes.get(eClass);
                    if (allPropertyIndexes != null) {
                        @NonNull @NonNull Map[] object2oppositeObject2 = this.transformer.object2oppositeObject;
                        assert (object2oppositeObject2 != null);
                        for (Integer propertyIndex : allPropertyIndexes) {
                            EReference @Nullable [] propertyIndex2eReference2 = this.transformer.propertyIndex2eReference;
                            assert (propertyIndex2eReference2 != null);
                            EReference eReference = propertyIndex2eReference2[propertyIndex];
                            if (eReference == null) continue;
                            Object object = this.transformer.eGet(eObject, (EStructuralFeature)eReference);
                            assert (object != null);
                            object2oppositeObject2[propertyIndex].remove(object);
                        }
                    }
                }
            }
        }
    }

    @Deprecated
    private static class UnenforcedSetAccumulator
    extends SetValueImpl
    implements SetValue.Accumulator {
        public UnenforcedSetAccumulator(@NonNull CollectionTypeId typeId) {
            super(typeId, new ArrayList());
        }

        public boolean add(@Nullable Object value) {
            assert (!this.elements.contains(value));
            return this.elements.add(value);
        }
    }
}

