/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtbase.tests;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.library.StandardLibraryContribution;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbase;
import org.eclipse.qvtd.xtext.qvtbase.tests.XtextTestCase;

public class LoadTestCase
extends XtextTestCase {
    public static final @NonNull String @NonNull [] NO_MESSAGES = new String[0];

    public void doLoad_Concrete(@NonNull URI inputURI, @NonNull String @Nullable [] messages) throws Exception {
        OCLInternal ocl = QVTbase.newInstance((ProjectManager)this.getTestProjectManager(), null);
        URI pivotURI = this.getTestURIWithExtension(inputURI, "qvtias");
        this.doLoad_Concrete((OCL)ocl, inputURI, pivotURI, messages);
        ocl.dispose();
    }

    protected Resource doLoad_Concrete(@NonNull OCL ocl, @NonNull URI inputURI, @NonNull URI pivotURI, @NonNull String @Nullable [] messages) throws Exception {
        URI cstURI = this.getTestURIWithExtension(pivotURI, "xmi");
        BaseCSResource xtextResource = (BaseCSResource)ocl.getResourceSet().getResource(inputURI, true);
        assert (xtextResource != null);
        LoadTestCase.assertNoResourceErrors("Load failed", (Resource)xtextResource);
        ASResource pivotResource = xtextResource.getASResource();
        LoadTestCase.assertNoUnresolvedProxies("Unresolved proxies", (Resource)xtextResource);
        LoadTestCase.assertNoValidationErrors("Validation errors", (EObject)xtextResource.getContents().get(0));
        this.saveAsXMI((Resource)xtextResource, cstURI);
        pivotResource.setURI(pivotURI);
        LoadTestCase.assertValidationDiagnostics("Pivot validation errors", (Resource)pivotResource, messages);
        pivotResource.save(DefaultCompilerOptions.defaultSavingOptions);
        return pivotResource;
    }

    protected void saveAsXMI(@NonNull Resource resource, @NonNull URI xmiURI) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource xmiResource = resourceSet.createResource(xmiURI);
        xmiResource.getContents().addAll((Collection)resource.getContents());
        xmiResource.save(DefaultCompilerOptions.defaultSavingOptions);
        LoadTestCase.assertNoResourceErrors("Save failed", xmiResource);
        resource.getContents().addAll((Collection)xmiResource.getContents());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LoadTestCase.configurePlatformResources();
        EcorePackage.eINSTANCE.getClass();
    }

    @Override
    protected void tearDown() throws Exception {
        StandardLibraryContribution.REGISTRY.remove("http://www.eclipse.org/ocl/2015/Library");
        super.tearDown();
    }
}

