/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.utilities;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.dynamic.ExplicitClassLoader;
import org.eclipse.ocl.examples.codegen.dynamic.JavaFileUtil;
import org.eclipse.ocl.examples.codegen.dynamic.OCL2JavaFileObject;

public final class JavaSourceFileObject
extends SimpleJavaFileObject {
    public static @Nullable String compileClass(@NonNull String sourcePath, @NonNull String javaCodeSource, @NonNull String objectPath, @Nullable List<@NonNull String> classpathProjects) throws IOException {
        List<@NonNull OCL2JavaFileObject> compilationUnits = Collections.singletonList(new OCL2JavaFileObject(sourcePath, javaCodeSource));
        return JavaFileUtil.compileClasses(compilationUnits, (String)sourcePath, (String)objectPath, classpathProjects);
    }

    public static @Nullable String compileClasses(@NonNull String sourcePath, @NonNull String objectPath, @Nullable List<@NonNull String> classpathProjects) throws IOException {
        List<@NonNull JavaFileObject> compilationUnits = JavaSourceFileObject.gatherCompilationUnits(new File(sourcePath), null);
        return JavaFileUtil.compileClasses(compilationUnits, (String)sourcePath, (String)objectPath, classpathProjects);
    }

    public static @NonNull List<@NonNull String> createClasspathProjectList(String ... classpathProjects) {
        ArrayList<@NonNull String> classpathProjectList = new ArrayList<String>();
        if (classpathProjects != null) {
            String[] stringArray = classpathProjects;
            int n = classpathProjects.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull String classpathProject = stringArray[n2];
                classpathProjectList.add(classpathProject);
                ++n2;
            }
        }
        return classpathProjectList;
    }

    private static @NonNull List<@NonNull JavaFileObject> gatherCompilationUnits(@NonNull File folder, @Nullable List<@NonNull JavaFileObject> compilationUnits) throws IOException {
        File[] listFiles;
        if (compilationUnits == null) {
            compilationUnits = new ArrayList<JavaFileObject>();
        }
        if ((listFiles = folder.listFiles()) != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    JavaSourceFileObject.gatherCompilationUnits(file, compilationUnits);
                } else if (file.isFile() && file.getName().endsWith(".java")) {
                    URI uri = file.getCanonicalFile().toURI();
                    compilationUnits.add(new JavaSourceFileObject(uri));
                }
                ++n2;
            }
        }
        return compilationUnits;
    }

    public static Class<?> loadExplicitClass(@NonNull File explicitClassPath, @NonNull String qualifiedClassName) throws ClassNotFoundException, IOException {
        ClassLoader thisClassLoader = JavaSourceFileObject.class.getClassLoader();
        assert (thisClassLoader != null);
        ExplicitClassLoader classLoader = new ExplicitClassLoader(explicitClassPath, qualifiedClassName, thisClassLoader);
        return classLoader.loadClass(qualifiedClassName);
    }

    private JavaSourceFileObject(@NonNull URI uri) {
        super(uri, JavaFileObject.Kind.SOURCE);
    }

    @Override
    public @NonNull CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        char[] buf = new char[4096];
        StringBuilder s = new StringBuilder();
        try (FileReader reader = new FileReader(new File(this.uri));){
            int len;
            while ((len = reader.read(buf)) > 0) {
                s.append(buf, 0, len);
            }
        }
        return s.toString();
    }
}

