/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.am3.core.AM3CorePlugin;
import org.eclipse.am3.core.AM3CoreTools;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.m2m.atl.engine.AtlLauncher;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class AM3Handler {
    private AtlModelHandler emfamh = AtlModelHandler.getDefault((String)"EMF");
    private Resource mmExtent;
    private Resource mExtent;
    private ASMModel asmModelMegamodel = null;
    private ASMModel asmModelAM3 = null;
    private AM3Handler mgmRegistryHandler;

    public void initASMModel() {
        try {
            this.asmModelAM3 = this.emfamh.loadModel("AM3", this.emfamh.getMof(), (InputStream)new FileInputStream(String.valueOf(AM3CorePlugin.getPluginRep()) + "resources/AM3/AM3.ecore"));
            this.asmModelMegamodel = this.emfamh.loadModel("megamodel", this.asmModelAM3, (InputStream)new FileInputStream(String.valueOf(AM3CorePlugin.getPluginRep()) + "resources/AM3/megamodel-AM3.ecore"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String metaModel = String.valueOf(AM3CorePlugin.getPluginRep()) + "resources/MegamodelRegistry/MegamodelRegistry.ecore";
        String model = AM3CorePlugin.getDefault().getStateLocation().append("am3Registry-MegamodelRegistry.ecore").toString();
        this.mgmRegistryHandler = new AM3Handler(metaModel, model);
        Set megamodels = this.mgmRegistryHandler.getElementsByType("Megamodel");
        IWorkspace wks = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wksroot = wks.getRoot();
        Iterator it = megamodels.iterator();
        while (it.hasNext()) {
            EObject currentMegamodel = (EObject)it.next();
            String mgmUri = (String)this.mgmRegistryHandler.get(currentMegamodel, "uri");
            IFile file = wksroot.getFile((IPath)new Path(mgmUri));
            try {
                this.mergeMegamodel(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Megamodel '" + mgmUri + "' does not exist.");
            }
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.am3.core.megamodel");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            try {
                String idPlugin = extensions[i].getNamespaceIdentifier();
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String uri = elements[j].getAttribute("uri");
                    File mgm = new Path(String.valueOf(AM3CoreTools.getPluginPath(idPlugin)) + uri).toFile();
                    this.mergeMegamodel(mgm.getName(), new FileInputStream(mgm));
                    ++j;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InvalidRegistryObjectException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void mergeMegamodel(IFile file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        try {
            this.mergeMegamodel(file.getName(), file.getContents());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void mergeMegamodel(String name, InputStream fileContent) {
        ASMModel ret = null;
        ASMModel megamodelToMerge = this.emfamh.loadModel(name, this.asmModelAM3, fileContent);
        HashMap<String, ASMModel> models = new HashMap<String, ASMModel>();
        models.put("AM3", this.asmModelAM3);
        models.put("IN1", this.asmModelMegamodel);
        models.put("IN2", megamodelToMerge);
        ret = this.emfamh.newModel("mgm", "mgm", this.asmModelAM3);
        models.put("mgm", ret);
        Map params = Collections.EMPTY_MAP;
        Map libs = Collections.EMPTY_MAP;
        URL url = AM3CorePlugin.getDefault().getBundle().getEntry("resources/AM3/MegamodelMerging.asm");
        AtlLauncher.getDefault().launch(url, libs, models, params, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
        ret.setIsTarget(false);
        this.asmModelMegamodel = ret;
    }

    public AM3Handler(String URLmetaModel, String URLmodel) {
        EcoreResourceFactoryImpl myEcoreFactory = new EcoreResourceFactoryImpl();
        this.mmExtent = myEcoreFactory.createResource(URI.createURI((String)URLmetaModel));
        try {
            this.mmExtent.load((InputStream)new FileInputStream(URLmetaModel), Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.init();
        URI uri = URI.createFileURI((String)URLmodel);
        this.mExtent = myEcoreFactory.createResource(uri);
        try {
            this.mExtent.load((InputStream)new FileInputStream(URLmodel), Collections.EMPTY_MAP);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public AM3Handler(String URLmetaModel, Resource model) {
        EcoreResourceFactoryImpl myEcoreFactory = new EcoreResourceFactoryImpl();
        this.mmExtent = myEcoreFactory.createResource(URI.createURI((String)URLmetaModel));
        try {
            this.mmExtent.load((InputStream)new FileInputStream(URLmetaModel), Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.init();
        this.mExtent = model;
    }

    public Set getElementsByType(Resource extent, String type) {
        HashSet<EObject> ret = new HashSet<EObject>();
        TreeIterator i = extent.getAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (!eo.eClass().getName().equals(type)) continue;
            ret.add(eo);
        }
        return ret;
    }

    public Set getElementsBySupertype(String type) {
        HashSet<EObject> ret = new HashSet<EObject>();
        TreeIterator i = this.mExtent.getAllContents();
        block0: while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            EList allSuperTypes = eo.eClass().getEAllSuperTypes();
            if (eo.eClass().getName().equals(type)) {
                ret.add(eo);
                continue;
            }
            Iterator it = allSuperTypes.iterator();
            while (it.hasNext()) {
                if (!((EClass)it.next()).getName().equals(type)) continue;
                ret.add(eo);
                continue block0;
            }
        }
        return ret;
    }

    public Set getElementsByType(String type) {
        return this.getElementsByType(this.mExtent, type);
    }

    private void init() {
        Iterator it = this.getElementsByType(this.mmExtent, "EPackage").iterator();
        while (it.hasNext()) {
            EPackage p = (EPackage)it.next();
            String nsURI = p.getNsURI();
            if (nsURI == null) {
                nsURI = p.getName();
                p.setNsURI(nsURI);
            }
            EPackage.Registry.INSTANCE.put((Object)nsURI, (Object)p);
        }
        it = this.getElementsByType(this.mmExtent, "EDataType").iterator();
        while (it.hasNext()) {
            EObject eo = (EObject)it.next();
            EStructuralFeature sf = eo.eClass().getEStructuralFeature("name");
            String tname = (String)eo.eGet(sf);
            String icn = null;
            if (tname.equals("Boolean")) {
                icn = "java.lang.Boolean";
            } else if (tname.equals("Double")) {
                icn = "java.lang.Double";
            } else if (tname.equals("Float")) {
                icn = "java.lang.Float";
            } else if (tname.equals("Integer")) {
                icn = "java.lang.Integer";
            } else if (tname.equals("String")) {
                icn = "java.lang.String";
            }
            if (icn == null) continue;
            sf = eo.eClass().getEStructuralFeature("instanceClassName");
            eo.eSet(sf, (Object)icn);
        }
    }

    public EClassifier findEClassifier(String classifierName) {
        return this.findEClassifierIn(classifierName, this.mmExtent.getContents().iterator());
    }

    private EClassifier findEClassifierIn(String classifierName, Iterator it) {
        EClassifier classifier = null;
        while (it.hasNext() && classifier == null) {
            EObject eo = (EObject)it.next();
            if (!(eo instanceof EPackage) || (classifier = ((EPackage)eo).getEClassifier(classifierName)) != null) continue;
            classifier = this.findEClassifierIn(classifierName, ((EPackage)eo).getESubpackages().iterator());
        }
        return classifier;
    }

    public void set(EObject eo, String sfName, Object newValue) {
        EStructuralFeature sf = eo.eClass().getEStructuralFeature(sfName);
        if (sf == null) {
            return;
        }
        if (sf.isMany() && !(newValue instanceof List)) {
            EList list = (EList)eo.eGet(sf);
            list.add(newValue);
        } else {
            eo.eSet(sf, newValue);
        }
    }

    public Object get(EObject eo, String sfName) {
        EStructuralFeature sf = eo.eClass().getEStructuralFeature(sfName);
        Object ret = eo.eGet(sf);
        if ("String".equals(sf.eClass().getName()) && ret == null) {
            return "";
        }
        return ret;
    }

    public EObject newModelElement(String className) {
        EObject instance = null;
        EClassifier classifier = this.findEClassifier(className);
        if (classifier instanceof EClass) {
            instance = classifier.getEPackage().getEFactoryInstance().create((EClass)classifier);
            this.mExtent.getContents().add((Object)instance);
        }
        return instance;
    }

    public void reInit() {
        this.mExtent.getContents().clear();
    }

    public void removeModelElement(EObject eo) {
        this.mExtent.getContents().remove((Object)eo);
    }

    public void saveModel() {
        try {
            this.mExtent.save(Collections.EMPTY_MAP);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void saveModel(IProject dest, String fileName) {
        String uri = String.valueOf(dest.getFullPath().toString()) + "/" + fileName + ".ecore";
        this.mExtent.setURI(URI.createURI((String)uri));
        try {
            this.mExtent.save(Collections.EMPTY_MAP);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public Resource getMmExtent() {
        return this.mmExtent;
    }

    public Resource getMExtent() {
        return this.mExtent;
    }

    public ASMModel getAsmModelAM3() {
        return this.asmModelAM3;
    }

    public ASMModel getAsmModelMegamodel() {
        return this.asmModelMegamodel;
    }

    public AM3Handler getMgmRegistryHandler() {
        return this.mgmRegistryHandler;
    }
}

