/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.example.databinding.project.ui.rcp;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.examples.databinding.project.core.IModelLoadingService;
import org.eclipse.emf.examples.databinding.project.core.IModelResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractUIPlugin
implements ServiceListener {
    public static final String PLUGIN_ID = "org.eclipse.emf.examples.databinding.project.ui.rcp";
    private static Activator plugin;
    private ServiceTracker tracker;
    private IModelLoadingService loadingService;
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.context = context;
        plugin = this;
        this.tracker = new ServiceTracker(context, IModelLoadingService.class.getName(), null);
        this.tracker.open();
        this.loadingService = (IModelLoadingService)this.tracker.getService();
        context.addServiceListener((ServiceListener)this, "(objectclass=" + IModelLoadingService.class.getName() + ")");
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.tracker.close();
        this.tracker = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public IModelResource loadResource(String uri) {
        if (this.loadingService != null) {
            return this.loadingService.findAndLoadResource(uri);
        }
        Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Model loading service not available"));
        return null;
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference sr = event.getServiceReference();
        switch (event.getType()) {
            case 1: {
                this.loadingService = (IModelLoadingService)this.context.getService(sr);
                break;
            }
            case 4: {
                this.loadingService = null;
            }
        }
    }

    public void log(Throwable throwable) {
        String message = throwable.getLocalizedMessage();
        if (message == null) {
            message = "";
        }
        this.getLog().log((IStatus)new Status(2, this.getBundle().getSymbolicName(), 0, message, throwable));
    }
}

