/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.edit.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.uml2.diagram.sequence.edit.policies.TieFrameRequest;

public class ExpandFrameDragTracker
extends DragEditPartsTracker {
    private final IFigure myHandle;
    private final int myExpandDirection;

    public ExpandFrameDragTracker(GraphicalEditPart owner, int expandDirection, IFigure handle) {
        super((EditPart)owner);
        this.myHandle = handle;
        this.myExpandDirection = expandDirection;
    }

    public void activate() {
        super.activate();
        this.myHandle.setVisible(false);
    }

    public void deactivate() {
        this.myHandle.setVisible(true);
        super.deactivate();
    }

    protected Request createTargetRequest() {
        TieFrameRequest request = new TieFrameRequest(this);
        request.setResizeDirection(this.myExpandDirection);
        return request;
    }

    protected String getCommandName() {
        return "tie frame";
    }

    protected Command getCommand() {
        EditPart editPart = this.getTargetEditPart();
        if (editPart == this.getSourceEditPart()) {
            return null;
        }
        if (!(editPart instanceof GraphicalEditPart)) {
            return null;
        }
        TieFrameRequest.Completed completedRequest = new TieFrameRequest.Completed((TieFrameRequest)this.getTargetRequest(), (GraphicalEditPart)this.getSourceEditPart());
        Command command = editPart.getCommand((Request)completedRequest);
        return command;
    }

    protected void setTargetEditPart(EditPart editpart) {
        super.setTargetEditPart(editpart);
    }
}

