/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;

public final class ExpandAllAction
extends Action {
    private IViewerProvider viewerProvider;
    private long timeout;

    public ExpandAllAction() {
        this(2000L);
    }

    public ExpandAllAction(long timeout) {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_ExpandAll_menu_item"), ExtendedImageRegistry.INSTANCE.getImageDescriptor(EMFEditUIPlugin.INSTANCE.getImage("full/ctool16/ExpandAll")));
        this.timeout = timeout;
        this.setToolTipText(EMFEditUIPlugin.INSTANCE.getString("_UI_ExpandAll_tool_tip"));
    }

    public void run() {
        Viewer viewer = this.viewerProvider.getViewer();
        if (viewer instanceof TreeViewer) {
            ExpandAllAction.expandAll((TreeViewer)viewer, this.timeout);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void expandAll(TreeViewer treeViewer, final long timeout) {
        void var10_12;
        final Tree tree = treeViewer.getTree();
        final TreeItem[] selection = tree.getSelection();
        final TreeItem topItem = tree.getTopItem();
        TreeItem[] itemsOfInterest = selection.length == 0 && topItem != null ? new TreeItem[]{topItem} : selection;
        List<TreeItem> rootItems = Arrays.asList(tree.getItems());
        ArrayList<List<Object>> prioritizedItems = new ArrayList<List<Object>>();
        prioritizedItems.add(new ArrayList());
        TreeItem[] treeItemArray = itemsOfInterest;
        int n = itemsOfInterest.length;
        boolean n2 = false;
        while (var10_12 < n) {
            TreeItem treeItem = treeItemArray[var10_12];
            ((List)prioritizedItems.get(0)).add(treeItem);
            int count = 1;
            TreeItem parentItem = treeItem.getParentItem();
            TreeItem childItem = treeItem;
            while (true) {
                List<TreeItem> list;
                if (count >= prioritizedItems.size()) {
                    list = new ArrayList();
                    prioritizedItems.add(list);
                } else {
                    list = (List)prioritizedItems.get(count);
                }
                List<TreeItem> siblingItems = parentItem != null ? Arrays.asList(parentItem.getItems()) : rootItems;
                int index = siblingItems.indexOf(childItem);
                int i = index + 1;
                int size = siblingItems.size();
                while (i < size) {
                    TreeItem siblingItem = siblingItems.get(i);
                    if (siblingItem.getItemCount() > 0) {
                        list.add(siblingItem);
                    }
                    ++i;
                }
                i = index - 1;
                while (i >= 0) {
                    TreeItem siblingItem = siblingItems.get(i);
                    if (siblingItem.getItemCount() > 0) {
                        list.add(siblingItem);
                    }
                    --i;
                }
                if (parentItem == null) break;
                childItem = parentItem;
                parentItem = parentItem.getParentItem();
                ++count;
            }
            ++var10_12;
        }
        final LinkedHashSet itemsToBeExpanded = new LinkedHashSet();
        for (List list : prioritizedItems) {
            itemsToBeExpanded.addAll(list);
        }
        BusyIndicator.showWhile((Display)tree.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    tree.setRedraw(false);
                    LinkedList<TreeItem> queue = new LinkedList<TreeItem>(itemsToBeExpanded);
                    long start = System.currentTimeMillis();
                    while (!queue.isEmpty()) {
                        TreeItem treeItem = (TreeItem)queue.poll();
                        if (!treeItem.getExpanded()) {
                            Event expandEvent = new Event();
                            expandEvent.item = treeItem;
                            tree.notifyListeners(17, expandEvent);
                            treeItem.setExpanded(true);
                        }
                        TreeItem[] childItems = treeItem.getItems();
                        int i = childItems.length - 1;
                        while (i >= 0) {
                            TreeItem childItem = childItems[i];
                            if (childItem.getData() != null && itemsToBeExpanded.add(childItem)) {
                                queue.addFirst(childItem);
                            }
                            --i;
                        }
                        if (System.currentTimeMillis() - start <= timeout) continue;
                        break;
                    }
                }
                finally {
                    tree.setTopItem(topItem);
                    if (selection.length != 0) {
                        tree.setSelection(selection);
                    }
                    tree.setRedraw(true);
                }
            }
        });
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof IViewerProvider) {
            this.viewerProvider = (IViewerProvider)workbenchPart;
            this.setEnabled(this.viewerProvider.getViewer() instanceof TreeViewer);
        } else {
            this.viewerProvider = null;
            this.setEnabled(false);
        }
    }

    public void update() {
        this.setEnabled(this.viewerProvider != null && this.viewerProvider.getViewer() instanceof TreeViewer);
    }
}

