/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.groups.commands;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.groups.core.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeGraphicalParentCommand
extends AbstractTransactionalCommand {
    private EditPart child;
    private EditPart parent;
    private Request request;
    private IGraphicalEditPart host;
    private Mode mode;

    public ChangeGraphicalParentCommand(TransactionalEditingDomain domain, String label, EditPart parent, EditPart child, IGraphicalEditPart getHost) {
        super(domain, label, null);
        this.parent = parent;
        this.child = child;
        this.request = null;
        this.host = getHost;
        this.mode = Mode.NORMAL;
    }

    public ChangeGraphicalParentCommand(TransactionalEditingDomain domain, String label, EditPart parent, EditPart child, IGraphicalEditPart getHost, Request request) {
        super(domain, label, null);
        this.parent = parent;
        this.child = child;
        this.request = request;
        this.host = getHost;
        this.mode = Mode.MOVE_PARENT;
    }

    public ChangeGraphicalParentCommand(TransactionalEditingDomain domain, String label, CreateRequest request, EditPart child, IGraphicalEditPart getHost) {
        super(domain, label, null);
        this.parent = null;
        this.child = child;
        this.request = request;
        this.host = getHost;
        this.mode = Mode.CREATION_PARENT;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
        IGraphicalEditPart oldParentPart = (IGraphicalEditPart)this.child.getParent();
        Map<?, ?> editPartRegistry = this.getEditPartRegistery();
        if (editPartRegistry == null) {
            return CommandResult.newErrorCommandResult((String)"The EditPartRegistery was not found");
        }
        if (this.parent == null) {
            if (this.request instanceof CreateViewAndElementRequest) {
                this.parent = this.getEditPartFromViewDescriptor((IGraphicalEditPart)this.child, (CreateViewAndElementRequest)this.request);
            }
        } else {
            this.parent = Utils.getCompartementEditPartFromMainEditPart(editPartRegistry, this.parent);
        }
        if (this.parent == null) {
            return CommandResult.newErrorCommandResult((String)"The IGraphicalEditPart of the parent is not created yet");
        }
        View newParentView = (View)this.parent.getModel();
        View childView = (View)this.child.getModel();
        CommandResult cmdChangeCoordinate = this.changeCoordinateInNewFather(oldParentPart, childView);
        if (cmdChangeCoordinate != null) {
            return cmdChangeCoordinate;
        }
        newParentView.insertChild(childView);
        return CommandResult.newOKCommandResult();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CommandResult changeCoordinateInNewFather(IGraphicalEditPart oldParentPart, View childView) {
        if (!(childView instanceof Node)) return CommandResult.newErrorCommandResult((String)"The new containing edit part should be compartment node. The extension point org.eclipse.papyrus.uml.diagram.common.groups.groupcontainment may have been incorrectly used.");
        IFigure parentCompartmentFigure = ((AbstractGraphicalEditPart)this.parent).getFigure();
        if (Mode.MOVE_CHILD.equals((Object)this.mode) || Mode.MOVE_PARENT.equals((Object)this.mode)) {
            Rectangle newDimension = this.computeDeltaToChangeParent((IGraphicalEditPart)this.parent);
            LayoutConstraint layoutConstraint = ((Node)childView).getLayoutConstraint();
            if (!(layoutConstraint instanceof Location)) return CommandResult.newErrorCommandResult((String)"The layoutConstraint is not an instance of Location");
            Location location = (Location)layoutConstraint;
            location.setX(newDimension.x);
            location.setY(newDimension.y);
            return null;
        } else {
            Dimension newDimension;
            if (!Mode.CREATION_CHILD.equals((Object)this.mode) && !Mode.CREATION_PARENT.equals((Object)this.mode) && !Mode.NORMAL.equals((Object)this.mode)) return null;
            if (parentCompartmentFigure.getBounds().isEmpty()) {
                Rectangle oldBounds = parentCompartmentFigure.getBounds().getCopy();
                Point compLoc = this.emulateFigureCreation(parentCompartmentFigure);
                newDimension = Utils.computeDeltaToChangeParent(oldParentPart, (IGraphicalEditPart)this.parent.getParent());
                this.reajustNewDimensionIfNeeded(parentCompartmentFigure, compLoc, newDimension);
                parentCompartmentFigure.getBounds().setBounds(oldBounds);
            } else {
                newDimension = Utils.computeDeltaToChangeParent(oldParentPart, (IGraphicalEditPart)this.parent);
            }
            LayoutConstraint layoutConstraint = ((Node)childView).getLayoutConstraint();
            if (!(layoutConstraint instanceof Location)) return CommandResult.newErrorCommandResult((String)"The layoutConstraint is not an instance of Location");
            Location location = (Location)layoutConstraint;
            Point newLocation = new Point(newDimension.width + location.getX(), newDimension.height + location.getY());
            location.setX(newLocation.x);
            location.setY(newLocation.y);
        }
        return null;
    }

    private Rectangle computeDeltaToChangeParent(IGraphicalEditPart newParent) {
        Rectangle childAbsoluteRectangle = this.getChildAbsoluteBounds();
        if (childAbsoluteRectangle instanceof Rectangle) {
            IFigure newPartFigure = ((IGraphicalEditPart)this.parent).getContentPane();
            newPartFigure.translateToRelative((Translatable)childAbsoluteRectangle);
            newPartFigure.translateFromParent((Translatable)childAbsoluteRectangle);
            Point negatedLayoutOrigin = newPartFigure.getClientArea().getLocation().getNegated();
            childAbsoluteRectangle.performTranslate(negatedLayoutOrigin.x, negatedLayoutOrigin.y);
            Point negatedMoved = this.getChildCorrectionFromParent();
            childAbsoluteRectangle.performTranslate(negatedMoved.x, negatedMoved.y);
            return childAbsoluteRectangle;
        }
        return null;
    }

    private Map<?, ?> getEditPartRegistery() {
        EditPartViewer parentViewer;
        Map editPartRegistry = null;
        if (this.parent != null && (parentViewer = this.parent.getViewer()) != null) {
            editPartRegistry = parentViewer.getEditPartRegistry();
        }
        if (editPartRegistry == null && this.child != null && this.child.getViewer() != null) {
            editPartRegistry = this.child.getViewer().getEditPartRegistry();
        }
        return editPartRegistry;
    }

    private void reajustNewDimensionIfNeeded(IFigure parentCompartmentFigure, Point compLoc, Dimension correctionDimension) {
        if (compLoc != null) {
            correctionDimension.shrink(compLoc.x + parentCompartmentFigure.getInsets().left, compLoc.y + parentCompartmentFigure.getInsets().top);
        }
    }

    private Point emulateFigureCreation(IFigure parentCompartmentFigure) {
        if (parentCompartmentFigure.getBounds().isEmpty()) {
            IFigure parentNodeFigure = parentCompartmentFigure.getParent();
            if (parentNodeFigure != null) {
                IFigure grandParentFigure = parentNodeFigure.getParent();
                if (grandParentFigure != null) {
                    grandParentFigure.getLayoutManager().layout(grandParentFigure);
                }
                parentNodeFigure.getLayoutManager().layout(parentNodeFigure);
            }
            Point compLoc = parentCompartmentFigure.getBounds().getLocation();
            return compLoc;
        }
        return null;
    }

    private EditPart getEditPartFromViewDescriptor(IGraphicalEditPart anyPart, CreateViewAndElementRequest _request) {
        EditPart result = null;
        Iterator descriptors = _request.getViewDescriptors().iterator();
        Map editPartRegistry = anyPart.getViewer().getEditPartRegistry();
        while (descriptors.hasNext()) {
            CreateViewRequest.ViewDescriptor descriptor = (CreateViewRequest.ViewDescriptor)descriptors.next();
            Object view = descriptor.getAdapter(View.class);
            if (!(view instanceof View)) continue;
            View childView = (View)view;
            result = this.getCompartmentEditPartFromView(editPartRegistry, childView);
        }
        return result;
    }

    public EditPart getCompartmentEditPartFromView(Map<?, ?> editPartRegistry, View view) {
        EditPart resultCompartmentEditPart = null;
        Object editPartAux = editPartRegistry.get(view);
        if (editPartAux instanceof EditPart) {
            EditPart _editPart = (EditPart)editPartAux;
            resultCompartmentEditPart = Utils.getCompartementEditPartFromMainEditPart(editPartRegistry, _editPart);
        }
        return resultCompartmentEditPart;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    private Rectangle getChildAbsoluteBounds() {
        Rectangle result = null;
        if (this.child instanceof IGraphicalEditPart) {
            switch (this.mode) {
                case MOVE_CHILD: {
                    Object _origineConstraint;
                    if (!(this.request instanceof ChangeBoundsRequest) || !((_origineConstraint = this.request.getExtendedData().get("CONSTRAINT_AFTER_MOVING")) instanceof Rectangle)) break;
                    result = (Rectangle)_origineConstraint;
                    break;
                }
                case MOVE_PARENT: {
                    result = Utils.getAbsoluteBounds((IGraphicalEditPart)this.child).getCopy();
                    break;
                }
                default: {
                    result = Utils.getAbsoluteBounds((IGraphicalEditPart)this.child).getCopy();
                }
            }
        }
        return result;
    }

    private Point getChildCorrectionFromParent() {
        Point result = null;
        if (this.child instanceof IGraphicalEditPart) {
            switch (this.mode) {
                case MOVE_PARENT: {
                    result = ((ChangeBoundsRequest)this.request).getMoveDelta().getNegated();
                    break;
                }
                default: {
                    result = new Point(0, 0);
                }
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        CREATION_PARENT,
        CREATION_CHILD,
        MOVE_CHILD,
        MOVE_PARENT,
        NORMAL;

    }
}

