/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lob.CDOBlob;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.common.lob.CDOLobUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;

public abstract class CDOTypeImpl
implements CDOType {
    private static CDOTypeImpl[] ids = new CDOTypeImpl[256];
    private static final byte OPCODE_NORMAL = 0;
    private static final byte OPCODE_NULL = 1;
    private static final byte OPCODE_NIL = 2;
    private static final byte BOOLEAN_DEFAULT_PRIMITIVE = 0;
    private static final char CHARACTER_DEFAULT_PRIMITIVE = '\u0000';
    private static final short SHORT_DEFAULT_PRIMITIVE = 0;
    public static final Boolean BOOLEAN_DEFAULT = new Boolean(false);
    public static final Byte BYTE_DEFAULT = new Byte(0);
    public static final Character CHARACTER_DEFAULT = new Character('\u0000');
    public static final Double DOUBLE_DEFAULT = new Double(0.0);
    public static final Float FLOAT_DEFAULT = new Float(0.0);
    public static final Integer INTEGER_DEFAULT = new Integer(0);
    public static final Long LONG_DEFAULT = new Long(0L);
    public static final Short SHORT_DEFAULT = new Short(0);
    public static final CDOType BOOLEAN = new CDOTypeImpl("BOOLEAN", 22, false, BOOLEAN_DEFAULT){

        @Override
        public void writeValue(CDODataOutput out, Object value) throws IOException {
            boolean v = (Boolean)(value == null ? this.getDefaultValue() : value);
            out.writeBoolean(v);
        }

        @Override
        public Boolean readValue(CDODataInput in) throws IOException {
            return in.readBoolean();
        }
    };
    public static final CDOType BYTE = new CDOTypeImpl("BYTE", 24, false, BYTE_DEFAULT){

        @Override
        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeByte(((Byte)(value == null ? this.getDefaultValue() : value)).byteValue());
        }

        @Override
        public Byte readValue(CDODataInput in) throws IOException {
            return in.readByte();
        }
    };
    public static final CDOType CHAR = new CDOTypeImpl("CHAR", 27, false, CHARACTER_DEFAULT){

        @Override
        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeChar(((Character)(value == null ? this.getDefaultValue() : value)).charValue());
        }

        @Override
        public Character readValue(CDODataInput in) throws IOException {
            return Character.valueOf(in.readChar());
        }
    };
    public static final CDOType DOUBLE = new CDOTypeImpl("DOUBLE", 31, false, DOUBLE_DEFAULT){

        @Override
        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeDouble((Double)(value == null ? this.getDefaultValue() : value));
        }

        @Override
        public Double readValue(CDODataInput in) throws IOException {
            return in.readDouble();
        }
    };
    public static final CDOType FLOAT = new CDOTypeImpl("FLOAT", 37, false, FLOAT_DEFAULT){

        @Override
        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeFloat(((Float)(value == null ? this.getDefaultValue() : value)).floatValue());
        }

        @Override
        public Float readValue(CDODataInput in) throws IOException {
            return Float.valueOf(in.readFloat());
        }
    };
    public static final CDOType INT = new CDOTypeImpl("INT", 39, false, INTEGER_DEFAULT){

        @Override
        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeXInt((Integer)(value == null ? this.getDefaultValue() : value));
        }

        @Override
        public Integer readValue(CDODataInput in) throws IOException {
            return in.readXInt();
        }
    };
    public static final CDOType LONG = new CDOTypeImpl("LONG", 43, false, LONG_DEFAULT){

        @Override
        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeXLong((Long)(value == null ? this.getDefaultValue() : value));
        }

        @Override
        public Long readValue(CDODataInput in) throws IOException {
            return in.readXLong();
        }
    };
    public static final CDOType SHORT = new CDOTypeImpl("SHORT", 48, false, SHORT_DEFAULT){

        @Override
        public void writeValue(CDODataOutput out, Object value) throws IOException {
            out.writeShort(((Short)(value == null ? this.getDefaultValue() : value)).shortValue());
        }

        @Override
        public Short readValue(CDODataInput in) throws IOException {
            return in.readShort();
        }
    };
    public static final CDOType BIG_DECIMAL = new ObjectType("BIG_DECIMAL", 20){

        @Override
        public void doWriteValue(CDODataOutput out, Object value) throws IOException {
            BigDecimal bigDecimal = (BigDecimal)value;
            out.writeByteArray(bigDecimal.unscaledValue().toByteArray());
            out.writeXInt(bigDecimal.scale());
        }

        @Override
        public BigDecimal doReadValue(CDODataInput in) throws IOException {
            byte[] array = in.readByteArray();
            BigInteger unscaled = new BigInteger(array);
            int scale = in.readXInt();
            return new BigDecimal(unscaled, scale);
        }
    };
    public static final CDOType BIG_INTEGER = new ObjectType("BIG_INTEGER", 21){

        @Override
        public void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeByteArray(((BigInteger)value).toByteArray());
        }

        @Override
        public BigInteger doReadValue(CDODataInput in) throws IOException {
            byte[] array = in.readByteArray();
            return new BigInteger(array);
        }
    };
    public static final CDOType OBJECT = new CDOTypeImpl("OBJECT", 10, true, CDOID.NULL){

        @Override
        public void writeValue(CDODataOutput out, Object value) throws IOException {
            if (value instanceof CDORevision) {
                out.writeCDOID(((CDORevision)value).getID());
            } else if (value == CDORevisionData.NIL) {
                out.writeCDOID(CDOID.NIL);
            } else {
                out.writeCDOID((CDOID)value);
            }
        }

        @Override
        public Object readValue(CDODataInput in) throws IOException {
            CDOID id = in.readCDOID();
            if (id == CDOID.NIL) {
                return CDORevisionData.NIL;
            }
            return id;
        }

        @Override
        public Object doAdjustReferences(CDOReferenceAdjuster adjuster, Object value, EStructuralFeature feature, int index) {
            return adjuster.adjustReference(value, feature, index);
        }
    };
    public static final CDOType BOOLEAN_OBJECT = new ObjectType("BOOLEAN_OBJECT", 23){

        @Override
        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeBoolean((Boolean)value);
        }

        @Override
        protected Boolean doReadValue(CDODataInput in) throws IOException {
            return in.readBoolean();
        }
    };
    public static final CDOType BYTE_OBJECT = new ObjectType("BYTE_OBJECT", 26){

        @Override
        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeByte(((Byte)value).byteValue());
        }

        @Override
        protected Byte doReadValue(CDODataInput in) throws IOException {
            return in.readByte();
        }
    };
    public static final CDOType CHARACTER_OBJECT = new ObjectType("CHARACTER_OBJECT", 28){

        @Override
        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeChar(((Character)value).charValue());
        }

        @Override
        protected Character doReadValue(CDODataInput in) throws IOException {
            return Character.valueOf(in.readChar());
        }
    };
    public static final CDOType DATE = new ObjectType("DATE", 29){

        @Override
        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeXLong(((Date)value).getTime());
        }

        @Override
        protected Date doReadValue(CDODataInput in) throws IOException {
            return new Date(in.readXLong());
        }
    };
    public static final CDOType DOUBLE_OBJECT = new ObjectType("DOUBLE_OBJECT", 32){

        @Override
        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeDouble((Double)value);
        }

        @Override
        protected Double doReadValue(CDODataInput in) throws IOException {
            return in.readDouble();
        }
    };
    public static final CDOType FLOAT_OBJECT = new ObjectType("FLOAT_OBJECT", 38){

        @Override
        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeFloat(((Float)value).floatValue());
        }

        @Override
        protected Float doReadValue(CDODataInput in) throws IOException {
            return Float.valueOf(in.readFloat());
        }
    };
    public static final CDOType INTEGER_OBJECT = new ObjectType("INTEGER_OBJECT", 40){

        @Override
        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeXInt((Integer)value);
        }

        @Override
        protected Integer doReadValue(CDODataInput in) throws IOException {
            return in.readXInt();
        }
    };
    public static final CDOType LONG_OBJECT = new ObjectType("LONG_OBJECT", 44){

        @Override
        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeXLong((Long)value);
        }

        @Override
        protected Long doReadValue(CDODataInput in) throws IOException {
            return in.readXLong();
        }
    };
    public static final CDOType SHORT_OBJECT = new ObjectType("SHORT_OBJECT", 49){

        @Override
        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeShort(((Short)value).shortValue());
        }

        @Override
        protected Short doReadValue(CDODataInput in) throws IOException {
            return in.readShort();
        }
    };
    public static final CDOType STRING = new ObjectType("STRING", 50){

        @Override
        protected String doCopyValue(Object value) {
            return (String)value;
        }

        @Override
        public void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeString((String)value);
        }

        @Override
        public String doReadValue(CDODataInput in) throws IOException {
            return in.readString();
        }
    };
    public static final CDOType BYTE_ARRAY = new ObjectType("BYTE_ARRAY", 25){

        protected byte[] doCopyValue(Object value) {
            byte[] array = (byte[])value;
            byte[] result = new byte[array.length];
            System.arraycopy(value, 0, result, 0, array.length);
            return result;
        }

        @Override
        public void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeByteArray((byte[])value);
        }

        public byte[] doReadValue(CDODataInput in) throws IOException {
            return in.readByteArray();
        }
    };
    public static final CDOType FEATURE_MAP_ENTRY = new CDOTypeImpl("FEATURE_MAP_ENTRY", 36, false){

        protected FeatureMap.Entry doCopyValue(Object value) {
            FeatureMap.Entry entry = (FeatureMap.Entry)value;
            EStructuralFeature innerFeature = entry.getEStructuralFeature();
            Object innerValue = entry.getValue();
            CDOType innerType = CDOModelUtil.getType(innerFeature.getEType());
            Object innerCopy = innerType.copyValue(innerValue);
            return CDORevisionUtil.createFeatureMapEntry(innerFeature, innerCopy);
        }

        @Override
        public void writeValue(CDODataOutput out, Object value) throws IOException {
            throw new UnsupportedOperationException();
        }

        public FeatureMap.Entry readValue(CDODataInput in) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object doAdjustReferences(CDOReferenceAdjuster adjuster, Object value, EStructuralFeature feature, int index) {
            FeatureMap.Entry entry = (FeatureMap.Entry)value;
            EStructuralFeature innerFeature = entry.getEStructuralFeature();
            Object innerValue = entry.getValue();
            CDOType innerType = CDOModelUtil.getType(innerFeature.getEType());
            Object innerCopy = innerType.adjustReferences(adjuster, innerValue, feature, index);
            if (innerCopy != innerValue) {
                value = CDORevisionUtil.createFeatureMapEntry(innerFeature, innerCopy);
            }
            return value;
        }
    };
    public static final CDOType JAVA_CLASS = new ObjectType("JAVA_CLASS", 41){

        @Override
        protected String doCopyValue(Object value) {
            return (String)value;
        }

        @Override
        public void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeString((String)value);
        }

        @Override
        public String doReadValue(CDODataInput in) throws IOException {
            return in.readString();
        }

        @Override
        public Object convertToEMF(EClassifier eType, Object value) {
            if (value == CDORevisionData.NIL) {
                return EStructuralFeature.Internal.DynamicValueHolder.NIL;
            }
            return EcoreUtil.createFromString((EDataType)((EDataType)eType), (String)((String)value));
        }

        @Override
        public Object convertToCDO(EClassifier eType, Object value) {
            if (value == EStructuralFeature.Internal.DynamicValueHolder.NIL) {
                return CDORevisionData.NIL;
            }
            return EcoreUtil.convertToString((EDataType)((EDataType)eType), (Object)value);
        }
    };
    public static final CDOType JAVA_OBJECT = new ObjectType("JAVA_OBJECT", 41){

        @Override
        protected Object doCopyValue(Object value) {
            if (value instanceof byte[]) {
                byte[] array = (byte[])value;
                int length = array.length;
                value = new byte[length];
                System.arraycopy(array, 0, value, 0, length);
            }
            return value;
        }

        @Override
        public void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeByteArray((byte[])value);
        }

        public byte[] doReadValue(CDODataInput in) throws IOException {
            return in.readByteArray();
        }

        @Override
        public Object convertToEMF(EClassifier eType, Object value) {
            if (value == CDORevisionData.NIL) {
                return EStructuralFeature.Internal.DynamicValueHolder.NIL;
            }
            try {
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream((byte[])value));
                return in.readObject();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public Object convertToCDO(EClassifier eType, Object value) {
            if (value == EStructuralFeature.Internal.DynamicValueHolder.NIL) {
                return CDORevisionData.NIL;
            }
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bytes);
                out.writeObject(value);
                out.close();
                return bytes.toByteArray();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    };
    public static final CDOType CUSTOM = new ObjectType("CUSTOM", 0){

        @Override
        protected String doCopyValue(Object value) {
            return (String)value;
        }

        @Override
        public void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeString((String)value);
        }

        @Override
        public String doReadValue(CDODataInput in) throws IOException {
            return in.readString();
        }

        @Override
        public Object convertToEMF(EClassifier eType, Object value) {
            if (value == CDORevisionData.NIL) {
                return EStructuralFeature.Internal.DynamicValueHolder.NIL;
            }
            return EcoreUtil.createFromString((EDataType)((EDataType)eType), (String)((String)value));
        }

        @Override
        public Object convertToCDO(EClassifier eType, Object value) {
            if (value == EStructuralFeature.Internal.DynamicValueHolder.NIL) {
                return CDORevisionData.NIL;
            }
            return EcoreUtil.convertToString((EDataType)((EDataType)eType), (Object)value);
        }
    };
    public static final CDOType ENUM_ORDINAL = new ObjectType("ENUM_ORDINAL", -1){

        @Override
        protected Integer doCopyValue(Object value) {
            return (Integer)value;
        }

        @Override
        public void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeXInt((Integer)value);
        }

        @Override
        public Integer doReadValue(CDODataInput in) throws IOException {
            return in.readXInt();
        }

        @Override
        public Object convertToCDO(EClassifier type, Object value) {
            for (EEnumLiteral literal : ((EEnum)type).getELiterals()) {
                if (literal != value && literal.getInstance() != value) continue;
                return literal.getValue();
            }
            throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOTypeImpl.23"), value));
        }

        @Override
        public Object convertToEMF(EClassifier type, Object value) {
            return ((EEnum)type).getEEnumLiteral(((Integer)value).intValue()).getInstance();
        }
    };
    public static final CDOType ENUM_LITERAL = new ObjectType("ENUM_LITERAL", -2){

        @Override
        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            EEnum eEnum = value instanceof EEnumLiteral ? ((EEnumLiteral)value).getEEnum() : this.findEnum((InternalCDOPackageRegistry)out.getPackageRegistry(), value);
            out.writeCDOClassifierRef((EClassifier)eEnum);
            out.writeXInt(((Enumerator)value).getValue());
        }

        @Override
        protected Object doReadValue(CDODataInput in) throws IOException {
            int ordinal;
            EEnum eEnum = (EEnum)in.readCDOClassifierRefAndResolve();
            EEnumLiteral literal = eEnum.getEEnumLiteral(ordinal = in.readXInt());
            if (literal == null) {
                throw new IllegalArgumentException("Enum literal " + ordinal + " not found in " + eEnum);
            }
            return literal.getInstance();
        }

        private EEnum findEnum(InternalCDOPackageRegistry registry, Object value) {
            EPackage ePackage;
            EEnum eEnum;
            Object possiblePackage;
            Set<String> keys = registry.getAllKeys();
            for (String nsURI : keys) {
                possiblePackage = registry.getWithDelegation(nsURI, false);
                if (!(possiblePackage instanceof EPackage) || (eEnum = this.findEnum(ePackage = (EPackage)possiblePackage, value)) == null) continue;
                return eEnum;
            }
            for (String nsURI : keys) {
                possiblePackage = registry.getWithDelegation(nsURI, false);
                if (!(possiblePackage instanceof EPackage.Descriptor) || (eEnum = this.findEnum(ePackage = registry.getEPackage(nsURI), value)) == null) continue;
                return eEnum;
            }
            throw new IllegalArgumentException("EENum instance " + value.getClass().getName() + " not supported");
        }

        private EEnum findEnum(EPackage ePackage, Object value) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EEnum eEnum;
                if (!(eClassifier instanceof EEnum) || (eEnum = (EEnum)eClassifier).getInstanceClass() == null || eEnum.getInstanceClass() != value.getClass()) continue;
                return eEnum;
            }
            return null;
        }
    };
    public static final CDOType BLOB = new ObjectType("BLOB", -3){

        @Override
        public void doWriteValue(CDODataOutput out, Object value) throws IOException {
            CDOLobUtil.write(out, (CDOBlob)value);
        }

        @Override
        public CDOBlob doReadValue(CDODataInput in) throws IOException {
            return CDOLobUtil.readBlob(in);
        }
    };
    public static final CDOType CLOB = new ObjectType("CLOB", -4){

        @Override
        public void doWriteValue(CDODataOutput out, Object value) throws IOException {
            CDOLobUtil.write(out, (CDOClob)value);
        }

        @Override
        public CDOClob doReadValue(CDODataInput in) throws IOException {
            return CDOLobUtil.readClob(in);
        }
    };
    public static final CDOType OBJECT_ARRAY = new ObjectType("OBJECT_ARRAY", -5){

        @Override
        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            Object[] objects = (Object[])value;
            out.writeXInt(objects.length);
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.writeTypeAndValue(out, object);
                ++n2;
            }
        }

        protected Object[] doReadValue(CDODataInput in) throws IOException {
            int size = in.readXInt();
            Object[] objects = new Object[size];
            int i = 0;
            while (i < size) {
                objects[i] = this.readTypeAndValue(in);
                ++i;
            }
            return objects;
        }

        @Override
        public Object doAdjustReferences(CDOReferenceAdjuster adjuster, Object value, EStructuralFeature feature, int index) {
            Object[] objects = (Object[])value;
            int i = 0;
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                objects[i] = object instanceof CDOID ? adjuster.adjustReference(object, feature, i) : object;
                ++i;
                ++n2;
            }
            return objects;
        }
    };
    public static final CDOType MAP = new ObjectType("MAP", -6){

        @Override
        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            Map map = (Map)value;
            out.writeXInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                this.writeTypeAndValue(out, entry.getKey());
                this.writeTypeAndValue(out, entry.getValue());
            }
        }

        @Override
        protected Map<Object, Object> doReadValue(CDODataInput in) throws IOException {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            int size = in.readXInt();
            int i = 0;
            while (i < size) {
                Object key = this.readTypeAndValue(in);
                Object value = this.readTypeAndValue(in);
                result.put(key, value == CDOID.NULL ? null : value);
                ++i;
            }
            return result;
        }
    };
    public static final CDOType SET = new ObjectType("SET", -7){

        @Override
        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            Set set = (Set)value;
            out.writeXInt(set.size());
            for (Object element : set) {
                this.writeTypeAndValue(out, element);
            }
        }

        @Override
        protected Set<Object> doReadValue(CDODataInput in) throws IOException {
            HashSet<Object> result = new HashSet<Object>();
            int size = in.readXInt();
            int i = 0;
            while (i < size) {
                Object element = this.readTypeAndValue(in);
                result.add(element == CDOID.NULL ? null : element);
                ++i;
            }
            return result;
        }
    };
    public static final CDOType LIST = new ObjectType("LIST", -8){

        @Override
        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            List list = (List)value;
            out.writeXInt(list.size());
            for (Object element : list) {
                this.writeTypeAndValue(out, element);
            }
        }

        @Override
        protected List<Object> doReadValue(CDODataInput in) throws IOException {
            ArrayList<Object> result = new ArrayList<Object>();
            int size = in.readXInt();
            int i = 0;
            while (i < size) {
                Object element = this.readTypeAndValue(in);
                result.add(element == CDOID.NULL ? null : element);
                ++i;
            }
            return result;
        }
    };
    public static final CDOType EXCEPTION = new ObjectType("EXCEPTION", -9){

        @Override
        protected void doWriteValue(CDODataOutput out, Object value) throws IOException {
            out.writeException((Throwable)value);
        }

        @Override
        protected Throwable doReadValue(CDODataInput in) throws IOException {
            return in.readException();
        }
    };
    private String name;
    private byte typeID;
    private boolean canBeNull;
    private Object defaultValue;

    private CDOTypeImpl(String name, int typeID, boolean canBeNull, Object defaultValue) {
        CDOTypeImpl.ids[typeID - -128] = this;
        this.name = name;
        this.typeID = (byte)typeID;
        this.canBeNull = canBeNull;
        this.defaultValue = defaultValue;
    }

    private CDOTypeImpl(String name, int typeID, boolean canBeNull) {
        this(name, typeID, canBeNull, (Object)null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public byte getTypeID() {
        return this.typeID;
    }

    @Override
    public boolean canBeNull() {
        return this.canBeNull;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public final Object copyValue(Object value) {
        if (value == null || value == CDORevisionData.NIL) {
            return value;
        }
        return this.doCopyValue(value);
    }

    protected Object doCopyValue(Object value) {
        return value;
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeByte(this.typeID);
    }

    @Override
    public final Object adjustReferences(CDOReferenceAdjuster adjuster, Object value, EStructuralFeature feature, int index) {
        return value == null ? null : this.doAdjustReferences(adjuster, value, feature, index);
    }

    protected Object doAdjustReferences(CDOReferenceAdjuster adjuster, Object value, EStructuralFeature feature, int indexs) {
        return value;
    }

    @Override
    public Object convertToEMF(EClassifier feature, Object value) {
        return value;
    }

    @Override
    public Object convertToCDO(EClassifier feature, Object value) {
        return value;
    }

    protected void writeTypeAndValue(CDODataOutput out, Object object) throws IOException {
        CDOType cdoType = CDOModelUtil.getTypeOfObject(object);
        out.writeByte(cdoType.getTypeID());
        cdoType.writeValue(out, object);
    }

    protected Object readTypeAndValue(CDODataInput in) throws IOException {
        byte typeID = in.readByte();
        CDOType cdoType = CDOModelUtil.getType(typeID);
        return cdoType.readValue(in);
    }

    public static CDOType getType(byte typeID) {
        CDOTypeImpl type = ids[typeID - -128];
        if (type == null) {
            throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOModelUtil.6"), typeID));
        }
        return type;
    }

    /* synthetic */ CDOTypeImpl(String string, int n, boolean bl, Object object, CDOTypeImpl cDOTypeImpl) {
        this(string, n, bl, object);
    }

    /* synthetic */ CDOTypeImpl(String string, int n, boolean bl, CDOTypeImpl cDOTypeImpl) {
        this(string, n, bl);
    }

    private static abstract class ObjectType
    extends CDOTypeImpl {
        public ObjectType(String name, int typeID) {
            super(name, typeID, true, null);
        }

        @Override
        public final void writeValue(CDODataOutput out, Object value) throws IOException {
            if (value == null) {
                out.writeByte(1);
            } else if (value == CDORevisionData.NIL) {
                out.writeByte(2);
            } else {
                out.writeByte(0);
                this.doWriteValue(out, value);
            }
        }

        protected abstract void doWriteValue(CDODataOutput var1, Object var2) throws IOException;

        @Override
        public final Object readValue(CDODataInput in) throws IOException {
            byte opcode = in.readByte();
            switch (opcode) {
                case 0: {
                    return this.doReadValue(in);
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return CDORevisionData.NIL;
                }
            }
            throw new IllegalStateException("Illegal opcode: " + opcode);
        }

        protected abstract Object doReadValue(CDODataInput var1) throws IOException;
    }
}

