/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffChangedListener;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.decorators.DecoratorRepositoryStateCache;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.PlatformUI;

public abstract class GitDecorator
extends LabelProvider
implements ILightweightLabelDecorator,
IndexDiffChangedListener,
ConfigChangedListener {
    private Object lock = new Object();
    private EventJob eventJob;
    private ListenerHandle configListener;

    public GitDecorator() {
        Activator.getDefault().getIndexDiffCache().addIndexDiffChangedListener((IndexDiffChangedListener)this);
        this.configListener = Activator.getDefault().getRepositoryCache().getGlobalListenerList().addConfigChangedListener((ConfigChangedListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        EventJob job;
        Activator.getDefault().getIndexDiffCache().removeIndexDiffChangedListener((IndexDiffChangedListener)this);
        this.configListener.remove();
        this.configListener = null;
        Object object = this.lock;
        synchronized (object) {
            job = this.eventJob;
            this.eventJob = null;
        }
        if (job != null) {
            job.cancel();
        }
    }

    protected void postLabelEvent() {
        this.getEventJob().post(this);
    }

    protected void fireLabelEvent() {
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this);
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.fireLabelProviderChanged(event));
    }

    public void indexDiffChanged(Repository repository, IndexDiffData indexDiffData) {
        DecoratorRepositoryStateCache.INSTANCE.clear(repository);
        this.postLabelEvent();
    }

    public void onConfigChanged(ConfigChangedEvent event) {
        DecoratorRepositoryStateCache.INSTANCE.resetBranchState(event.getRepository());
        this.postLabelEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventJob getEventJob() {
        Object object = this.lock;
        synchronized (object) {
            if (this.eventJob == null) {
                this.eventJob = new EventJob(this.getName());
                this.eventJob.setSystem(true);
                this.eventJob.setUser(false);
            }
            return this.eventJob;
        }
    }

    protected abstract String getName();

    private static class EventJob
    extends Job {
        private static final long DELAY = 100L;
        private GitDecorator decorator;

        public EventJob(String name) {
            super(MessageFormat.format(UIText.GitDecorator_jobTitle, name));
        }

        public IStatus run(IProgressMonitor monitor) {
            if (this.decorator != null) {
                this.decorator.fireLabelEvent();
            }
            return Status.OK_STATUS;
        }

        public void post(GitDecorator source) {
            this.decorator = source;
            if (this.getState() == 1 || this.getState() == 2) {
                this.cancel();
            }
            this.schedule(100L);
        }
    }
}

