/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapCommand
extends AbstractTransactionalCommand {
    protected List<? extends IGraphicalEditPart> editparts;

    public SnapCommand(TransactionalEditingDomain editingDomain, List<? extends IGraphicalEditPart> editparts) {
        super(editingDomain, DiagramUIMessages.SnapToGrid_textLabel, null);
        this.editparts = editparts;
    }

    public List getAffectedFiles() {
        if (this.editparts != null) {
            IGraphicalEditPart parent = this.editparts.get(0);
            View view = parent.getPrimaryView();
            return SnapCommand.getWorkspaceFiles((EObject)view);
        }
        return super.getAffectedFiles();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CompositeTransactionalCommand snapCommand = new CompositeTransactionalCommand(this.getEditingDomain(), this.getLabel());
        for (IGraphicalEditPart iGraphicalEditPart : this.editparts) {
            Command gefMove;
            LayoutConstraint constraint;
            if (!(iGraphicalEditPart.getModel() instanceof Node) || !((constraint = ((Node)iGraphicalEditPart.getModel()).getLayoutConstraint()) instanceof Bounds)) continue;
            Bounds bounds = (Bounds)constraint;
            ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
            request.setEditParts((EditPart)iGraphicalEditPart);
            PrecisionDimension moveDeltaDim = new PrecisionDimension((double)(bounds.getX() - iGraphicalEditPart.getFigure().getBounds().x), (double)(bounds.getY() - iGraphicalEditPart.getFigure().getBounds().y));
            iGraphicalEditPart.getFigure().translateToAbsolute((Translatable)moveDeltaDim);
            PrecisionPoint moveDelta = new PrecisionPoint(moveDeltaDim.preciseWidth(), moveDeltaDim.preciseHeight());
            request.getExtendedData().clear();
            request.setMoveDelta((Point)moveDelta);
            PrecisionRectangle figureBounds = null;
            IFigure figure = iGraphicalEditPart.getFigure();
            figureBounds = figure instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)figure).getHandleBounds()) : new PrecisionRectangle(figure.getBounds());
            figure.translateToAbsolute((Translatable)figureBounds);
            SnapToHelper snapToHelper = (SnapToHelper)iGraphicalEditPart.getAdapter(SnapToHelper.class);
            PrecisionRectangle baseRect = new PrecisionRectangle((Rectangle)figureBounds);
            baseRect.translate((Point)moveDelta);
            if (snapToHelper != null) {
                snapToHelper.snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRect}, moveDelta);
                request.setMoveDelta((Point)moveDelta);
            }
            if ((gefMove = iGraphicalEditPart.getCommand((Request)request)) == null) continue;
            snapCommand.add((IUndoableOperation)new CommandProxy(gefMove));
        }
        if (snapCommand != null && snapCommand.canExecute()) {
            snapCommand.execute(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }
}

