/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.animation.effects;

import org.eclipse.nebula.cwt.animation.AnimationRunner;
import org.eclipse.nebula.cwt.animation.effects.AbstractEffect;
import org.eclipse.nebula.cwt.animation.movement.IMovement;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class MoveControl
extends AbstractEffect {
    int startX;
    int endX;
    int startY;
    int endY;
    int stepX;
    int stepY;
    Control control = null;

    public static void move(AnimationRunner runner, Control w, int x, int y, int duration, IMovement movement, Runnable onStop, Runnable onCancel) {
        Point oldSize = w.getLocation();
        MoveControl effect = new MoveControl(w, oldSize.x, x, oldSize.y, y, duration, movement, onStop, onCancel);
        runner.runEffect(effect);
    }

    public MoveControl(Control control, int startX, int endX, int startY, int endY, long lengthMilli, IMovement movement, Runnable onStop, Runnable onCancel) {
        super(lengthMilli, movement, onStop, onCancel);
        this.startX = startX;
        this.endX = endX;
        this.stepX = endX - startX;
        this.startY = startY;
        this.endY = endY;
        this.stepY = endY - startY;
        this.easingFunction.init(0.0, 1.0, (int)lengthMilli);
        this.control = control;
    }

    public void applyEffect(long currentTime) {
        if (!this.control.isDisposed()) {
            this.control.setLocation((int)((double)this.startX + (double)this.stepX * this.easingFunction.getValue((int)currentTime)), (int)((double)this.startY + (double)this.stepY * this.easingFunction.getValue((int)currentTime)));
        }
    }

    public int getStartX() {
        return this.startX;
    }

    public int getEnd() {
        return this.endY;
    }
}

