/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cheatsheets.actions;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cheatsheets.CheatSheetsPlugin;
import org.eclipse.emf.cheatsheets.actions.NewProjectAction;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class NewJavaProjectAction
extends NewProjectAction {
    protected static final String SOURCE_FOLDER = "src";
    protected static final String OUTPUT_FOLDER = "bin";

    @Override
    protected IProject createProject(String projectName, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject;
        IProjectDescription description;
        monitor.beginTask(CheatSheetsPlugin.INSTANCE.getString("_UI_CreateJavaProject_message", new String[]{projectName}), 5);
        IProject project = super.createProject(projectName, (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)monitor, (int)1));
        if (project != null && !(description = project.getDescription()).hasNature("org.eclipse.jdt.core.javanature") && (javaProject = JavaCore.create((IProject)project)) != null) {
            String[] natures = description.getNatureIds();
            String[] javaNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, javaNatures, 0, natures.length);
            javaNatures[natures.length] = "org.eclipse.jdt.core.javanature";
            description.setNatureIds(javaNatures);
            project.setDescription(description, (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)monitor, (int)1));
            IFolder sourceFolder = project.getFolder(SOURCE_FOLDER);
            if (!sourceFolder.exists()) {
                sourceFolder.create(true, true, (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)monitor, (int)1));
            }
            javaProject.setOutputLocation(project.getFolder(OUTPUT_FOLDER).getFullPath(), (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)monitor, (int)1));
            IClasspathEntry[] entries = new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)sourceFolder.getFullPath()), JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"))};
            javaProject.setRawClasspath(entries, (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)monitor, (int)1));
        }
        monitor.done();
        return project;
    }
}

