/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointToggleUtils;
import org.eclipse.jdt.internal.debug.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.AbstractRulerActionDelegate;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class RulerToggleLambdaEntryBreakpointActionDelegate
extends AbstractRulerActionDelegate
implements IActionDelegate2 {
    private IEditorPart currentEditor;
    private IAction dummyAction;

    protected IAction createAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        this.dummyAction = new Action(){};
        return this.dummyAction;
    }

    public void setActiveEditor(IAction callerAction, IEditorPart targetEditor) {
        this.currentEditor = targetEditor;
    }

    public void init(IAction action) {
    }

    public void dispose() {
        this.currentEditor = null;
        this.dummyAction = null;
        super.dispose();
    }

    public void runWithEvent(IAction action, Event event) {
        if (!(this.currentEditor instanceof ITextEditor)) {
            return;
        }
        IVerticalRulerInfo rulerInfo = (IVerticalRulerInfo)this.currentEditor.getAdapter(IVerticalRulerInfo.class);
        if (rulerInfo == null) {
            return;
        }
        int lineOfLastMouseButtonActivity = rulerInfo.getLineOfLastMouseButtonActivity();
        if (lineOfLastMouseButtonActivity < 0) {
            return;
        }
        IDocument document = RulerToggleLambdaEntryBreakpointActionDelegate.getDocument((ITextEditor)this.currentEditor);
        if (document == null) {
            return;
        }
        ToggleBreakpointAdapter toggle = new ToggleBreakpointAdapter();
        try {
            ITextSelection selection = RulerToggleLambdaEntryBreakpointActionDelegate.getTextSelection(this.currentEditor, document, lineOfLastMouseButtonActivity);
            if (toggle.canToggleLineBreakpoints((IWorkbenchPart)this.currentEditor, (ISelection)selection)) {
                BreakpointToggleUtils.setUnsetLambdaEntryBreakpoint(true);
                toggle.toggleBreakpoints((IWorkbenchPart)this.currentEditor, (ISelection)selection);
            }
        }
        catch (CoreException | BadLocationException e) {
            DebugUIPlugin.log((Throwable)e);
        }
    }

    private static IDocument getDocument(ITextEditor editor) {
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider != null) {
            return provider.getDocument((Object)editor.getEditorInput());
        }
        IDocument doc = (IDocument)editor.getAdapter(IDocument.class);
        if (doc != null) {
            return doc;
        }
        return null;
    }

    private static ITextSelection getTextSelection(IEditorPart editor, IDocument document, int line) throws BadLocationException {
        ISelection selection;
        IRegion region = document.getLineInformation(line);
        TextSelection textSelection = new TextSelection(document, region.getOffset(), 0);
        ISelectionProvider provider = editor.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection && ((ITextSelection)selection).getStartLine() <= line && ((ITextSelection)selection).getEndLine() >= line) {
            textSelection = (ITextSelection)selection;
        }
        return textSelection;
    }
}

