/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.rulebased.internal.expressions;

import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.types.rulebased.CompositeRuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.NotRuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.RuleConfiguration;

public class RuleConfigurationPropertyTester
extends PropertyTester {
    private static final String CONTAINER = "container";
    private static final String OPERAND_COUNT = "operandCount";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result;
        block10: {
            result = false;
            RuleConfiguration rule = this.asRuleConfiguration(receiver);
            if (rule == null) break block10;
            switch (property) {
                case "container": {
                    result = this.testContainer(rule, this.asEClass(rule, expectedValue));
                    break;
                }
                case "operandCount": {
                    result = this.testOperandCount(rule, this.asIntPredicate(expectedValue));
                }
            }
        }
        return result;
    }

    boolean testContainer(RuleConfiguration rule, EClass expectedContainer) {
        EObject container = rule.eContainer();
        return expectedContainer == null ? container == null : expectedContainer.isInstance((Object)container);
    }

    boolean testOperandCount(RuleConfiguration rule, IntPredicate operandCountPredicate) {
        int operandCount = 0;
        if (rule instanceof NotRuleConfiguration) {
            operandCount = ((NotRuleConfiguration)rule).getComposedRule() != null ? 1 : 0;
        } else if (rule instanceof CompositeRuleConfiguration) {
            operandCount = ((CompositeRuleConfiguration)rule).getComposedRules().size();
        }
        return operandCountPredicate.test(operandCount);
    }

    private RuleConfiguration asRuleConfiguration(Object object) {
        EObject eObject = EMFHelper.getEObject((Object)object);
        return eObject instanceof RuleConfiguration ? (RuleConfiguration)eObject : null;
    }

    private EClass asEClass(EObject context, Object classValue) {
        EClass result = null;
        if (classValue != null) {
            result = EcorePackage.Literals.EOBJECT;
            String classSpec = String.valueOf(classValue);
            int fragmentSeparator = classSpec.indexOf(35);
            if (fragmentSeparator >= 0) {
                URI uri = URI.createURI((String)classSpec);
                result = this.getEClass(context, uri);
            } else {
                result = this.findEClass(context, classSpec);
            }
        }
        return result;
    }

    private IntPredicate asIntPredicate(Object expression) {
        IntPredicate result;
        if (expression == null) {
            result = i -> i > 0;
        } else {
            String predicateSpec = String.valueOf(expression);
            result = Integer.valueOf(predicateSpec)::equals;
        }
        return result;
    }

    private EClass getEClass(EObject context, URI uri) {
        EObject resolved = null;
        ResourceSet rset = EMFHelper.getResourceSet((EObject)context);
        if (rset != null) {
            resolved = rset.getEObject(uri, true);
        } else {
            Resource resource;
            EPackage package_ = EPackage.Registry.INSTANCE.getEPackage(uri.trimFragment().toString());
            Resource resource2 = resource = package_ != null ? package_.eResource() : null;
            if (resource != null) {
                resolved = resource.getEObject(uri.fragment());
            }
        }
        return resolved instanceof EClass ? (EClass)resolved : null;
    }

    private EClass findEClass(EObject context, String instanceClassName) {
        EClass result = this.getEClass(context.eClass().getEPackage(), instanceClassName);
        if (result == null) {
            result = context.eClass().getEAllSuperTypes().stream().map(EClassifier::getEPackage).filter(Predicate.not(context.eClass().getEPackage()::equals)).distinct().map(package_ -> this.getEClass((EPackage)package_, instanceClassName)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return result;
    }

    private EClass getEClass(EPackage package_, String instanceClassName) {
        return package_.getEClassifiers().stream().filter(c -> instanceClassName.equals(c.getInstanceClassName())).filter(EClass.class::isInstance).map(EClass.class::cast).findAny().orElse(null);
    }
}

