/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.IEditHelperAdviceDescriptor;
import org.osgi.framework.FrameworkUtil;

public class ClientContext
implements IClientContext {
    private final String id;
    private final IElementMatcher matcher;
    private final Set<String> typeIdBindings = new HashSet<String>();
    private final Set<Pattern> patternBindings = new HashSet<Pattern>();
    private Boolean dynamic;

    public ClientContext(String id, IElementMatcher matcher) {
        this.id = id;
        this.matcher = matcher;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final IElementMatcher getMatcher() {
        return this.matcher;
    }

    @Override
    public boolean includes(IEditHelperAdviceDescriptor adviceDescriptor) {
        return this.includes(adviceDescriptor.getId());
    }

    @Override
    public boolean includes(IElementTypeDescriptor elementTypeDescriptor) {
        return this.includes(elementTypeDescriptor.getId());
    }

    @Override
    public boolean includes(IElementType elementType) {
        return this.includes(elementType.getId());
    }

    private boolean includes(String _id) {
        boolean result = false;
        result = this.typeIdBindings.contains(_id);
        if (!result && !this.patternBindings.isEmpty() && (result = this.hasPatternBindingFor(_id))) {
            this.bindId(_id);
        }
        return result;
    }

    private boolean hasPatternBindingFor(String toMatch) {
        for (Pattern pattern : this.patternBindings) {
            if (!pattern.matcher(toMatch).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void bindId(String typeId) {
        this.typeIdBindings.add(typeId);
    }

    @Override
    public void bindPattern(Pattern pattern) {
        this.patternBindings.add(pattern);
    }

    public void unbindId(String typeId) {
        this.typeIdBindings.remove(typeId);
    }

    public void unbindPattern(Pattern pattern) {
        if (this.patternBindings.remove(pattern)) {
            Matcher m = pattern.matcher("");
            Iterator<String> iter = this.typeIdBindings.iterator();
            while (iter.hasNext()) {
                m.reset(iter.next());
                if (!m.matches()) continue;
                iter.remove();
            }
        }
    }

    @Override
    public Collection getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isMultiClientContext() {
        return false;
    }

    public final boolean isDynamic() {
        if (this.dynamic == null) {
            this.dynamic = FrameworkUtil.getBundle(this.getClass()) != EMFTypePlugin.getPlugin().getBundle() ? Boolean.TRUE : Boolean.valueOf(this.computeDynamic());
        }
        return this.dynamic;
    }

    protected boolean computeDynamic() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof ClientContext && ((ClientContext)obj).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "ClientContext[" + this.getId() + "]";
    }
}

