/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Disposable;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.infra.core.utils.OneShotExecutor;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.ui.util.TransactionUIHelper;
import org.eclipse.uml2.uml.MessageEnd;

class TimeElementEditPartHelper {
    private static final MessageTracker NONE = new MessageTracker();
    private final IGraphicalEditPart owner;
    private final Supplier<? extends Optional<MessageEnd>> messageEndSupplier;
    private final Executor executor;
    private MessageTracker messageTracker = NONE;

    public TimeElementEditPartHelper(IGraphicalEditPart owner, Supplier<? extends Optional<MessageEnd>> messageEndSupplier) {
        this.owner = owner;
        this.messageEndSupplier = messageEndSupplier;
        this.executor = new OneShotExecutor(TransactionUIHelper.getExecutor((TransactionalEditingDomain)owner.getEditingDomain()));
    }

    boolean refreshBounds(IBorderItemLocator locator) {
        Optional<Point> messageEndLoc;
        boolean result = false;
        if (locator != null && (messageEndLoc = Optional.ofNullable(this.getLocation())).isPresent()) {
            Dimension size = new Dimension(((Integer)this.owner.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width())).intValue(), ((Integer)this.owner.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height())).intValue());
            locator.setConstraint(new Rectangle(messageEndLoc.get(), size));
            result = true;
        }
        return result;
    }

    private void postRefresh() {
        this.executor.execute(() -> DiagramHelper.refresh((EditPart)this.owner, (boolean)true));
    }

    Optional<MessageEnd> getMessageEnd() {
        return this.messageEndSupplier.get();
    }

    Point getLocation() {
        return this.getMessage().getLocation();
    }

    private MessageTracker getMessage() {
        if (!this.messageTracker.isValid()) {
            this.messageTracker.dispose();
            this.messageTracker = this.messageEndSupplier.get().map(end -> new MessageTracker(this, (MessageEnd)end)).filter(MessageTracker::isValid).orElse(NONE);
        }
        return this.messageTracker;
    }

    private static final class MessageTracker
    implements Supplier<ConnectionEditPart>,
    Disposable {
        private final PropertyChangeListener connectionListener = this::connectionMoved;
        private final TimeElementEditPartHelper owner;
        private final ConnectionEditPart connectionEP;
        private final Connection connection;
        private final boolean source;
        private final Point anchor = new Point();

        MessageTracker() {
            this.owner = null;
            this.connectionEP = null;
            this.connection = null;
            this.source = false;
        }

        MessageTracker(TimeElementEditPartHelper owner, MessageEnd end) {
            this.owner = owner;
            IGraphicalEditPart ep = DiagramEditPartsUtil.getChildByEObject((EObject)end.getMessage(), (IGraphicalEditPart)((IGraphicalEditPart)owner.owner.getRoot().getContents()), (boolean)true);
            if (ep instanceof ConnectionEditPart && ep.isActive()) {
                this.connectionEP = (ConnectionEditPart)ep;
                this.connection = (Connection)this.connectionEP.getFigure();
                this.connection.addPropertyChangeListener("points", this.connectionListener);
                this.source = end.isSend();
                this.anchor.setLocation(this.source ? this.connection.getPoints().getFirstPoint() : this.connection.getPoints().getLastPoint());
            } else {
                this.connectionEP = null;
                this.connection = null;
                this.source = false;
            }
        }

        public void dispose() {
            if (this.connection != null) {
                this.connection.removePropertyChangeListener("points", this.connectionListener);
            }
        }

        @Override
        public ConnectionEditPart get() {
            return this.isValid() ? this.connectionEP : null;
        }

        public Point getLocation() {
            Point result = null;
            if (this.isValid()) {
                ConnectionAnchor anchor = this.source ? this.connection.getSourceAnchor() : this.connection.getTargetAnchor();
                result = anchor.getReferencePoint().getCopy();
                this.owner.owner.getFigure().getParent().translateToRelative((Translatable)result);
            }
            return result;
        }

        boolean isValid() {
            return this.connectionEP != null && this.connectionEP.isActive();
        }

        private void connectionMoved(PropertyChangeEvent event) {
            Point newAnchor;
            PointList points = (PointList)event.getNewValue();
            Point point = newAnchor = this.source ? points.getFirstPoint() : points.getLastPoint();
            if (!this.anchor.equals((Object)newAnchor)) {
                this.anchor.setLocation(newAnchor);
                this.owner.postRefresh();
            }
        }
    }
}

