/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.properties;

public class MultiplicityParser {
    public static final String ANY = "0..*";
    public static final String STAR = "*";
    public static final String ONE = "1";
    public static final String OPTIONAL = "0..1";
    public static final String ONE_OR_MORE = "1..*";
    public static final String SEPARATOR = "..";

    public static int[] getBounds(String value) {
        String multiplicityValue;
        int[] bounds = null;
        if (value == null) {
            bounds = new int[]{1, 1};
        }
        if ((multiplicityValue = value).matches("([0-9]+\\.\\.)?([1-9][0-9]*|\\*)")) {
            bounds = MultiplicityParser.parseValidMultiplicity(multiplicityValue);
        }
        return bounds;
    }

    private static int[] parseValidMultiplicity(String multiplicityValue) {
        int[] bounds = null;
        if (multiplicityValue.equals(ANY) || multiplicityValue.equals(STAR)) {
            int[] nArray = new int[2];
            nArray[1] = -1;
            bounds = nArray;
        } else if (multiplicityValue.equals(OPTIONAL)) {
            int[] nArray = new int[2];
            nArray[1] = 1;
            bounds = nArray;
        } else if (multiplicityValue.equals(ONE_OR_MORE)) {
            bounds = new int[]{1, -1};
        } else if (multiplicityValue.equals(ONE)) {
            bounds = new int[]{1, 1};
        } else {
            try {
                int upper;
                int lower;
                if (multiplicityValue.contains(SEPARATOR)) {
                    lower = Integer.parseInt(multiplicityValue.substring(0, multiplicityValue.indexOf(SEPARATOR)));
                    String upperString = multiplicityValue.substring(multiplicityValue.indexOf(SEPARATOR) + SEPARATOR.length(), multiplicityValue.length());
                    upper = STAR.equals(upperString) ? -1 : Integer.parseInt(upperString);
                } else {
                    upper = lower = Integer.parseInt(multiplicityValue);
                }
                bounds = new int[]{lower, upper};
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bounds;
    }

    public static String getMultiplicity(int lower, int upper) {
        Object res = "";
        res = lower == 0 && upper == -1 ? ANY : (lower == 0 && upper == 1 ? OPTIONAL : (lower == 1 && upper == -1 ? ONE_OR_MORE : (lower == 1 && upper == 1 ? ONE : (lower == upper ? Integer.toString(lower) : (upper < 0 ? lower + "..*" : lower + SEPARATOR + upper)))));
        return res;
    }

    public static boolean isValidMultiplicity(String value) {
        int[] lowerUpper = MultiplicityParser.getBounds(value);
        if (lowerUpper == null || lowerUpper.length < 2) {
            return false;
        }
        int lower = lowerUpper[0];
        int upper = lowerUpper[1];
        return MultiplicityParser.isValidMultiplicity(lower, upper);
    }

    public static boolean isValidMultiplicity(int lower, int upper) {
        boolean isValid = true;
        if (lower < 0) {
            isValid = false;
        } else if (upper > 0 && upper < lower || upper == 0) {
            isValid = false;
        }
        return isValid;
    }
}

