/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.FileURIHandlerImpl;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.resource.ProjectManager;

public class StandalonePlatformURIHandlerImpl
extends URIHandlerImpl {
    private static final @NonNull FileURIHandlerImpl fileHandler = new FileURIHandlerImpl();
    private final @Nullable StandaloneProjectMap projectManager;

    public static void install(@NonNull URIConverter uriConverter, @Nullable StandaloneProjectMap projectManager) {
        EList uriHandlers = uriConverter.getURIHandlers();
        uriHandlers.add(0, new StandalonePlatformURIHandlerImpl(projectManager));
    }

    public StandalonePlatformURIHandlerImpl(@Nullable StandaloneProjectMap projectManager) {
        this.projectManager = projectManager;
        assert (!EMFPlugin.IS_ECLIPSE_RUNNING);
    }

    public boolean canHandle(URI uri) {
        return uri.isPlatform() && this.projectManager != null;
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        assert (uri != null);
        URI fileURI = this.getFileURI(uri);
        if (fileURI != null) {
            return fileHandler.contentDescription(fileURI, options);
        }
        return super.contentDescription(this.getPluginURI(uri), options);
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        assert (uri != null);
        URI fileURI = this.getFileURI(uri);
        if (fileURI != null) {
            return fileHandler.createInputStream(fileURI, options);
        }
        return super.createInputStream(this.getPluginURI(uri), options);
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        assert (uri != null);
        URI fileURI = this.getFileURI(uri);
        if (fileURI != null) {
            return fileHandler.createOutputStream(fileURI, options);
        }
        return super.createOutputStream(this.getPluginURI(uri), options);
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        assert (uri != null);
        URI fileURI = this.getFileURI(uri);
        if (fileURI != null) {
            fileHandler.delete(fileURI, options);
        } else {
            super.delete(this.getPluginURI(uri), options);
        }
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        assert (uri != null);
        URI fileURI = this.getFileURI(uri);
        if (fileURI != null) {
            return fileHandler.exists(fileURI, options);
        }
        return super.exists(this.getPluginURI(uri), options);
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        assert (uri != null);
        URI fileURI = this.getFileURI(uri);
        if (fileURI != null) {
            return fileHandler.getAttributes(fileURI, options);
        }
        return super.getAttributes(this.getPluginURI(uri), options);
    }

    protected @Nullable URI getFileURI(@NonNull URI uri) {
        String bundleName = uri.segment(1);
        StandaloneProjectMap projectManager2 = this.projectManager;
        assert (projectManager2 != null);
        ProjectManager.IProjectDescriptor projectDescriptor = projectManager2.getProjectDescriptor(bundleName);
        if (projectDescriptor == null) {
            return null;
        }
        URI fileURI = projectDescriptor.getLocationURI();
        if (!fileURI.isFile()) {
            return null;
        }
        if (fileURI.hasTrailingPathSeparator()) {
            fileURI = fileURI.trimSegments(1);
        }
        int i = 2;
        while (i < uri.segmentCount()) {
            fileURI = fileURI.appendSegment(uri.segment(i));
            ++i;
        }
        return fileURI;
    }

    protected @NonNull URI getPluginURI(@NonNull URI uri) {
        if (uri.isPlatformPlugin()) {
            return uri;
        }
        return URI.createPlatformPluginURI((String)uri.toPlatformString(false), (boolean)false);
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        assert (uri != null);
        URI fileURI = this.getFileURI(uri);
        if (fileURI != null) {
            fileHandler.setAttributes(fileURI, attributes, options);
        } else {
            super.setAttributes(this.getPluginURI(uri), attributes, options);
        }
    }
}

