/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.providers;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemStyledLabelProvider;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedADElement;
import org.eclipse.papyrus.infra.core.architecture.provider.ArchitectureEditPlugin;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

public abstract class MergedArchitectureItemProvider
extends DelegatingWrapperItemProvider
implements Adapter,
IItemStyledLabelProvider {
    public MergedArchitectureItemProvider(AdapterFactory adapterFactory, MergedADElement owner) {
        super(owner.getAdapter(ADElement.class), (Object)owner, null, -1, adapterFactory);
    }

    protected ADElement getADElement() {
        return (ADElement)this.getValue();
    }

    protected MergedADElement getMergedElement() {
        return (MergedADElement)this.getOwner();
    }

    public String getText(Object object) {
        return ((MergedADElement)object).getName();
    }

    public Object getStyledText(Object object) {
        return new StyledString(this.getText(object));
    }

    public Object getImage(Object object) {
        URI result = null;
        ADElement imageObject = ((MergedADElement)object).getImageObject();
        if (imageObject != null && imageObject.getIcon() != null) {
            result = URI.createURI((String)imageObject.getIcon());
            ResourceSet rset = EMFHelper.getResourceSet((EObject)imageObject);
            if (rset != null) {
                result = rset.getURIConverter().normalize(result);
            }
            result = Optional.ofNullable(result).filter(URI::isPlatformResource).map(uri -> ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))).getLocationURI()).map(java.net.URI::toString).map(URI::createURI).orElse(result);
        }
        return result;
    }

    protected Stream<?> wrap(Object owner, Collection<?> objects) {
        return objects.stream().map(value -> this.createWrapper(value, owner, this.getRootAdapterFactory()));
    }

    protected void wrapInto(Object owner, Collection<?> objects, Collection<Object> wrappers) {
        this.wrap(owner, objects).forEach(wrappers::add);
    }

    protected Predicate<? super IItemPropertyDescriptor> propertyDescriptorFilter(Object object) {
        return __ -> false;
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = super.getPropertyDescriptors(object);
            this.propertyDescriptors.removeIf(this.propertyDescriptorFilter(object));
        }
        return this.propertyDescriptors;
    }

    protected String getString(String key) {
        return ArchitectureEditPlugin.INSTANCE.getString(key);
    }

    public boolean isAdapterForType(Object type) {
        return type == this.adapterFactory || type instanceof Class && ((Class)type).isInstance((Object)this);
    }

    public Notifier getTarget() {
        return this.getMergedElement();
    }

    public void setTarget(Notifier newTarget) {
    }
}

