/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.RequiredPluginsClasspathContainer;

public class RequiredPluginsInitializer
extends ClasspathContainerInitializer {
    private static final Job initPDEJob = Job.create((String)PDECoreMessages.PluginModelManager_InitializingPluginModels, monitor -> {
        if (!PDECore.getDefault().getModelManager().isInitialized()) {
            PDECore.getDefault().getModelManager().targetReloaded(monitor);
        }
    });
    private static final DeferredClasspathContainerInitializerJob deferredClasspathContainerInitializerJob = new DeferredClasspathContainerInitializerJob();

    public void initialize(IPath containerPath, IJavaProject javaProject) throws CoreException {
        if (Job.getJobManager().isSuspended()) {
            deferredClasspathContainerInitializerJob.initialize(javaProject);
        } else {
            RequiredPluginsInitializer.setupClasspath(javaProject);
        }
    }

    protected static void setupClasspath(IJavaProject ... javaProjects) throws JavaModelException {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        if (!manager.isInitialized()) {
            initPDEJob.schedule();
            try {
                initPDEJob.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LinkedHashMap<IJavaProject, RequiredPluginsClasspathContainer> classPathContainers = new LinkedHashMap<IJavaProject, RequiredPluginsClasspathContainer>();
        IJavaProject[] iJavaProjectArray = javaProjects;
        int n = javaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject = iJavaProjectArray[n2];
            IProject project = javaProject.getProject();
            if (project.exists() && project.isOpen()) {
                IPluginModelBase model = manager.findModel(project);
                RequiredPluginsClasspathContainer requiredPluginsClasspathContainer = new RequiredPluginsClasspathContainer(model, project);
                classPathContainers.put(javaProject, requiredPluginsClasspathContainer);
            }
            ++n2;
        }
        JavaCore.setClasspathContainer((IPath)PDECore.REQUIRED_PLUGINS_CONTAINER_PATH, (IJavaProject[])((IJavaProject[])classPathContainers.keySet().toArray(IJavaProject[]::new)), (IClasspathContainer[])((IClasspathContainer[])classPathContainers.values().toArray(IClasspathContainer[]::new)), null);
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        if (containerPath == null || project == null) {
            return null;
        }
        return containerPath.segment(0) + "/" + project.getPath().segment(0);
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        return PDECoreMessages.RequiredPluginsClasspathContainer_description;
    }

    public IStatus getSourceAttachmentStatus(IPath containerPath, IJavaProject project) {
        return Status.OK_STATUS;
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{containerSuggestion}, null);
    }

    private static class DeferredClasspathContainerInitializerJob
    extends Job {
        private final Set<IJavaProject> projects = new LinkedHashSet<IJavaProject>();

        public DeferredClasspathContainerInitializerJob() {
            super("DeferredClasspathContainerInitializerJob");
            this.setSystem(true);
        }

        public synchronized void initialize(IJavaProject project) {
            if (this.projects.add(project)) {
                this.schedule();
            }
        }

        private synchronized IJavaProject[] consumeProjects() {
            try {
                IJavaProject[] iJavaProjectArray = (IJavaProject[])this.projects.toArray(IJavaProject[]::new);
                return iJavaProjectArray;
            }
            finally {
                this.projects.clear();
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                RequiredPluginsInitializer.setupClasspath(this.consumeProjects());
            }
            catch (JavaModelException e) {
                PDECore.log(e);
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == PluginModelManager.class;
        }
    }
}

