/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class TreeCopyAction
extends Action {
    private final Tree[] fTrees;

    public TreeCopyAction(Tree[] trees) {
        this.fTrees = trees;
        this.setText("&Copy");
        this.setToolTipText("Copy to Clipboard");
        this.setEnabled(false);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.setId(ActionFactory.COPY.getId());
        this.setActionDefinitionId("org.eclipse.ui.edit.copy");
    }

    public void run() {
        Tree tree = null;
        Tree[] treeArray = this.fTrees;
        int n = this.fTrees.length;
        int n2 = 0;
        while (n2 < n) {
            Tree fTree = treeArray[n2];
            if (fTree.isFocusControl()) {
                tree = fTree;
                break;
            }
            ++n2;
        }
        if (tree == null) {
            return;
        }
        TreeItem[] selection = tree.getSelection();
        if (selection.length == 0) {
            return;
        }
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(tree.getDisplay());
            if (selection.length == 1) {
                clipboard.setContents(new Object[]{selection[0].getText()}, new Transfer[]{TextTransfer.getInstance()});
            } else if (selection.length > 1) {
                this.copyTree(selection, clipboard);
            }
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    private void copyTree(TreeItem[] selection, Clipboard clipboard) {
        HashMap<TreeItem, TreeObject> elementToTreeObj = new HashMap<TreeItem, TreeObject>();
        ArrayList<TreeObject> roots = new ArrayList<TreeObject>();
        int indent = Integer.MIN_VALUE;
        TreeItem[] treeItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            TreeObject treeObj = (TreeObject)elementToTreeObj.get(item);
            if (treeObj != null) {
                treeObj.setSelected();
            } else {
                treeObj = new TreeObject(item, true);
                elementToTreeObj.put(item, treeObj);
                int level = 0;
                item = item.getParentItem();
                while (item != null) {
                    TreeObject parentTreeObj = (TreeObject)elementToTreeObj.get(item);
                    if (parentTreeObj == null) {
                        parentTreeObj = new TreeObject(item, false);
                        elementToTreeObj.put(item, parentTreeObj);
                        parentTreeObj.addChild(treeObj);
                        treeObj = parentTreeObj;
                        item = item.getParentItem();
                        --level;
                        continue;
                    }
                    parentTreeObj.addChild(treeObj);
                    treeObj = parentTreeObj;
                    break;
                }
                if (item == null) {
                    roots.add(treeObj);
                    indent = Math.max(indent, level);
                }
            }
            ++n2;
        }
        elementToTreeObj = null;
        StringBuffer buf = new StringBuffer();
        this.appendSelectionObjects(buf, indent, roots);
        String result = buf.length() > 0 ? buf.substring(1) : buf.toString();
        clipboard.setContents(new Object[]{result}, new Transfer[]{TextTransfer.getInstance()});
    }

    private void appendSelectionObjects(StringBuffer buffer, int indent, List<TreeObject> selObjs) {
        for (TreeObject selObj : selObjs) {
            if (selObj.isSelected()) {
                buffer.append('\n');
                int d = 0;
                while (d < indent) {
                    buffer.append('\t');
                    ++d;
                }
                buffer.append(selObj.getTreeItem().getText());
            }
            this.appendSelectionObjects(buffer, indent + 1, selObj.getChildren());
        }
    }

    private static class TreeObject {
        private final TreeItem fTreeItem;
        private boolean fSelected;
        private final List<TreeObject> fChildren;

        public TreeObject(TreeItem element, boolean selected) {
            this.fTreeItem = element;
            this.fSelected = selected;
            this.fChildren = new ArrayList<TreeObject>();
        }

        public void setSelected() {
            this.fSelected = true;
        }

        public void addChild(TreeObject child) {
            this.fChildren.add(child);
        }

        public boolean isSelected() {
            return this.fSelected;
        }

        public TreeItem getTreeItem() {
            return this.fTreeItem;
        }

        public List<TreeObject> getChildren() {
            return this.fChildren;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.fSelected) {
                buf.append("* ");
            }
            buf.append(this.trim(this.fTreeItem.getText())).append(" [");
            int i = 0;
            while (i < this.fChildren.size()) {
                TreeObject child = this.fChildren.get(i);
                buf.append(this.trim(child.getTreeItem().getText()));
                if (i > 0) {
                    buf.append(", ");
                }
                ++i;
            }
            return buf.append("]").toString();
        }

        private String trim(String string) {
            if (string.length() > 60) {
                return string.substring(0, 60) + "...";
            }
            return string;
        }
    }
}

