/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorCommentPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorDescriptionPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorPlanningPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorSummaryPart;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TaskEditorFindSupport {
    private Action toggleFindAction;
    private static final Color HIGHLIGHTER_YELLOW = new Color((Device)Display.getDefault(), 255, 238, 99);
    private static final Color ERROR_NO_RESULT = new Color((Device)Display.getDefault(), 255, 150, 150);
    private final List<StyledText> styledTexts = new ArrayList<StyledText>();
    private final List<TaskEditorCommentPart.CommentGroupViewer> commentGroupViewers = new ArrayList<TaskEditorCommentPart.CommentGroupViewer>();
    private final AbstractTaskEditorPage taskEditorPage;

    public TaskEditorFindSupport(AbstractTaskEditorPage page) {
        Assert.isNotNull((Object)((Object)page));
        this.taskEditorPage = page;
    }

    public void toggleFind() {
        if (this.toggleFindAction != null) {
            this.toggleFindAction.setChecked(!this.toggleFindAction.isChecked());
            this.toggleFindAction.run();
        }
    }

    public void addFindAction(IToolBarManager toolBarManager) {
        if (this.toggleFindAction != null && this.toggleFindAction.isChecked()) {
            ControlContribution findTextboxControl = new ControlContribution(Messages.TaskEditorFindSupport_Find){

                protected Control createControl(Composite parent) {
                    FormToolkit toolkit = TaskEditorFindSupport.this.taskEditorPage.getEditor().getHeaderForm().getToolkit();
                    Composite findComposite = toolkit.createComposite(parent);
                    GridLayout findLayout = new GridLayout();
                    findLayout.marginHeight = 4;
                    findComposite.setLayout((Layout)findLayout);
                    findComposite.setBackground(null);
                    final Text findText = toolkit.createText(findComposite, "", 0x800000);
                    findText.setLayoutData((Object)new GridData(100, -1));
                    findText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
                    findText.setFocus();
                    toolkit.adapt((Control)findText, false, false);
                    findText.addModifyListener(e -> {
                        if (findText.getText().equals("")) {
                            TaskEditorFindSupport.this.clearSearchResults();
                            findText.setBackground(null);
                        }
                    });
                    findText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetDefaultSelected(SelectionEvent event) {
                            TaskEditorFindSupport.this.searchTaskEditor(findText);
                        }
                    });
                    toolkit.paintBordersFor(findComposite);
                    return findComposite;
                }
            };
            toolBarManager.appendToGroup("additions", (IContributionItem)findTextboxControl);
        }
        if (this.toggleFindAction == null) {
            this.toggleFindAction = new Action("", 2){

                public void run() {
                    if (!this.isChecked()) {
                        TaskEditorFindSupport.this.clearSearchResults();
                    }
                    TaskEditorFindSupport.this.taskEditorPage.getEditor().updateHeaderToolBar();
                }
            };
            this.toggleFindAction.setImageDescriptor(CommonImages.FIND);
            this.toggleFindAction.setToolTipText(Messages.TaskEditorFindSupport_Find);
        }
        toolBarManager.appendToGroup("additions", (IAction)this.toggleFindAction);
    }

    protected void searchTaskEditor(Text findBox) {
        try {
            this.taskEditorPage.setReflow(false);
            findBox.setBackground(null);
            if (findBox.getText().equals("")) {
                return;
            }
            this.clearSearchResults();
            String searchString = findBox.getText().toLowerCase();
            IFormPart[] iFormPartArray = this.taskEditorPage.getManagedForm().getParts();
            int n = iFormPartArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPart part = iFormPartArray[n2];
                if (part instanceof AbstractTaskEditorPart) {
                    Control control = ((AbstractTaskEditorPart)part).getControl();
                    if (part instanceof TaskEditorSummaryPart) {
                        if (TaskEditorFindSupport.contains(this.taskEditorPage.getModel().getTaskData(), "task.common.summary", searchString)) {
                            TaskEditorFindSupport.gatherStyledTexts(control, this.styledTexts);
                        }
                    } else if (part instanceof TaskEditorPlanningPart) {
                        RichTextEditor noteEditor = ((TaskEditorPlanningPart)part).getPlanningPart().getNoteEditor();
                        if (noteEditor != null && noteEditor.getText() != null && noteEditor.getText().toLowerCase().contains(searchString)) {
                            TaskEditorFindSupport.gatherStyledTexts(control, this.styledTexts);
                        }
                    } else if (part instanceof TaskEditorDescriptionPart) {
                        if (TaskEditorFindSupport.contains(this.taskEditorPage.getModel().getTaskData(), "task.common.description", searchString)) {
                            TaskEditorFindSupport.gatherStyledTexts(control, this.styledTexts);
                        }
                    } else if (part instanceof TaskEditorCommentPart) {
                        this.commentGroupViewers.clear();
                        this.commentGroupViewers.addAll(((TaskEditorCommentPart)part).getCommentGroupViewers());
                        this.searchCommentPart(searchString, (TaskEditorCommentPart)part, this.commentGroupViewers, this.styledTexts);
                    }
                }
                ++n2;
            }
            for (StyledText styledText : this.styledTexts) {
                TaskEditorFindSupport.highlightMatches(searchString, styledText);
            }
            if (this.styledTexts.isEmpty()) {
                findBox.setBackground(ERROR_NO_RESULT);
            }
        }
        finally {
            this.taskEditorPage.setReflow(true);
        }
        this.taskEditorPage.reflow();
        findBox.setFocus();
    }

    protected static boolean contains(TaskData taskData, String attributeId, String searchString) {
        TaskAttribute attribute = taskData.getRoot().getMappedAttribute(attributeId);
        if (attribute != null) {
            return attribute.getValue().toLowerCase().contains(searchString);
        }
        return false;
    }

    private void searchCommentPart(String searchString, TaskEditorCommentPart part, List<TaskEditorCommentPart.CommentGroupViewer> commentGroupViewers, List<StyledText> styledTexts) {
        TaskData taskData = this.taskEditorPage.getModel().getTaskData();
        List commentAttributes = taskData.getAttributeMapper().getAttributesByType(taskData, "comment");
        if (!TaskEditorFindSupport.anyCommentContains(commentAttributes, searchString)) {
            return;
        }
        if (!part.isCommentSectionExpanded()) {
            try {
                part.setReflow(false);
                part.expandAllComments(false);
            }
            finally {
                part.setReflow(true);
            }
        }
        int end = commentAttributes.size();
        boolean expandMatchingGroup = true;
        int i = commentGroupViewers.size() - 1;
        while (i >= 0) {
            TaskEditorCommentPart.CommentGroupViewer group = commentGroupViewers.get(i);
            List<TaskEditorCommentPart.CommentViewer> commentViewers = group.getCommentViewers(group.getCommentGroup().getCommentAttributes());
            int start = end - commentViewers.size();
            List<TaskAttribute> groupAttributes = commentAttributes.subList(start, end);
            if (expandMatchingGroup && TaskEditorFindSupport.anyCommentContains(groupAttributes, searchString)) {
                if (!group.isExpanded()) {
                    try {
                        part.setReflow(false);
                        group.setExpanded(true);
                    }
                    finally {
                        part.setReflow(true);
                    }
                }
                expandMatchingGroup = false;
            }
            List<TaskEditorCommentPart.CommentViewer> matchingViewers = TaskEditorFindSupport.searchComments(groupAttributes, commentViewers, searchString);
            if (!group.isRenderedInSubSection() || group.isExpanded()) {
                try {
                    part.setReflow(false);
                    TaskEditorFindSupport.gatherStyledTexts(matchingViewers, styledTexts);
                }
                finally {
                    part.setReflow(true);
                }
                group.clearSectionHyperlink();
            } else if (!matchingViewers.isEmpty()) {
                this.addShowMoreLink(group, matchingViewers, part, searchString, styledTexts);
            } else {
                group.clearSectionHyperlink();
            }
            end = start;
            --i;
        }
    }

    protected void addShowMoreLink(final TaskEditorCommentPart.CommentGroupViewer group, final List<TaskEditorCommentPart.CommentViewer> matchingViewers, final TaskEditorCommentPart part, final String searchString, final List<StyledText> styledTexts) {
        HyperlinkAdapter listener = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ArrayList<StyledText> commentStyledTexts = new ArrayList<StyledText>();
                try {
                    TaskEditorFindSupport.this.taskEditorPage.setReflow(false);
                    part.setReflow(false);
                    group.setExpanded(true);
                    TaskEditorFindSupport.gatherStyledTexts(matchingViewers, commentStyledTexts);
                }
                finally {
                    TaskEditorFindSupport.this.taskEditorPage.setReflow(true);
                    part.setReflow(true);
                }
                for (StyledText styledText : commentStyledTexts) {
                    TaskEditorFindSupport.highlightMatches(searchString, styledText);
                    styledTexts.add(styledText);
                }
                group.clearSectionHyperlink();
                TaskEditorFindSupport.this.taskEditorPage.reflow();
            }
        };
        group.createSectionHyperlink(NLS.bind((String)Messages.TaskEditorFindSupport_Show_X_more_results, (Object)matchingViewers.size()), listener);
    }

    private static boolean anyCommentContains(List<TaskAttribute> commentAttributes, String text) {
        for (TaskAttribute commentAttribute : commentAttributes) {
            if (!TaskEditorFindSupport.commentContains(commentAttribute, text)) continue;
            return true;
        }
        return false;
    }

    private static boolean commentContains(TaskAttribute commentAttribute, String searchString) {
        TaskAttribute attribute = commentAttribute.getMappedAttribute("task.common.comment.text");
        return attribute.getValue().toLowerCase().contains(searchString);
    }

    private static List<TaskEditorCommentPart.CommentViewer> searchComments(List<TaskAttribute> commentAttributes, List<TaskEditorCommentPart.CommentViewer> commentViewers, String searchString) {
        ArrayList<TaskEditorCommentPart.CommentViewer> matchingViewers = new ArrayList<TaskEditorCommentPart.CommentViewer>();
        int i = 0;
        while (i < commentViewers.size()) {
            TaskEditorCommentPart.CommentViewer viewer = commentViewers.get(i);
            if (TaskEditorFindSupport.commentContains(commentAttributes.get(i), searchString)) {
                matchingViewers.add(viewer);
            }
            ++i;
        }
        return matchingViewers;
    }

    protected static void gatherStyledTexts(List<TaskEditorCommentPart.CommentViewer> commentViewers, List<StyledText> styledTexts) {
        for (TaskEditorCommentPart.CommentViewer viewer : commentViewers) {
            try {
                ExpandableComposite composite = (ExpandableComposite)viewer.getControl();
                viewer.suppressSelectionChanged(true);
                if (composite != null && !composite.isExpanded()) {
                    CommonFormUtil.setExpanded((ExpandableComposite)composite, (boolean)true);
                }
                TaskEditorFindSupport.gatherStyledTextsInComposite((Composite)composite, styledTexts);
            }
            finally {
                viewer.suppressSelectionChanged(false);
            }
        }
    }

    private static void gatherStyledTexts(Control control, List<StyledText> result) {
        if (control instanceof ExpandableComposite) {
            ExpandableComposite composite = (ExpandableComposite)control;
            if (!composite.isExpanded()) {
                CommonFormUtil.setExpanded((ExpandableComposite)composite, (boolean)true);
            }
            TaskEditorFindSupport.gatherStyledTextsInComposite((Composite)composite, result);
        } else if (control instanceof Composite) {
            TaskEditorFindSupport.gatherStyledTextsInComposite((Composite)control, result);
        }
    }

    private static void gatherStyledTextsInComposite(Composite composite, List<StyledText> result) {
        if (composite != null && !composite.isDisposed()) {
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof StyledText) {
                    result.add((StyledText)child);
                } else if (child instanceof Composite) {
                    TaskEditorFindSupport.gatherStyledTextsInComposite((Composite)child, result);
                }
                ++n2;
            }
        }
    }

    private static void highlightMatches(String searchString, StyledText styledText) {
        String text = styledText.getText().toLowerCase();
        int index = 0;
        while (index < text.length()) {
            if ((index = text.indexOf(searchString, index)) == -1) break;
            styledText.setStyleRange(new StyleRange(index, searchString.length(), null, HIGHLIGHTER_YELLOW));
            index += searchString.length();
        }
    }

    private void clearSearchResults() {
        for (StyledText oldText : this.styledTexts) {
            ArrayList<StyleRange> otherRanges = new ArrayList<StyleRange>();
            if (oldText.isDisposed()) continue;
            StyleRange[] styleRangeArray = oldText.getStyleRanges();
            int n = styleRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange styleRange = styleRangeArray[n2];
                if (styleRange.background == null || !styleRange.background.equals((Object)HIGHLIGHTER_YELLOW)) {
                    otherRanges.add(styleRange);
                }
                ++n2;
            }
            oldText.setStyleRanges(otherRanges.toArray(new StyleRange[otherRanges.size()]));
        }
        this.styledTexts.clear();
        for (TaskEditorCommentPart.CommentGroupViewer group : this.commentGroupViewers) {
            group.clearSectionHyperlink();
        }
    }
}

