/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.services.internal;

import java.util.ArrayList;
import org.eclipse.papyrus.infra.ui.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.sirius.properties.services.internal.CustomSiriusContributorWrapper;
import org.eclipse.papyrus.sirius.properties.services.internal.PapyrusEEFTabbedPropertySheetPage;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.papyrus.views.properties.services.IPropertySheetPageProvider;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class EEFPropertySheetPageProvider
implements IPropertySheetPageProvider {
    private static final String DIAGRAM_VIEW_ID = "org.eclipse.sirius.diagram.ui";
    private static final String TREE_OUTLINE_VIEW_ID = "TreeOutlinePage";

    public String getRendererID() {
        return "EEF";
    }

    public boolean provides(Object realContributor, String viewID) {
        return realContributor instanceof CoreMultiDiagramEditor || realContributor instanceof ModelExplorerPageBookView;
    }

    public IPropertySheetPage createPropertyPage(Object realContributor, String viewID) {
        if (this.provides(realContributor, viewID)) {
            ArrayList<String> localViewIDs = new ArrayList<String>();
            if (realContributor instanceof CoreMultiDiagramEditor) {
                localViewIDs.add(TREE_OUTLINE_VIEW_ID);
                localViewIDs.add(DIAGRAM_VIEW_ID);
            } else if (realContributor instanceof ModelExplorerPageBookView) {
                localViewIDs.add(TREE_OUTLINE_VIEW_ID);
            } else {
                localViewIDs.add(viewID);
            }
            return new PapyrusEEFTabbedPropertySheetPage(new CustomSiriusContributorWrapper(realContributor, localViewIDs));
        }
        return null;
    }

    public void dispose(IPropertySheetPage propertySheetPage) {
    }
}

