/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.conversion;

import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.color.Color;
import org.eclipse.gef.dot.internal.language.shape.RecordBasedNodeShape;
import org.eclipse.gef.dot.internal.language.shape.RecordBasedShape;
import org.eclipse.gef.dot.internal.language.style.NodeStyle;
import org.eclipse.gef.dot.internal.language.style.Style;
import org.eclipse.gef.dot.internal.language.style.StyleItem;
import org.eclipse.gef.dot.internal.ui.conversion.DotColorUtil;
import org.eclipse.gef.dot.internal.ui.conversion.DotDefaultNodeStyleUtil;
import org.eclipse.gef.graph.Node;

public class DotRecordBasedNodeStyleUtil
extends DotDefaultNodeStyleUtil {
    boolean hasBorderStyle = false;

    public DotRecordBasedNodeStyleUtil(DotColorUtil colorUtil, Node dot) {
        super(colorUtil, dot);
    }

    @Override
    public StringBuilder computeZestStyle() {
        StringBuilder zestShapeStyle = super.computeZestStyle();
        RecordBasedNodeShape recordBasedShape = ((RecordBasedShape)DotAttributes.getShapeParsed((Node)this.dot).getShape()).getShape();
        if (RecordBasedNodeShape.MRECORD.equals((Object)recordBasedShape)) {
            zestShapeStyle.append("-fx-background-radius:10px;-fx-border-radius:10px;");
        }
        if (!this.hasBorderStyle) {
            zestShapeStyle.append("-fx-border-style:solid;");
        }
        return zestShapeStyle;
    }

    public StringBuilder computeLineStyle() {
        Style style;
        Double penwidth;
        StringBuilder zestStyle = new StringBuilder();
        Color dotColor = DotAttributes.getColorParsed((Node)this.dot);
        String dotColorScheme = DotAttributes.getColorscheme((Node)this.dot);
        String javaFxColor = this.colorUtil.computeZestColor(dotColorScheme, dotColor);
        if (javaFxColor != null) {
            zestStyle.append("-fx-stroke:" + javaFxColor + ";");
        }
        if ((penwidth = DotAttributes.getPenwidthParsed((Node)this.dot)) != null) {
            zestStyle.append("-fx-stroke-width:");
            zestStyle.append(penwidth);
            zestStyle.append(";");
        }
        if ((style = DotAttributes.getStyleParsed((Node)this.dot)) != null) {
            for (StyleItem styleItem : style.getStyleItems()) {
                NodeStyle nodeStyle = NodeStyle.get((String)styleItem.getName());
                if (nodeStyle == null) continue;
                super.addNodeStyle(zestStyle, nodeStyle, penwidth == null);
            }
        }
        return zestStyle;
    }

    @Override
    protected void addNodeStyle(StringBuilder zestStyle, NodeStyle style, boolean penwidthUnset) {
        switch (style) {
            case BOLD: {
                if (!penwidthUnset) break;
                zestStyle.append("-fx-border-width:2;");
                break;
            }
            case DASHED: {
                zestStyle.append("-fx-border-style:dashed;");
                this.hasBorderStyle = true;
                break;
            }
            case DIAGONALS: {
                break;
            }
            case DOTTED: {
                zestStyle.append("-fx-border-style:dotted;");
                this.hasBorderStyle = true;
                break;
            }
            case RADIAL: {
                break;
            }
            case ROUNDED: {
                break;
            }
            case SOLID: {
                zestStyle.append("-fx-border-style:solid;");
                this.hasBorderStyle = true;
                break;
            }
            case STRIPED: {
                break;
            }
        }
    }

    @Override
    protected String strokeWidthFxCssString() {
        return "-fx-border-width:";
    }

    @Override
    protected String strokeColorFxCssString() {
        return "-fx-border-color:";
    }

    @Override
    protected String fillFxCssString() {
        return "-fx-background-color:";
    }
}

