/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.Matchers;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsLockHelper;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsStaticFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.ComboBoxFilterUtils;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class ComboBoxGlazedListsFilterStrategy<T>
extends DefaultGlazedListsStaticFilterStrategy<T> {
    private FilterRowComboBoxDataProvider<T> comboBoxDataProvider;
    private MatcherEditor<T> matchNone = GlazedLists.fixedMatcherEditor((Matcher)Matchers.falseMatcher());

    public ComboBoxGlazedListsFilterStrategy(FilterRowComboBoxDataProvider<T> comboBoxDataProvider, FilterList<T> filterList, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        super(filterList, columnAccessor, configRegistry);
        this.comboBoxDataProvider = comboBoxDataProvider;
    }

    public ComboBoxGlazedListsFilterStrategy(FilterRowComboBoxDataProvider<T> comboBoxDataProvider, FilterList<T> filterList, CompositeMatcherEditor<T> matcherEditor, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        super(filterList, matcherEditor, columnAccessor, configRegistry);
        this.comboBoxDataProvider = comboBoxDataProvider;
    }

    @Override
    public void applyFilter(Map<Integer, Object> filterIndexToObjectMap) {
        if (filterIndexToObjectMap.isEmpty() && this.hasComboBoxFilterEditorRegistered()) {
            GlazedListsLockHelper.performWriteOperation(this.filterLock, () -> this.getMatcherEditor().getMatcherEditors().add(this.matchNone));
            return;
        }
        HashMap<Integer, Object> newIndexToObjectMap = new HashMap<Integer, Object>();
        newIndexToObjectMap.putAll(filterIndexToObjectMap);
        Iterator it = newIndexToObjectMap.entrySet().iterator();
        while (it.hasNext()) {
            Collection filterCollection;
            Map.Entry entry = it.next();
            Object filterObject = entry.getValue();
            if ("SELECT_ALL".equals(filterObject)) {
                it.remove();
                continue;
            }
            if (!ComboBoxFilterUtils.isFilterRowComboBoxCellEditor((IConfigRegistry)this.configRegistry, (int)((Integer)entry.getKey()))) continue;
            List dataProviderList = this.comboBoxDataProvider.getAllValues(((Integer)entry.getKey()).intValue());
            Collection collection = filterCollection = filterObject instanceof Collection ? (Collection)filterObject : null;
            if (filterCollection == null || filterCollection.isEmpty()) {
                GlazedListsLockHelper.performWriteOperation(this.filterLock, () -> this.getMatcherEditor().getMatcherEditors().add(this.matchNone));
                return;
            }
            if (!this.filterCollectionsEqual(filterCollection, dataProviderList)) continue;
            it.remove();
        }
        super.applyFilter(newIndexToObjectMap);
    }

    @Override
    protected String getStringFromColumnObject(int columnIndex, Object object) {
        Object result;
        IDisplayConverter displayConverter = (IDisplayConverter)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, DisplayMode.NORMAL, new String[]{"FILTER_COLUMN_" + columnIndex});
        if (object instanceof Collection) {
            Collection valueCollection = (Collection)object;
            StringJoiner joiner = new StringJoiner("|", "(", ")");
            for (Object value : valueCollection) {
                String convertedValue = displayConverter.canonicalToDisplayValue((ILayerCell)new LayerCell(null, columnIndex, 0), this.configRegistry, value).toString();
                if (convertedValue.isEmpty()) {
                    joiner.add("^$");
                    continue;
                }
                joiner.add(Pattern.quote(convertedValue));
            }
            return joiner.toString();
        }
        if (displayConverter != null && (result = displayConverter.canonicalToDisplayValue((ILayerCell)new LayerCell(null, columnIndex, 0), this.configRegistry, object)) != null) {
            return result.toString();
        }
        return "";
    }

    protected boolean filterCollectionsEqual(Collection filter1, Collection filter2) {
        return ObjectUtils.collectionsEqual((Collection)filter1, (Collection)filter2);
    }

    protected boolean hasComboBoxFilterEditorRegistered() {
        int i = 0;
        while (i < this.columnAccessor.getColumnCount()) {
            if (ComboBoxFilterUtils.isFilterRowComboBoxCellEditor((IConfigRegistry)this.configRegistry, (int)i)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

