/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.sdk.ui.internal.dialog;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.emf.facet.efacet.sdk.ui.internal.exception.SdkUiRuntimeException;
import org.eclipse.papyrus.emf.facet.util.core.DebugUtils;
import org.eclipse.papyrus.emf.facet.util.emf.core.EmfDebugUtils;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.displaysync.SynchronizedObject;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.util.dialog.AbstractMainDialog;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.util.widget.command.ICommandWidget;

public abstract class AbstractComandMainDialog<W extends ICommandWidget>
extends AbstractMainDialog<W> {
    private final EditingDomain editingDomain;

    public AbstractComandMainDialog(Object editedElement, EditingDomain editingDomain) {
        super(editedElement);
        this.editingDomain = editingDomain;
    }

    protected void execute() {
        Object result = this.getWidget().getCommand();
        if (result instanceof Command) {
            Command command = (Command)result;
            DebugUtils.debug((String)EmfDebugUtils.debugCommand((Command)command));
            if (command.canExecute()) {
                this.editingDomain.getCommandStack().execute(command);
            } else {
                Object widget = this.getWidget();
                if (widget instanceof SynchronizedObject) {
                    SynchronizedObject syncObject = (SynchronizedObject)widget;
                    widget = syncObject.getSynchronizedObject();
                }
                throw new SdkUiRuntimeException(NLS.bind((String)"The command created by {0} is not executable: {1}", (Object)widget.getClass().getName(), (Object)EmfDebugUtils.debugCommand((Command)command)));
            }
        }
    }

    protected final EditingDomain getEditingDomain() {
        return this.editingDomain;
    }
}

