/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.layer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CellLayerPainter
implements ILayerPainter {
    private ILayer natLayer;
    private Map<Integer, Integer> horizontalPositionToPixelMap;
    private Map<Integer, Integer> verticalPositionToPixelMap;
    private final boolean clipLeft;
    private final boolean clipTop;

    public CellLayerPainter() {
        this(false, false);
    }

    public CellLayerPainter(boolean clipLeft, boolean clipTop) {
        this.clipLeft = clipLeft;
        this.clipTop = clipTop;
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        if (pixelRectangle.width <= 0 || pixelRectangle.height <= 0) {
            return;
        }
        this.natLayer = natLayer;
        Rectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
        this.calculateDimensionInfo(positionRectangle);
        MutableSet spannedCells = Sets.mutable.empty();
        int rowPosition = positionRectangle.y;
        while (rowPosition < positionRectangle.y + positionRectangle.height) {
            int columnPosition = positionRectangle.x;
            while (columnPosition < positionRectangle.x + positionRectangle.width) {
                ILayerCell cell;
                if (columnPosition != -1 && rowPosition != -1 && (cell = natLayer.getCellByPosition(columnPosition, rowPosition)) != null) {
                    if (cell.isSpannedCell()) {
                        spannedCells.add(cell);
                    } else {
                        this.paintCell(cell, gc, configRegistry);
                    }
                }
                ++columnPosition;
            }
            ++rowPosition;
        }
        for (ILayerCell cell : spannedCells) {
            this.paintCell(cell, gc, configRegistry);
        }
    }

    protected boolean isClipLeft(int position) {
        return this.clipLeft;
    }

    protected boolean isClipTop(int position) {
        return this.clipTop;
    }

    private void calculateDimensionInfo(Rectangle positionRectangle) {
        this.horizontalPositionToPixelMap = new HashMap<Integer, Integer>();
        int startPosition = positionRectangle.x;
        int endPosition = startPosition + positionRectangle.width;
        int previousEndX = startPosition > 0 ? this.natLayer.getStartXOfColumnPosition(startPosition - 1) + this.natLayer.getColumnWidthByPosition(startPosition - 1) : Integer.MIN_VALUE;
        int position = startPosition;
        while (position < endPosition) {
            int startX = this.natLayer.getStartXOfColumnPosition(position);
            this.horizontalPositionToPixelMap.put(position, this.isClipLeft(position) ? startX : Math.max(startX, previousEndX));
            previousEndX = startX + this.natLayer.getColumnWidthByPosition(position);
            ++position;
        }
        if (endPosition < this.natLayer.getColumnCount()) {
            int startX = this.natLayer.getStartXOfColumnPosition(endPosition);
            this.horizontalPositionToPixelMap.put(endPosition, Math.max(startX, previousEndX));
        }
        this.verticalPositionToPixelMap = new HashMap<Integer, Integer>();
        startPosition = positionRectangle.y;
        endPosition = startPosition + positionRectangle.height;
        int previousEndY = startPosition > 0 ? this.natLayer.getStartYOfRowPosition(startPosition - 1) + this.natLayer.getRowHeightByPosition(startPosition - 1) : Integer.MIN_VALUE;
        position = startPosition;
        while (position < endPosition) {
            int startY = this.natLayer.getStartYOfRowPosition(position);
            this.verticalPositionToPixelMap.put(position, this.isClipTop(position) ? startY : Math.max(startY, previousEndY));
            previousEndY = startY + this.natLayer.getRowHeightByPosition(position);
            ++position;
        }
        if (endPosition < this.natLayer.getRowCount()) {
            int startY = this.natLayer.getStartYOfRowPosition(endPosition);
            this.verticalPositionToPixelMap.put(endPosition, Math.max(startY, previousEndY));
        }
    }

    @Override
    public Rectangle adjustCellBounds(int columnPosition, int rowPosition, Rectangle cellBounds) {
        return cellBounds;
    }

    protected Rectangle getPositionRectangleFromPixelRectangle(ILayer natLayer, Rectangle pixelRectangle) {
        int columnPositionOffset = natLayer.getColumnPositionByX(pixelRectangle.x);
        int rowPositionOffset = natLayer.getRowPositionByY(pixelRectangle.y);
        int numColumns = natLayer.getColumnPositionByX(Math.min(natLayer.getWidth(), pixelRectangle.x + pixelRectangle.width) - 1) - columnPositionOffset + 1;
        int numRows = natLayer.getRowPositionByY(Math.min(natLayer.getHeight(), pixelRectangle.y + pixelRectangle.height) - 1) - rowPositionOffset + 1;
        return new Rectangle(columnPositionOffset, rowPositionOffset, numColumns, numRows);
    }

    protected void paintCell(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        ILayer layer = cell.getLayer();
        int columnPosition = cell.getColumnPosition();
        int rowPosition = cell.getRowPosition();
        ICellPainter cellPainter = layer.getCellPainter(columnPosition, rowPosition, cell, configRegistry);
        Rectangle adjustedCellBounds = layer.getLayerPainter().adjustCellBounds(columnPosition, rowPosition, cell.getBounds());
        if (cellPainter != null) {
            Rectangle originalClipping = gc.getClipping();
            int startX = this.getStartXOfColumnPosition(columnPosition);
            int startY = this.getStartYOfRowPosition(rowPosition);
            int endX = this.getStartXOfColumnPosition(cell.getOriginColumnPosition() + cell.getColumnSpan());
            int endY = this.getStartYOfRowPosition(cell.getOriginRowPosition() + cell.getRowSpan());
            Rectangle cellClipBounds = originalClipping.intersection(new Rectangle(startX, startY, endX - startX, endY - startY));
            gc.setClipping(cellClipBounds.intersection(adjustedCellBounds));
            cellPainter.paintCell(cell, gc, adjustedCellBounds, configRegistry);
            gc.setClipping(originalClipping);
        }
    }

    protected int getStartXOfColumnPosition(int columnPosition) {
        if (columnPosition < this.natLayer.getColumnCount()) {
            Integer start = this.horizontalPositionToPixelMap.get(columnPosition);
            if (start == null) {
                int start2;
                start = this.natLayer.getStartXOfColumnPosition(columnPosition);
                if (columnPosition > 0 && (start2 = this.natLayer.getStartXOfColumnPosition(columnPosition - 1) + this.natLayer.getColumnWidthByPosition(columnPosition - 1)) > start) {
                    start = start2;
                }
                this.horizontalPositionToPixelMap.put(columnPosition, start);
            }
            return start;
        }
        return this.natLayer.getWidth();
    }

    protected int getStartYOfRowPosition(int rowPosition) {
        if (rowPosition < this.natLayer.getRowCount()) {
            Integer start = this.verticalPositionToPixelMap.get(rowPosition);
            if (start == null) {
                int start2;
                start = this.natLayer.getStartYOfRowPosition(rowPosition);
                if (rowPosition > 0 && (start2 = this.natLayer.getStartYOfRowPosition(rowPosition - 1) + this.natLayer.getRowHeightByPosition(rowPosition - 1)) > start) {
                    start = start2;
                }
                this.verticalPositionToPixelMap.put(rowPosition, start);
            }
            return start;
        }
        return this.natLayer.getHeight();
    }
}

