/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.grid.data;

import java.util.Map;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;

public class DefaultColumnHeaderDataProvider
implements IDataProvider {
    private final String[] propertyNames;
    private Map<String, String> propertyToLabelMap;

    public DefaultColumnHeaderDataProvider(String[] columnLabels) {
        this.propertyNames = columnLabels;
    }

    public DefaultColumnHeaderDataProvider(String[] propertyNames, Map<String, String> propertyToLabelMap) {
        this.propertyNames = propertyNames;
        this.propertyToLabelMap = propertyToLabelMap;
    }

    public String getColumnHeaderLabel(int columnIndex) {
        String label;
        String propertyName = this.propertyNames[columnIndex];
        if (this.propertyToLabelMap != null && (label = this.propertyToLabelMap.get(propertyName)) != null) {
            return label;
        }
        return propertyName;
    }

    @Override
    public int getColumnCount() {
        return this.propertyNames.length;
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public Object getDataValue(int columnIndex, int rowIndex) {
        if (columnIndex < 0 || columnIndex >= this.propertyNames.length) {
            return null;
        }
        return this.getColumnHeaderLabel(columnIndex);
    }

    @Override
    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        throw new UnsupportedOperationException();
    }
}

