/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.expressions.AssociationClassCallExp;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CallExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.ExpressionsPackage;
import org.eclipse.ocl.expressions.FeatureCallExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.InvalidLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.LiteralExp;
import org.eclipse.ocl.expressions.LoopExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.NavigationCallExp;
import org.eclipse.ocl.expressions.NullLiteralExp;
import org.eclipse.ocl.expressions.NumericLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PrimitiveLiteralExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.internal.OCLPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionsValidator
extends EObjectValidator {
    public static final ExpressionsValidator INSTANCE = new ExpressionsValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.ocl.expressions";
    public static final int BOOLEAN_LITERAL_EXP__BOOLEAN_TYPE = 1;
    public static final int COLLECTION_ITEM__ITEM_TYPE = 2;
    public static final int COLLECTION_LITERAL_EXP__NO_COLLECTION_INSTANCES = 3;
    public static final int COLLECTION_LITERAL_EXP__SET_KIND = 4;
    public static final int COLLECTION_LITERAL_EXP__SEQUENCE_KIND = 5;
    public static final int COLLECTION_LITERAL_EXP__BAG_KIND = 6;
    public static final int COLLECTION_LITERAL_EXP__ELEMENT_TYPE = 7;
    public static final int COLLECTION_RANGE__RANGE_TYPE = 8;
    public static final int ENUM_LITERAL_EXP__ENUM_TYPE = 9;
    public static final int IF_EXP__BOOLEAN_CONDITION = 10;
    public static final int IF_EXP__IF_TYPE = 11;
    public static final int INTEGER_LITERAL_EXP__INTEGER_TYPE = 12;
    public static final int UNLIMITED_NATURAL_LITERAL_EXP__NATURAL_TYPE = 13;
    public static final int ITERATE_EXP__ITERATE_TYPE = 14;
    public static final int ITERATE_EXP__BODY_TYPE = 15;
    public static final int ITERATE_EXP__RESULT_INIT = 16;
    public static final int LOOP_EXP__SOURCE_COLLECTION = 17;
    public static final int LOOP_EXP__LOOP_VARIABLE_INIT = 18;
    public static final int LOOP_EXP__LOOP_VARIABLE_TYPE = 19;
    public static final int VARIABLE__INIT_TYPE = 20;
    public static final int ITERATOR_EXP__BOOLEAN_TYPE = 21;
    public static final int ITERATOR_EXP__COLLECT_TYPE = 22;
    public static final int ITERATOR_EXP__SELECT_REJECT_TYPE = 23;
    public static final int ITERATOR_EXP__BOOLEAN_BODY_TYPE = 24;
    public static final int LET_EXP__LET_TYPE = 25;
    public static final int MESSAGE_EXP__OPERATION_ARGUMENTS = 26;
    public static final int MESSAGE_EXP__SIGNAL_ARGUMENTS = 27;
    public static final int MESSAGE_EXP__TARGET_DEFINES_OPERATION = 28;
    public static final int MESSAGE_EXP__HAS_OPERATION_OR_SIGNAL = 29;
    public static final int MESSAGE_EXP__TARGET_NOT_COLLECTION = 30;
    public static final int OPERATION_CALL_EXP__ARGUMENTS_CONFORM = 31;
    public static final int OPERATION_CALL_EXP__ARGUMENT_COUNT = 32;
    public static final int PROPERTY_CALL_EXP__PROPERTY_TYPE = 33;
    public static final int REAL_LITERAL_EXP__REAL_TYPE = 34;
    public static final int STRING_LITERAL_EXP__STRING_TYPE = 35;
    public static final int TUPLE_LITERAL_EXP__TUPLE_TYPE = 36;
    public static final int TUPLE_LITERAL_EXP__PARTS_UNIQUE = 37;
    public static final int TUPLE_LITERAL_PART__VALUE_TYPE = 38;
    public static final int VARIABLE_EXP__VAR_TYPE = 39;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 39;
    protected static final int DIAGNOSTIC_CODE_COUNT = 39;

    protected EPackage getEPackage() {
        return ExpressionsPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateAssociationClassCallExp((AssociationClassCallExp)value, diagnostics, context);
            }
            case 1: {
                return this.validateNavigationCallExp((NavigationCallExp)value, diagnostics, context);
            }
            case 2: {
                return this.validateFeatureCallExp((FeatureCallExp)value, diagnostics, context);
            }
            case 3: {
                return this.validateCallExp((CallExp)value, diagnostics, context);
            }
            case 4: {
                return this.validateOCLExpression((OCLExpression)value, diagnostics, context);
            }
            case 5: {
                return this.validateBooleanLiteralExp((BooleanLiteralExp)value, diagnostics, context);
            }
            case 6: {
                return this.validatePrimitiveLiteralExp((PrimitiveLiteralExp)value, diagnostics, context);
            }
            case 7: {
                return this.validateLiteralExp((LiteralExp)value, diagnostics, context);
            }
            case 8: {
                return this.validateCollectionItem((CollectionItem)value, diagnostics, context);
            }
            case 9: {
                return this.validateCollectionLiteralPart((CollectionLiteralPart)value, diagnostics, context);
            }
            case 10: {
                return this.validateCollectionLiteralExp((CollectionLiteralExp)value, diagnostics, context);
            }
            case 11: {
                return this.validateCollectionRange((CollectionRange)value, diagnostics, context);
            }
            case 12: {
                return this.validateEnumLiteralExp((EnumLiteralExp)value, diagnostics, context);
            }
            case 13: {
                return this.validateIfExp((IfExp)value, diagnostics, context);
            }
            case 14: {
                return this.validateIntegerLiteralExp((IntegerLiteralExp)value, diagnostics, context);
            }
            case 15: {
                return this.validateNumericLiteralExp((NumericLiteralExp)value, diagnostics, context);
            }
            case 16: {
                return this.validateUnlimitedNaturalLiteralExp((UnlimitedNaturalLiteralExp)value, diagnostics, context);
            }
            case 17: {
                return this.validateInvalidLiteralExp((InvalidLiteralExp)value, diagnostics, context);
            }
            case 18: {
                return this.validateIterateExp((IterateExp)value, diagnostics, context);
            }
            case 19: {
                return this.validateLoopExp((LoopExp)value, diagnostics, context);
            }
            case 20: {
                return this.validateVariable((Variable)value, diagnostics, context);
            }
            case 21: {
                return this.validateIteratorExp((IteratorExp)value, diagnostics, context);
            }
            case 22: {
                return this.validateLetExp((LetExp)value, diagnostics, context);
            }
            case 23: {
                return this.validateMessageExp((MessageExp)value, diagnostics, context);
            }
            case 24: {
                return this.validateNullLiteralExp((NullLiteralExp)value, diagnostics, context);
            }
            case 25: {
                return this.validateOperationCallExp((OperationCallExp)value, diagnostics, context);
            }
            case 26: {
                return this.validatePropertyCallExp((PropertyCallExp)value, diagnostics, context);
            }
            case 27: {
                return this.validateRealLiteralExp((RealLiteralExp)value, diagnostics, context);
            }
            case 28: {
                return this.validateStateExp((StateExp)value, diagnostics, context);
            }
            case 29: {
                return this.validateStringLiteralExp((StringLiteralExp)value, diagnostics, context);
            }
            case 30: {
                return this.validateTupleLiteralExp((TupleLiteralExp)value, diagnostics, context);
            }
            case 31: {
                return this.validateTupleLiteralPart((TupleLiteralPart)value, diagnostics, context);
            }
            case 32: {
                return this.validateTypeExp((TypeExp)value, diagnostics, context);
            }
            case 33: {
                return this.validateUnspecifiedValueExp((UnspecifiedValueExp)value, diagnostics, context);
            }
            case 34: {
                return this.validateVariableExp((VariableExp)value, diagnostics, context);
            }
            case 35: {
                return this.validateCollectionKind((CollectionKind)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateAssociationClassCallExp(AssociationClassCallExp<?, ?> associationClassCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(associationClassCallExp, diagnostics, context);
    }

    public boolean validateNavigationCallExp(NavigationCallExp<?, ?> navigationCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(navigationCallExp, diagnostics, context);
    }

    public boolean validateFeatureCallExp(FeatureCallExp<?> featureCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(featureCallExp, diagnostics, context);
    }

    public boolean validateCallExp(CallExp<?> callExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(callExp, diagnostics, context);
    }

    public boolean validateOCLExpression(OCLExpression<?> oclExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(oclExpression, diagnostics, context);
    }

    public boolean validateBooleanLiteralExp(BooleanLiteralExp<?> booleanLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(booleanLiteralExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(booleanLiteralExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(booleanLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(booleanLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(booleanLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(booleanLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(booleanLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(booleanLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(booleanLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBooleanLiteralExp_checkBooleanType(booleanLiteralExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateBooleanLiteralExp_checkBooleanType(BooleanLiteralExp<?> booleanLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return booleanLiteralExp.checkBooleanType(diagnostics, context);
    }

    public boolean validatePrimitiveLiteralExp(PrimitiveLiteralExp<?> primitiveLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(primitiveLiteralExp, diagnostics, context);
    }

    public boolean validateLiteralExp(LiteralExp<?> literalExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(literalExp, diagnostics, context);
    }

    public boolean validateCollectionItem(CollectionItem<?> collectionItem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(collectionItem, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(collectionItem, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(collectionItem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(collectionItem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(collectionItem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(collectionItem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(collectionItem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(collectionItem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(collectionItem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionItem_checkItemType(collectionItem, diagnostics, context);
        }
        return result;
    }

    public boolean validateCollectionItem_checkItemType(CollectionItem<?> collectionItem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return collectionItem.checkItemType(diagnostics, context);
    }

    public boolean validateCollectionLiteralPart(CollectionLiteralPart<?> collectionLiteralPart, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(collectionLiteralPart, diagnostics, context);
    }

    public boolean validateCollectionLiteralExp(CollectionLiteralExp<?> collectionLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(collectionLiteralExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(collectionLiteralExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(collectionLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(collectionLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(collectionLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(collectionLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(collectionLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(collectionLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(collectionLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionLiteralExp_checkNoCollectionInstances(collectionLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionLiteralExp_checkSetKind(collectionLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionLiteralExp_checkSequenceKind(collectionLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionLiteralExp_checkBagKind(collectionLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionLiteralExp_checkElementType(collectionLiteralExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateCollectionLiteralExp_checkNoCollectionInstances(CollectionLiteralExp<?> collectionLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return collectionLiteralExp.checkNoCollectionInstances(diagnostics, context);
    }

    public boolean validateCollectionLiteralExp_checkSetKind(CollectionLiteralExp<?> collectionLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return collectionLiteralExp.checkSetKind(diagnostics, context);
    }

    public boolean validateCollectionLiteralExp_checkSequenceKind(CollectionLiteralExp<?> collectionLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return collectionLiteralExp.checkSequenceKind(diagnostics, context);
    }

    public boolean validateCollectionLiteralExp_checkBagKind(CollectionLiteralExp<?> collectionLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return collectionLiteralExp.checkBagKind(diagnostics, context);
    }

    public boolean validateCollectionLiteralExp_checkElementType(CollectionLiteralExp<?> collectionLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return collectionLiteralExp.checkElementType(diagnostics, context);
    }

    public boolean validateCollectionRange(CollectionRange<?> collectionRange, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(collectionRange, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(collectionRange, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(collectionRange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(collectionRange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(collectionRange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(collectionRange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(collectionRange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(collectionRange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(collectionRange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionRange_checkRangeType(collectionRange, diagnostics, context);
        }
        return result;
    }

    public boolean validateCollectionRange_checkRangeType(CollectionRange<?> collectionRange, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return collectionRange.checkRangeType(diagnostics, context);
    }

    public boolean validateEnumLiteralExp(EnumLiteralExp<?, ?> enumLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(enumLiteralExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(enumLiteralExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(enumLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(enumLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(enumLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(enumLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(enumLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(enumLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(enumLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEnumLiteralExp_checkEnumType(enumLiteralExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateEnumLiteralExp_checkEnumType(EnumLiteralExp<?, ?> enumLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return enumLiteralExp.checkEnumType(diagnostics, context);
    }

    public boolean validateIfExp(IfExp<?> ifExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(ifExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(ifExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(ifExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(ifExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(ifExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(ifExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(ifExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(ifExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(ifExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIfExp_checkBooleanCondition(ifExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIfExp_checkIfType(ifExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateIfExp_checkBooleanCondition(IfExp<?> ifExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return ifExp.checkBooleanCondition(diagnostics, context);
    }

    public boolean validateIfExp_checkIfType(IfExp<?> ifExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return ifExp.checkIfType(diagnostics, context);
    }

    public boolean validateIntegerLiteralExp(IntegerLiteralExp<?> integerLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(integerLiteralExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(integerLiteralExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(integerLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(integerLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(integerLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(integerLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(integerLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(integerLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(integerLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIntegerLiteralExp_checkIntegerType(integerLiteralExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateIntegerLiteralExp_checkIntegerType(IntegerLiteralExp<?> integerLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return integerLiteralExp.checkIntegerType(diagnostics, context);
    }

    public boolean validateNumericLiteralExp(NumericLiteralExp<?> numericLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(numericLiteralExp, diagnostics, context);
    }

    public boolean validateUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp<?> unlimitedNaturalLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(unlimitedNaturalLiteralExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(unlimitedNaturalLiteralExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(unlimitedNaturalLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(unlimitedNaturalLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(unlimitedNaturalLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(unlimitedNaturalLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(unlimitedNaturalLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(unlimitedNaturalLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(unlimitedNaturalLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateUnlimitedNaturalLiteralExp_checkNaturalType(unlimitedNaturalLiteralExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateUnlimitedNaturalLiteralExp_checkNaturalType(UnlimitedNaturalLiteralExp<?> unlimitedNaturalLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return unlimitedNaturalLiteralExp.checkNaturalType(diagnostics, context);
    }

    public boolean validateInvalidLiteralExp(InvalidLiteralExp<?> invalidLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(invalidLiteralExp, diagnostics, context);
    }

    public boolean validateIterateExp(IterateExp<?, ?> iterateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(iterateExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(iterateExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(iterateExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(iterateExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(iterateExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(iterateExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(iterateExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(iterateExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(iterateExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLoopExp_checkSourceCollection(iterateExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLoopExp_checkLoopVariableInit(iterateExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLoopExp_checkLoopVariableType(iterateExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIterateExp_checkIterateType(iterateExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIterateExp_checkBodyType(iterateExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIterateExp_checkResultInit(iterateExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateIterateExp_checkIterateType(IterateExp<?, ?> iterateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return iterateExp.checkIterateType(diagnostics, context);
    }

    public boolean validateIterateExp_checkBodyType(IterateExp<?, ?> iterateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return iterateExp.checkBodyType(diagnostics, context);
    }

    public boolean validateIterateExp_checkResultInit(IterateExp<?, ?> iterateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return iterateExp.checkResultInit(diagnostics, context);
    }

    public boolean validateLoopExp(LoopExp<?, ?> loopExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(loopExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(loopExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(loopExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(loopExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(loopExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(loopExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(loopExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(loopExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(loopExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLoopExp_checkSourceCollection(loopExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLoopExp_checkLoopVariableInit(loopExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLoopExp_checkLoopVariableType(loopExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateLoopExp_checkSourceCollection(LoopExp<?, ?> loopExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return loopExp.checkSourceCollection(diagnostics, context);
    }

    public boolean validateLoopExp_checkLoopVariableInit(LoopExp<?, ?> loopExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return loopExp.checkLoopVariableInit(diagnostics, context);
    }

    public boolean validateLoopExp_checkLoopVariableType(LoopExp<?, ?> loopExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return loopExp.checkLoopVariableType(diagnostics, context);
    }

    public boolean validateVariable(Variable<?, ?> variable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(variable, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(variable, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(variable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(variable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(variable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(variable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(variable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(variable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(variable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateVariable_checkInitType(variable, diagnostics, context);
        }
        return result;
    }

    public boolean validateVariable_checkInitType(Variable<?, ?> variable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return variable.checkInitType(diagnostics, context);
    }

    public boolean validateIteratorExp(IteratorExp<?, ?> iteratorExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(iteratorExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(iteratorExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(iteratorExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(iteratorExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(iteratorExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(iteratorExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(iteratorExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(iteratorExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(iteratorExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLoopExp_checkSourceCollection(iteratorExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLoopExp_checkLoopVariableInit(iteratorExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLoopExp_checkLoopVariableType(iteratorExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIteratorExp_checkBooleanType(iteratorExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIteratorExp_checkCollectType(iteratorExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIteratorExp_checkSelectRejectType(iteratorExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIteratorExp_checkBooleanBodyType(iteratorExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateIteratorExp_checkBooleanType(IteratorExp<?, ?> iteratorExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return iteratorExp.checkBooleanType(diagnostics, context);
    }

    public boolean validateIteratorExp_checkCollectType(IteratorExp<?, ?> iteratorExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return iteratorExp.checkCollectType(diagnostics, context);
    }

    public boolean validateIteratorExp_checkSelectRejectType(IteratorExp<?, ?> iteratorExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return iteratorExp.checkSelectRejectType(diagnostics, context);
    }

    public boolean validateIteratorExp_checkBooleanBodyType(IteratorExp<?, ?> iteratorExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return iteratorExp.checkBooleanBodyType(diagnostics, context);
    }

    public boolean validateLetExp(LetExp<?, ?> letExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(letExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(letExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(letExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(letExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(letExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(letExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(letExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(letExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(letExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateLetExp_checkLetType(letExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateLetExp_checkLetType(LetExp<?, ?> letExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return letExp.checkLetType(diagnostics, context);
    }

    public boolean validateMessageExp(MessageExp<?, ?, ?> messageExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(messageExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(messageExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(messageExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(messageExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(messageExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(messageExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(messageExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(messageExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(messageExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageExp_checkOperationArguments(messageExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageExp_checkSignalArguments(messageExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageExp_checkTargetDefinesOperation(messageExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageExp_checkHasOperationOrSignal(messageExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageExp_checkTargetNotCollection(messageExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateMessageExp_checkOperationArguments(MessageExp<?, ?, ?> messageExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return messageExp.checkOperationArguments(diagnostics, context);
    }

    public boolean validateMessageExp_checkSignalArguments(MessageExp<?, ?, ?> messageExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return messageExp.checkSignalArguments(diagnostics, context);
    }

    public boolean validateMessageExp_checkTargetDefinesOperation(MessageExp<?, ?, ?> messageExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return messageExp.checkTargetDefinesOperation(diagnostics, context);
    }

    public boolean validateMessageExp_checkHasOperationOrSignal(MessageExp<?, ?, ?> messageExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return messageExp.checkHasOperationOrSignal(diagnostics, context);
    }

    public boolean validateMessageExp_checkTargetNotCollection(MessageExp<?, ?, ?> messageExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return messageExp.checkTargetNotCollection(diagnostics, context);
    }

    public boolean validateNullLiteralExp(NullLiteralExp<?> nullLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(nullLiteralExp, diagnostics, context);
    }

    public boolean validateOperationCallExp(OperationCallExp<?, ?> operationCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(operationCallExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(operationCallExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(operationCallExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(operationCallExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(operationCallExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(operationCallExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(operationCallExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(operationCallExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(operationCallExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOperationCallExp_checkArgumentsConform(operationCallExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOperationCallExp_checkArgumentCount(operationCallExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateOperationCallExp_checkArgumentsConform(OperationCallExp<?, ?> operationCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return operationCallExp.checkArgumentsConform(diagnostics, context);
    }

    public boolean validateOperationCallExp_checkArgumentCount(OperationCallExp<?, ?> operationCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return operationCallExp.checkArgumentCount(diagnostics, context);
    }

    public boolean validatePropertyCallExp(PropertyCallExp<?, ?> propertyCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(propertyCallExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(propertyCallExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(propertyCallExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(propertyCallExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(propertyCallExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(propertyCallExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(propertyCallExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(propertyCallExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(propertyCallExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePropertyCallExp_checkPropertyType(propertyCallExp, diagnostics, context);
        }
        return result;
    }

    public boolean validatePropertyCallExp_checkPropertyType(PropertyCallExp<?, ?> propertyCallExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return propertyCallExp.checkPropertyType(diagnostics, context);
    }

    public boolean validateRealLiteralExp(RealLiteralExp<?> realLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(realLiteralExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(realLiteralExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(realLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(realLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(realLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(realLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(realLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(realLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(realLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRealLiteralExp_checkRealType(realLiteralExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateRealLiteralExp_checkRealType(RealLiteralExp<?> realLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return realLiteralExp.checkRealType(diagnostics, context);
    }

    public boolean validateStateExp(StateExp<?, ?> stateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(stateExp, diagnostics, context);
    }

    public boolean validateStringLiteralExp(StringLiteralExp<?> stringLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(stringLiteralExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(stringLiteralExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(stringLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(stringLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(stringLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(stringLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(stringLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(stringLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(stringLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStringLiteralExp_checkStringType(stringLiteralExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateStringLiteralExp_checkStringType(StringLiteralExp<?> stringLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return stringLiteralExp.checkStringType(diagnostics, context);
    }

    public boolean validateTupleLiteralExp(TupleLiteralExp<?, ?> tupleLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(tupleLiteralExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(tupleLiteralExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(tupleLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(tupleLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(tupleLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(tupleLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(tupleLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(tupleLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(tupleLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTupleLiteralExp_checkTupleType(tupleLiteralExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTupleLiteralExp_checkPartsUnique(tupleLiteralExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateTupleLiteralExp_checkTupleType(TupleLiteralExp<?, ?> tupleLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return tupleLiteralExp.checkTupleType(diagnostics, context);
    }

    public boolean validateTupleLiteralExp_checkPartsUnique(TupleLiteralExp<?, ?> tupleLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return tupleLiteralExp.checkPartsUnique(diagnostics, context);
    }

    public boolean validateTupleLiteralPart(TupleLiteralPart<?, ?> tupleLiteralPart, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(tupleLiteralPart, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(tupleLiteralPart, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(tupleLiteralPart, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(tupleLiteralPart, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(tupleLiteralPart, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(tupleLiteralPart, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(tupleLiteralPart, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(tupleLiteralPart, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(tupleLiteralPart, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTupleLiteralPart_checkValueType(tupleLiteralPart, diagnostics, context);
        }
        return result;
    }

    public boolean validateTupleLiteralPart_checkValueType(TupleLiteralPart<?, ?> tupleLiteralPart, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return tupleLiteralPart.checkValueType(diagnostics, context);
    }

    public boolean validateTypeExp(TypeExp<?> typeExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(typeExp, diagnostics, context);
    }

    public boolean validateUnspecifiedValueExp(UnspecifiedValueExp<?> unspecifiedValueExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(unspecifiedValueExp, diagnostics, context);
    }

    public boolean validateVariableExp(VariableExp<?, ?> variableExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(variableExp, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(variableExp, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(variableExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(variableExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(variableExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(variableExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(variableExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(variableExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(variableExp, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateVariableExp_checkVarType(variableExp, diagnostics, context);
        }
        return result;
    }

    public boolean validateVariableExp_checkVarType(VariableExp<?, ?> variableExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return variableExp.checkVarType(diagnostics, context);
    }

    public boolean validateCollectionKind(CollectionKind collectionKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return OCLPlugin.INSTANCE;
    }
}

