/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.tests;

import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.LetExp;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.OppositePropertyCallExp;
import org.eclipse.ocl.ecore.tests.AbstractTestSuite;
import org.eclipse.ocl.expressions.OCLExpression;

public class OppositePropertyCallExpTest
extends AbstractTestSuite {
    protected EPackage hiddenOppositesPackage;
    protected EFactory hiddenOppositesFactory;
    protected EClass sup1;
    protected EReference sup1_sup2;
    protected EClass sup2;
    protected EClass sub;
    protected EReference sup2_sup1;
    protected EClass unrelated;
    protected EReference unrelated_hidden;
    protected EReference unrelated_forward;

    public void test_parseSimpleContainerOppositePropertyCallExp() {
        OCLExpression expr = this.parseConstraint("package ocltest context Stem inv: self.stemOfApple->notEmpty() endpackage");
        OppositePropertyCallExpTest.assertTrue((boolean)(expr instanceof OperationCallExp));
        OCLExpression source = ((OperationCallExp)expr).getSource();
        OppositePropertyCallExpTest.assertTrue((boolean)(source instanceof OppositePropertyCallExp));
        OppositePropertyCallExp opce = (OppositePropertyCallExp)source;
        OppositePropertyCallExpTest.assertEquals((Object)this.apple_stem, (Object)opce.getReferredOppositeProperty());
    }

    public void test_parseSimpleContainerOppositePropertyCallExpWithImplicitSelf() {
        OCLExpression expr = this.parseConstraint("package ocltest context Stem inv: stemOfApple->notEmpty() endpackage");
        OppositePropertyCallExpTest.assertTrue((boolean)(expr instanceof OperationCallExp));
        OCLExpression source = ((OperationCallExp)expr).getSource();
        OppositePropertyCallExpTest.assertTrue((boolean)(source instanceof OppositePropertyCallExp));
        OppositePropertyCallExp opce = (OppositePropertyCallExp)source;
        OppositePropertyCallExpTest.assertEquals((Object)this.apple_stem, (Object)opce.getReferredOppositeProperty());
    }

    public void test_evaluateSimpleOppositePropertyCallExp() {
        this.helper.setContext((Object)this.apple);
        try {
            String expr = "self.droppedUnderTree->notEmpty()";
            ResourceImpl res = new ResourceImpl();
            res.eAdapters().add((Object)new ECrossReferenceAdapter());
            EObject tree1 = this.fruitFactory.create(this.tree);
            res.getContents().add((Object)tree1);
            EObject apple1 = this.fruitFactory.create(this.apple);
            res.getContents().add((Object)apple1);
            ((Collection)tree1.eGet((EStructuralFeature)this.tree_fruitsDroppedUnder)).add(apple1);
            EObject apple2 = this.fruitFactory.create(this.apple);
            res.getContents().add((Object)apple2);
            apple2.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_yellow);
            OppositePropertyCallExpTest.assertTrue((boolean)((Boolean)this.evaluate(this.helper, apple1, expr)));
            OppositePropertyCallExpTest.assertFalse((boolean)((Boolean)this.evaluate(this.helper, apple2, expr)));
        }
        catch (Exception e) {
            OppositePropertyCallExpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_evaluateSimpleContainerOppositePropertyCallExp() {
        this.helper.setContext((Object)this.stem);
        try {
            String expr = "self.stemOfApple->notEmpty()";
            ResourceImpl res = new ResourceImpl();
            res.eAdapters().add((Object)new ECrossReferenceAdapter());
            EObject stem1 = this.fruitFactory.create(this.stem);
            res.getContents().add((Object)stem1);
            EObject stem2 = this.fruitFactory.create(this.stem);
            res.getContents().add((Object)stem2);
            EObject apple1 = this.fruitFactory.create(this.apple);
            res.getContents().add((Object)apple1);
            apple1.eSet((EStructuralFeature)this.fruit_color, (Object)this.color_yellow);
            apple1.eSet((EStructuralFeature)this.apple_stem, (Object)stem1);
            OppositePropertyCallExpTest.assertTrue((boolean)((Boolean)this.evaluate(this.helper, stem1, expr)));
            OppositePropertyCallExpTest.assertFalse((boolean)((Boolean)this.evaluate(this.helper, stem2, expr)));
        }
        catch (Exception e) {
            OppositePropertyCallExpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_evaluateInheritedContainerOppositePropertyCallExp() {
        this.helper.setContext((Object)this.apple);
        try {
            String expr = "self.tree->select(name='Apple Tree')->notEmpty()";
            ResourceImpl res = new ResourceImpl();
            res.eAdapters().add((Object)new ECrossReferenceAdapter());
            EObject tree1 = this.fruitFactory.create(this.tree);
            tree1.eSet((EStructuralFeature)this.tree_name, (Object)"Apple Tree");
            res.getContents().add((Object)tree1);
            EObject apple1 = this.fruitFactory.create(this.apple);
            res.getContents().add((Object)apple1);
            ((Collection)tree1.eGet((EStructuralFeature)this.tree_fruits)).add(apple1);
            EObject apple2 = this.fruitFactory.create(this.apple);
            res.getContents().add((Object)apple2);
            OppositePropertyCallExpTest.assertTrue((boolean)((Boolean)this.evaluate(this.helper, apple1, expr)));
            OppositePropertyCallExpTest.assertFalse((boolean)((Boolean)this.evaluate(this.helper, apple2, expr)));
        }
        catch (Exception e) {
            OppositePropertyCallExpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_parseMoreSpecificInheritedOppositePropertyCallExpInsteadMoreGeneralPropertyCallExp() {
        this.initHiddenOppositesTestPackage();
        this.helper.setContext((Object)this.sub);
        try {
            String expr = "self.sup1";
            OCLExpression ast = this.helper.createQuery(expr);
            OppositePropertyCallExpTest.assertTrue((boolean)(ast instanceof OppositePropertyCallExp));
            OppositePropertyCallExp opce = (OppositePropertyCallExp)ast;
            OppositePropertyCallExpTest.assertTrue((opce.getReferredOppositeProperty() == this.sup1_sup2 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            OppositePropertyCallExpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_parseOppositePropertyCallExpOnNestedImplicitSource() {
        this.initHiddenOppositesTestPackage();
        this.helper.setContext((Object)this.unrelated);
        try {
            String expr = "let s:Set(Sup2) = Set{} in s->exists(hidden = null)";
            OCLExpression ast = this.helper.createQuery(expr);
            OppositePropertyCallExpTest.assertTrue((boolean)(ast instanceof LetExp));
            OCLExpression iterator = ((LetExp)ast).getIn();
            OppositePropertyCallExpTest.assertTrue((boolean)(iterator instanceof IteratorExp));
            OCLExpression body = ((IteratorExp)iterator).getBody();
            OppositePropertyCallExpTest.assertTrue((boolean)(body instanceof OperationCallExp));
            OperationCallExp opCallExp = (OperationCallExp)body;
            OCLExpression opce = opCallExp.getSource();
            OppositePropertyCallExpTest.assertTrue((boolean)(opce instanceof OppositePropertyCallExp));
            OppositePropertyCallExpTest.assertTrue((((OppositePropertyCallExp)opce).getReferredOppositeProperty() == this.unrelated_forward ? 1 : 0) != 0);
        }
        catch (Exception e) {
            OppositePropertyCallExpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    public void test_evaluateInheritedOppositePropertyCallExp() {
        this.helper.setContext((Object)this.apple);
        try {
            String expr = "self.droppedUnderTree->select(name='Apple Tree')->notEmpty()";
            ResourceImpl res = new ResourceImpl();
            res.eAdapters().add((Object)new ECrossReferenceAdapter());
            EObject tree1 = this.fruitFactory.create(this.tree);
            tree1.eSet((EStructuralFeature)this.tree_name, (Object)"Apple Tree");
            res.getContents().add((Object)tree1);
            EObject apple1 = this.fruitFactory.create(this.apple);
            res.getContents().add((Object)apple1);
            ((Collection)tree1.eGet((EStructuralFeature)this.tree_fruitsDroppedUnder)).add(apple1);
            EObject apple2 = this.fruitFactory.create(this.apple);
            res.getContents().add((Object)apple2);
            OppositePropertyCallExpTest.assertTrue((boolean)((Boolean)this.evaluate(this.helper, apple1, expr)));
            OppositePropertyCallExpTest.assertFalse((boolean)((Boolean)this.evaluate(this.helper, apple2, expr)));
        }
        catch (Exception e) {
            OppositePropertyCallExpTest.fail((String)("Parse failed: " + e.getLocalizedMessage()));
        }
    }

    private void initHiddenOppositesTestPackage() {
        URI uri = this.getTestModelURI("/model/HiddenOpposites.ecore");
        Resource res = resourceSet.getResource(uri, true);
        this.hiddenOppositesPackage = (EPackage)res.getContents().get(0);
        resourceSet.getPackageRegistry().put((Object)this.hiddenOppositesPackage.getNsURI(), (Object)this.hiddenOppositesPackage);
        this.hiddenOppositesFactory = this.hiddenOppositesPackage.getEFactoryInstance();
        this.sup1 = (EClass)this.hiddenOppositesPackage.getEClassifier("Sup1");
        this.sup1_sup2 = (EReference)this.sup1.getEStructuralFeature("sup2");
        this.sup2 = (EClass)this.hiddenOppositesPackage.getEClassifier("Sup2");
        this.sup2_sup1 = (EReference)this.sup2.getEStructuralFeature("sup1");
        this.sub = (EClass)this.hiddenOppositesPackage.getEClassifier("Sub");
        this.unrelated = (EClass)this.hiddenOppositesPackage.getEClassifier("Unrelated");
        this.unrelated_forward = (EReference)this.unrelated.getEStructuralFeature("forward");
        this.unrelated_hidden = (EReference)this.unrelated.getEStructuralFeature("hidden");
    }
}

