/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.analysis;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.build.analysis.AbstractRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.AnalysisUtils;
import org.eclipse.ocl.examples.xtext.build.analysis.CardinalityExpression;
import org.eclipse.ocl.examples.xtext.build.analysis.CardinalityVariable;
import org.eclipse.ocl.examples.xtext.build.analysis.GrammarAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.IdiomSerializationMatch;
import org.eclipse.ocl.examples.xtext.build.analysis.LocatorHelper;
import org.eclipse.ocl.examples.xtext.build.analysis.ParserRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.SerializationMatchTermRuntime;
import org.eclipse.ocl.examples.xtext.build.elements.AbstractUnassignedSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AlternativeAssignedKeywordsSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AlternativeAssignsSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AssignedKeywordSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AssignedRuleCallSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.AssignedSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.CompositeSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.SequenceSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationNode;
import org.eclipse.ocl.examples.xtext.idioms.Idiom;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsUtils;
import org.eclipse.ocl.examples.xtext.idioms.Locator;
import org.eclipse.ocl.examples.xtext.idioms.LocatorDeclaration;
import org.eclipse.ocl.examples.xtext.idioms.ReferredLocator;
import org.eclipse.ocl.examples.xtext.idioms.SubIdiom;
import org.eclipse.ocl.examples.xtext.idioms.impl.LocatorImpl;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.EnumerationValue;
import org.eclipse.ocl.examples.xtext.serializer.GrammarCardinality;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleValue;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleVector;
import org.eclipse.ocl.examples.xtext.serializer.Nameable;
import org.eclipse.ocl.examples.xtext.serializer.ParserRuleValue;
import org.eclipse.ocl.examples.xtext.serializer.RuleMatch;
import org.eclipse.ocl.examples.xtext.serializer.SerializationMatchStep;
import org.eclipse.ocl.examples.xtext.serializer.SerializationMatchTerm;
import org.eclipse.ocl.examples.xtext.serializer.SerializationRule;
import org.eclipse.ocl.examples.xtext.serializer.SerializationRuleHelper;
import org.eclipse.ocl.examples.xtext.serializer.SerializationStep;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.ocl.examples.xtext.serializer.ToDebugString;

public class SerializationRuleAnalysis
implements Nameable,
ToDebugString.ToDebugStringable,
RuleMatch,
SerializationRuleHelper {
    private static final @NonNull Map<@NonNull SerializationRuleAnalysis, @NonNull SerializationRule> debugMap = new HashMap<SerializationRuleAnalysis, SerializationRule>();
    protected final @NonNull ParserRuleAnalysis ruleAnalysis;
    protected final @NonNull GrammarAnalysis grammarAnalysis;
    protected final @NonNull SerializationNode rootSerializationNode;
    protected final @NonNull EClass producedEClass;
    protected final int variantNumber;
    protected final @NonNull String variantName;
    private final @NonNull ToDebugString toDebugString = new ToDebugString(this){};
    private boolean hasMatchAnalyses = false;
    private @Nullable Map<@NonNull SerializationNode, @NonNull List<@NonNull SubIdiom>> serializationNode2subIdioms = null;
    private @Nullable Map<@NonNull EAttribute, @NonNull Set<@NonNull EnumerationValue>> eAttribute2enumerationValues = null;
    private @Nullable Map<@NonNull EReference, @NonNull GrammarRuleVector> eReference2assignedRuleIndexes = null;
    private @Nullable Map<@NonNull EAttribute, @NonNull Map<@Nullable EnumerationValue, @NonNull GrammarCardinality>> eAttribute2enumerationValue2grammarCardinality = null;
    private @Nullable Map<@NonNull EReference, @NonNull Map<@NonNull ParserRuleAnalysis, @NonNull GrammarCardinality>> eReference2ruleAnalysis2grammarCardinality = null;
    protected final @NonNull Map<@NonNull EStructuralFeature, @NonNull CardinalityExpression> eStructuralFeature2requiredSlotsExpression = new HashMap<EStructuralFeature, CardinalityExpression>();
    protected final @NonNull Map<@NonNull Integer, @NonNull SerializationMatchTerm> variableIndex2solution = new HashMap<Integer, SerializationMatchTerm>();
    protected final @NonNull List<@NonNull SerializationMatchStep> matchSteps = new ArrayList<SerializationMatchStep>();
    private final @NonNull Map<@NonNull SerializationNode, @NonNull CardinalityVariable> node2variable = new HashMap<SerializationNode, CardinalityVariable>();
    private final @NonNull Map<@NonNull CardinalityVariable, @NonNull SerializationNode> variable2node = new HashMap<CardinalityVariable, SerializationNode>();
    private final @NonNull List<@NonNull AssignedSerializationNode> assignedSerializationNodes = new ArrayList<AssignedSerializationNode>();
    private @Nullable SerializationRule serializationRule = null;
    private @Nullable Map<@NonNull SerializationNode, @Nullable SerializationNode> node2parent = new HashMap<SerializationNode, SerializationNode>();

    public SerializationRuleAnalysis(@NonNull ParserRuleAnalysis ruleAnalysis, int variantNumber, @NonNull SerializationNode rootSerializationNode) {
        this.ruleAnalysis = ruleAnalysis;
        this.grammarAnalysis = ruleAnalysis.getGrammarAnalysis();
        this.rootSerializationNode = rootSerializationNode;
        this.producedEClass = this.refineProducedEClass(rootSerializationNode, ruleAnalysis.getReturnedEClass());
        this.variantNumber = variantNumber;
        this.variantName = String.valueOf(ruleAnalysis.getName()) + "-" + variantNumber;
        assert (rootSerializationNode.onlyRootUnassignedSerializationRuleCall(true));
    }

    public void addMatchTerm(@Nullable CardinalityVariable cardinalityVariable, @NonNull SerializationMatchTerm matchTerm) {
        SerializationMatchStep.MatchStep_Assert newStep;
        if (cardinalityVariable != null) {
            int cardinalityVariableIndex = cardinalityVariable.getIndex();
            boolean isAssigned = true;
            for (SerializationMatchStep matchStep : this.matchSteps) {
                if (!matchStep.isAssignTo(cardinalityVariableIndex)) continue;
                isAssigned = false;
                break;
            }
            if (isAssigned) {
                newStep = new SerializationMatchStep.MatchStep_Assign(cardinalityVariableIndex, matchTerm);
                this.variableIndex2solution.put(cardinalityVariableIndex, matchTerm);
            } else {
                newStep = new SerializationMatchStep.MatchStep_ValueCheck(cardinalityVariableIndex, matchTerm);
            }
        } else {
            newStep = new SerializationMatchStep.MatchStep_Assert(matchTerm);
        }
        this.matchSteps.add((SerializationMatchStep)newStep);
    }

    private void analyzeAssignment(@NonNull EAttribute eAttribute, @NonNull EnumerationValue enumerationValue, @NonNull GrammarCardinality netGrammarCardinality) {
        HashMap<EnumerationValue, GrammarCardinality> enumerationValue2grammarCardinality;
        Map<@NonNull EAttribute, @NonNull Map<@Nullable EnumerationValue, @NonNull GrammarCardinality>> eAttribute2enumerationValue2grammarCardinality2 = this.eAttribute2enumerationValue2grammarCardinality;
        if (eAttribute2enumerationValue2grammarCardinality2 == null) {
            this.eAttribute2enumerationValue2grammarCardinality = eAttribute2enumerationValue2grammarCardinality2 = new HashMap<EAttribute, Map<EnumerationValue, GrammarCardinality>>();
        }
        if ((enumerationValue2grammarCardinality = (HashMap<EnumerationValue, GrammarCardinality>)SerializationUtils.maybeNull(eAttribute2enumerationValue2grammarCardinality2.get(eAttribute))) == null) {
            enumerationValue2grammarCardinality = new HashMap<EnumerationValue, GrammarCardinality>();
            eAttribute2enumerationValue2grammarCardinality2.put(eAttribute, enumerationValue2grammarCardinality);
        }
        GrammarCardinality oldGrammarCardinality = (GrammarCardinality)SerializationUtils.maybeNull((Object)((GrammarCardinality)enumerationValue2grammarCardinality.get(enumerationValue)));
        GrammarCardinality newGrammarCardinality = this.refineGrammarCardinality(netGrammarCardinality, oldGrammarCardinality);
        enumerationValue2grammarCardinality.put(enumerationValue, newGrammarCardinality);
    }

    private void analyzeAssignment(@NonNull EReference eReference, @NonNull GrammarRuleVector grammarRuleVector, @NonNull GrammarCardinality netGrammarCardinality) {
        HashMap<ParserRuleAnalysis, GrammarCardinality> ruleAnalysis2grammarCardinality;
        Map<@NonNull EReference, @NonNull Map<@NonNull ParserRuleAnalysis, @NonNull GrammarCardinality>> eReference2ruleAnalysis2grammarCardinality2 = this.eReference2ruleAnalysis2grammarCardinality;
        if (eReference2ruleAnalysis2grammarCardinality2 == null) {
            this.eReference2ruleAnalysis2grammarCardinality = eReference2ruleAnalysis2grammarCardinality2 = new HashMap<EReference, Map<ParserRuleAnalysis, GrammarCardinality>>();
        }
        if ((ruleAnalysis2grammarCardinality = (HashMap<ParserRuleAnalysis, GrammarCardinality>)SerializationUtils.maybeNull(eReference2ruleAnalysis2grammarCardinality2.get(eReference))) == null) {
            ruleAnalysis2grammarCardinality = new HashMap<ParserRuleAnalysis, GrammarCardinality>();
            eReference2ruleAnalysis2grammarCardinality2.put(eReference, ruleAnalysis2grammarCardinality);
        }
        Iterator iterator = grammarRuleVector.iterator();
        while (iterator.hasNext()) {
            int ruleIndex = (Integer)iterator.next();
            @NonNull AbstractRuleAnalysis ruleAnalysis2 = this.grammarAnalysis.getRuleAnalysis(ruleIndex);
            if (!(ruleAnalysis2 instanceof ParserRuleAnalysis)) continue;
            GrammarCardinality oldGrammarCardinality = (GrammarCardinality)SerializationUtils.maybeNull((Object)((GrammarCardinality)ruleAnalysis2grammarCardinality.get(ruleAnalysis2)));
            GrammarCardinality newGrammarCardinality = this.refineGrammarCardinality(netGrammarCardinality, oldGrammarCardinality);
            ruleAnalysis2grammarCardinality.put((ParserRuleAnalysis)ruleAnalysis2, newGrammarCardinality);
        }
    }

    private void analyzeAssignment(@NonNull AssignedSerializationNode assignedSerializationNode, @NonNull Iterable<@NonNull CardinalityVariable> cardinalityVariables, @NonNull GrammarCardinality netGrammarCardinality) {
        EStructuralFeature eStructuralFeature = assignedSerializationNode.getEStructuralFeature();
        CardinalityExpression cardinalityExpression = (CardinalityExpression)SerializationUtils.maybeNull((Object)this.eStructuralFeature2requiredSlotsExpression.get(eStructuralFeature));
        if (eStructuralFeature instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            EnumerationValue enumerationValue = assignedSerializationNode.getEnumerationValue();
            this.analyzeAssignment(eAttribute, enumerationValue, netGrammarCardinality);
            if (cardinalityExpression == null) {
                String name = String.format("E%02d", this.eStructuralFeature2requiredSlotsExpression.size());
                assert (name != null);
                cardinalityExpression = enumerationValue.isNull() ? new CardinalityExpression.EStructuralFeatureCardinalityExpression(name, (EStructuralFeature)eAttribute) : new CardinalityExpression.EAttributeCardinalityExpression(name, eAttribute);
                this.eStructuralFeature2requiredSlotsExpression.put((EStructuralFeature)eAttribute, cardinalityExpression);
            }
            if (!enumerationValue.isNull()) {
                cardinalityExpression = cardinalityExpression.getCardinalityExpression(this.grammarAnalysis, enumerationValue);
            }
        } else {
            EReference eReference = (EReference)eStructuralFeature;
            GrammarRuleVector grammarRuleVector = assignedSerializationNode.getAssignedGrammarRuleVector();
            this.analyzeAssignment(eReference, grammarRuleVector, netGrammarCardinality);
            cardinalityExpression = (CardinalityExpression)SerializationUtils.maybeNull((Object)this.eStructuralFeature2requiredSlotsExpression.get(eReference));
            if (cardinalityExpression == null) {
                String name = String.format("E%02d", this.eStructuralFeature2requiredSlotsExpression.size());
                assert (name != null);
                cardinalityExpression = new CardinalityExpression.EStructuralFeatureCardinalityExpression(name, (EStructuralFeature)eReference);
                this.eStructuralFeature2requiredSlotsExpression.put((EStructuralFeature)eReference, cardinalityExpression);
            }
        }
        cardinalityExpression.addMultiplicityProduct(cardinalityVariables, assignedSerializationNode.getAssignedGrammarRuleVector());
    }

    public void analyzeMatches() {
        if (!this.hasMatchAnalyses) {
            this.hasMatchAnalyses = true;
            this.analyzeSerialization();
            if (!this.isOrderedAndHeterogeneous()) {
                this.generateMatchSteps();
            }
        }
    }

    protected void analyzeSerialization() {
        this.analyzeSerialization(this.rootSerializationNode, new Stack<CardinalityVariable>(), GrammarCardinality.ONE);
    }

    protected void analyzeSerialization(@NonNull SerializationNode serializationNode, @NonNull Stack<@NonNull CardinalityVariable> cardinalityVariables, @NonNull GrammarCardinality outerGrammarCardinality) {
        GrammarCardinality grammarCardinality;
        CardinalityVariable cardinalityVariable = null;
        if (!serializationNode.isRedundant() && !(grammarCardinality = serializationNode.getGrammarCardinality()).isOne()) {
            int index = this.variable2node.size();
            cardinalityVariable = new CardinalityVariable(index, grammarCardinality);
            CardinalityVariable old2 = (CardinalityVariable)SerializationUtils.maybeNull((Object)this.node2variable.put(serializationNode, cardinalityVariable));
            assert (old2 == null);
            SerializationNode old3 = (SerializationNode)SerializationUtils.maybeNull((Object)this.variable2node.put(cardinalityVariable, serializationNode));
            assert (old3 == null);
        }
        GrammarCardinality innerGrammarCardinality = serializationNode.getGrammarCardinality();
        GrammarCardinality netGrammarCardinality = GrammarCardinality.max((GrammarCardinality)innerGrammarCardinality, (GrammarCardinality)outerGrammarCardinality);
        if (cardinalityVariable != null) {
            cardinalityVariables.push(cardinalityVariable);
        }
        if (serializationNode instanceof AssignedSerializationNode) {
            AssignedSerializationNode assignedSerializationNode = (AssignedSerializationNode)serializationNode;
            this.assignedSerializationNodes.add(assignedSerializationNode);
            this.analyzeAssignment(assignedSerializationNode, cardinalityVariables, netGrammarCardinality);
        } else if (serializationNode instanceof SequenceSerializationNode) {
            SequenceSerializationNode sequenceSerializationNode = (SequenceSerializationNode)serializationNode;
            for (SerializationNode nestedSerializationNode : sequenceSerializationNode.getSerializationNodes()) {
                this.analyzeSerialization(nestedSerializationNode, cardinalityVariables, netGrammarCardinality);
            }
        }
        if (cardinalityVariable != null) {
            cardinalityVariables.pop();
        }
    }

    public @Nullable Integer basicGetIntegerSolution(int cardinalityVariableIndex) {
        SerializationMatchTerm solution = (SerializationMatchTerm)SerializationUtils.maybeNull((Object)this.variableIndex2solution.get(cardinalityVariableIndex));
        return solution != null ? solution.basicGetIntegerSolution((RuleMatch)this) : null;
    }

    public @Nullable SerializationMatchTerm basicGetMatchTerm(@NonNull CardinalityVariable cardinalityVariable) {
        return this.variableIndex2solution.get(cardinalityVariable.getIndex());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SerializationRule.SerializationAttribute @Nullable [] basicGetSerializationAttributes() {
        Map<@NonNull EAttribute, @NonNull Map<@Nullable EnumerationValue, @NonNull GrammarCardinality>> eAttribute2enumerationValue2grammarCardinality2 = this.eAttribute2enumerationValue2grammarCardinality;
        if (eAttribute2enumerationValue2grammarCardinality2 == null) {
            return null;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull SerializationRule.SerializationAttribute[] serializationAttributes = new SerializationRule.SerializationAttribute[eAttribute2enumerationValue2grammarCardinality2.size()];
        int i1 = 0;
        for (Map.Entry<EAttribute, Map<EnumerationValue, GrammarCardinality>> entry1 : eAttribute2enumerationValue2grammarCardinality2.entrySet()) {
            EnumerationValue firstEnumerationValue;
            EAttribute eAttribute = (EAttribute)SerializationUtils.maybeNull((Object)entry1.getKey());
            assert (eAttribute != null);
            @NonNull Map<@Nullable EnumerationValue, @NonNull GrammarCardinality> enumerationValue2grammarCardinality = entry1.getValue();
            CardinalityExpression cardinalityExpression = (CardinalityExpression)SerializationUtils.maybeNull((Object)this.eStructuralFeature2requiredSlotsExpression.get(eAttribute));
            boolean needsDefault = ((CardinalityExpression)SerializationUtils.nonNullState((Object)cardinalityExpression)).isOne();
            ArrayList<@Nullable EnumerationValue> enumerationValueList = new ArrayList<EnumerationValue>(enumerationValue2grammarCardinality.keySet());
            if (enumerationValueList.size() == 1 && (firstEnumerationValue = (EnumerationValue)enumerationValueList.get(0)) != null && firstEnumerationValue.isNull()) {
                GrammarCardinality grammarCardinality = enumerationValue2grammarCardinality.get(firstEnumerationValue);
                assert (grammarCardinality != null);
                serializationAttributes[i1++] = new SerializationRule.SerializationSimpleAttribute(eAttribute, needsDefault, grammarCardinality);
                continue;
            }
            @NonNull List enumerationValueList2 = enumerationValueList;
            Collections.sort(enumerationValueList2, SerializationUtils.NAMEABLE_COMPARATOR);
            int iMax = enumerationValueList2.size();
            @NonNull EnumerationValue[] enumerationValues = new EnumerationValue[iMax];
            @NonNull GrammarCardinality[] grammarCardinalities = new GrammarCardinality[iMax];
            int i = 0;
            while (i < iMax) {
                EnumerationValue enumerationValue = (EnumerationValue)SerializationUtils.maybeNull((Object)((EnumerationValue)enumerationValueList2.get(i)));
                assert (enumerationValue != null);
                enumerationValues[i] = enumerationValue;
                GrammarCardinality grammarCardinaity = (GrammarCardinality)SerializationUtils.maybeNull((Object)enumerationValue2grammarCardinality.get(enumerationValue));
                assert (grammarCardinaity != null);
                grammarCardinalities[i] = grammarCardinaity;
                ++i;
            }
            serializationAttributes[i1++] = new SerializationRule.SerializationEnumeratedAttribute(eAttribute, needsDefault, enumerationValues, grammarCardinalities);
        }
        Arrays.sort(serializationAttributes, SerializationUtils.NAMEABLE_COMPARATOR);
        return serializationAttributes;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SerializationRule.SerializationFeature @Nullable [] basicGetSerializationFeatures() {
        SerializationRule.SerializationReference[] serializationReferences;
        int referencesSize;
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull SerializationRule.SerializationAttribute @Nullable [] serializationAttributes = this.basicGetSerializationAttributes();
        int attributesSize = serializationAttributes != null ? serializationAttributes.length : 0;
        int featuresSize = attributesSize + (referencesSize = (serializationReferences = this.basicGetSerializationReferences()) != null ? serializationReferences.length : 0);
        if (featuresSize <= 0) {
            return null;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull SerializationRule.SerializationFeature[] serializationFeatures = new SerializationRule.SerializationFeature[featuresSize];
        int j = 0;
        int i = 0;
        while (i < attributesSize) {
            assert (serializationAttributes != null);
            serializationFeatures[j++] = serializationAttributes[i];
            ++i;
        }
        i = 0;
        while (i < referencesSize) {
            assert (serializationReferences != null);
            serializationFeatures[j++] = serializationReferences[i];
            ++i;
        }
        return serializationFeatures;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SerializationRule.SerializationReference @Nullable [] basicGetSerializationReferences() {
        Map<@NonNull EReference, @NonNull Map<@NonNull ParserRuleAnalysis, @NonNull GrammarCardinality>> eReference2ruleAnalysis2grammarCardinality2 = this.eReference2ruleAnalysis2grammarCardinality;
        if (eReference2ruleAnalysis2grammarCardinality2 == null) {
            return null;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull SerializationRule.SerializationReference[] eReference2ruleValueIndex2grammarCardinality = new SerializationRule.SerializationReference[eReference2ruleAnalysis2grammarCardinality2.size()];
        int i1 = 0;
        for (Map.Entry<EReference, Map<ParserRuleAnalysis, GrammarCardinality>> entry1 : eReference2ruleAnalysis2grammarCardinality2.entrySet()) {
            @NonNull EReference eReference = entry1.getKey();
            @NonNull Map<@NonNull ParserRuleAnalysis, @NonNull GrammarCardinality> ruleAnalysis2grammarCardinality = entry1.getValue();
            int iMax = ruleAnalysis2grammarCardinality.size();
            int @NonNull [] grammarRuleIndexes = new int[iMax];
            @NonNull GrammarCardinality @NonNull [] grammarCardinalities = new GrammarCardinality[iMax];
            int i2 = 0;
            ArrayList<@NonNull ParserRuleAnalysis> ruleAnalyses = new ArrayList<ParserRuleAnalysis>(ruleAnalysis2grammarCardinality.keySet());
            Collections.sort(ruleAnalyses, SerializationUtils.NAMEABLE_COMPARATOR);
            for (ParserRuleAnalysis ruleAnalysis : ruleAnalyses) {
                grammarRuleIndexes[i2] = ruleAnalysis.getIndex();
                GrammarCardinality grammarCardinality = (GrammarCardinality)SerializationUtils.maybeNull((Object)ruleAnalysis2grammarCardinality.get(ruleAnalysis));
                assert (grammarCardinality != null);
                grammarCardinalities[i2] = grammarCardinality;
                ++i2;
            }
            GrammarRuleVector targetGrammarRuleVector = (GrammarRuleVector)SerializationUtils.maybeNull((Object)this.getEReference2AssignedRuleValueIndexes().get(eReference));
            eReference2ruleValueIndex2grammarCardinality[i1++] = new SerializationRule.SerializationReference(eReference, targetGrammarRuleVector, grammarRuleIndexes, grammarCardinalities);
        }
        Arrays.sort(eReference2ruleValueIndex2grammarCardinality, SerializationUtils.NAMEABLE_COMPARATOR);
        return eReference2ruleValueIndex2grammarCardinality;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Iterable<@NonNull CardinalityExpression> computeExpressions(@NonNull Set<@NonNull CardinalityVariable> variableGroup, @NonNull Map<@NonNull CardinalityVariable, @NonNull Set<@NonNull CardinalityExpression>> variable2expressions) {
        HashSet<@NonNull CardinalityExpression> unresolvedExpressions = new HashSet<CardinalityExpression>();
        for (CardinalityVariable variable : variableGroup) {
            @NonNull Set expressions = (Set)SerializationUtils.maybeNull(variable2expressions.get(variable));
            assert (expressions != null);
            unresolvedExpressions.addAll(expressions);
        }
        return unresolvedExpressions;
    }

    protected @NonNull Map<@NonNull CardinalityExpression, @NonNull Set<@NonNull CardinalityVariable>> computeExpression2unsolvedVariables(@NonNull Iterable<@NonNull CardinalityExpression> expressions) {
        HashMap<@NonNull CardinalityExpression, @NonNull Set<@NonNull CardinalityVariable>> expression2unsolvedVariables = new HashMap<CardinalityExpression, Set<CardinalityVariable>>();
        for (CardinalityExpression expression : expressions) {
            List<@NonNull CardinalityVariable> unsolvedVariables = expression.getUnknownVariables(this);
            if (unsolvedVariables == null) continue;
            for (CardinalityVariable variable : unsolvedVariables) {
                HashSet<@NonNull CardinalityVariable> variables = (HashSet<CardinalityVariable>)SerializationUtils.maybeNull((Object)((Set)expression2unsolvedVariables.get(expression)));
                if (variables == null) {
                    variables = new HashSet<CardinalityVariable>();
                    expression2unsolvedVariables.put(expression, variables);
                }
                variables.add(variable);
            }
        }
        return expression2unsolvedVariables;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Map<@NonNull CardinalityVariable, @NonNull Set<@NonNull CardinalityVariable>> computeUnsolvedVariableGroups(@NonNull Map<@NonNull CardinalityVariable, @NonNull Set<@NonNull CardinalityExpression>> unsolvedVariable2expressions, @NonNull Map<@NonNull CardinalityExpression, @NonNull Set<@NonNull CardinalityVariable>> expression2unsolvedVariables) {
        HashMap<@NonNull CardinalityVariable, @NonNull Set<@NonNull CardinalityVariable>> unsolvedVariable2unresolvedVariables = new HashMap<CardinalityVariable, Set<CardinalityVariable>>();
        ArrayList<@NonNull CardinalityVariable> workVariables = new ArrayList<CardinalityVariable>(unsolvedVariable2expressions.keySet());
        for (CardinalityVariable workVariable : workVariables) {
            HashSet<@NonNull CardinalityVariable> unsolvedVariables = (HashSet<CardinalityVariable>)SerializationUtils.maybeNull((Object)((Set)unsolvedVariable2unresolvedVariables.get(workVariable)));
            if (unsolvedVariables != null) continue;
            unsolvedVariables = new HashSet<CardinalityVariable>();
            unsolvedVariable2unresolvedVariables.put(workVariable, unsolvedVariables);
            unsolvedVariables.add(workVariable);
            @NonNull Set expressions = (Set)SerializationUtils.maybeNull(unsolvedVariable2expressions.get(workVariable));
            assert (expressions != null);
            for (CardinalityExpression expression : expressions) {
                @NonNull Set moreUnsolvedVariables1 = (Set)SerializationUtils.maybeNull(expression2unsolvedVariables.get(expression));
                assert (moreUnsolvedVariables1 != null);
                HashSet<@NonNull E> moreUnsolvedVariables2 = new HashSet(moreUnsolvedVariables1);
                moreUnsolvedVariables2.removeAll(unsolvedVariables);
                for (CardinalityVariable anotherUnsolvedVariable : moreUnsolvedVariables2) {
                    unsolvedVariables.add(anotherUnsolvedVariable);
                    unsolvedVariable2unresolvedVariables.put(anotherUnsolvedVariable, unsolvedVariables);
                }
            }
        }
        return unsolvedVariable2unresolvedVariables;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Map<@NonNull CardinalityVariable, @NonNull Set<@NonNull CardinalityExpression>> computeVariable2expressions(@NonNull Map<@NonNull CardinalityExpression, @NonNull Set<@NonNull CardinalityVariable>> expression2variables) {
        HashMap<@NonNull CardinalityVariable, @NonNull Set<@NonNull CardinalityExpression>> variable2expressions = new HashMap<CardinalityVariable, Set<CardinalityExpression>>();
        for (CardinalityExpression expression : expression2variables.keySet()) {
            @NonNull Set variables = (Set)SerializationUtils.maybeNull(expression2variables.get(expression));
            assert (variables != null);
            for (CardinalityVariable variable : variables) {
                HashSet<@NonNull CardinalityExpression> expressions = (HashSet<CardinalityExpression>)SerializationUtils.maybeNull((Object)((Set)variable2expressions.get(variable)));
                if (expressions == null) {
                    expressions = new HashSet<CardinalityExpression>();
                    variable2expressions.put(variable, expressions);
                }
                expressions.add(expression);
            }
        }
        return variable2expressions;
    }

    private @Nullable List<@NonNull AssignedSerializationNode> gatherAssignedSerializationNodes(@NonNull EReference eReference, @NonNull SerializationNode serializationNode, @Nullable List<@NonNull AssignedSerializationNode> assignedSerializationNodes) {
        if (serializationNode instanceof AssignedSerializationNode) {
            AssignedSerializationNode assignedSerializationNode = (AssignedSerializationNode)serializationNode;
            if (assignedSerializationNode.getEStructuralFeature() == eReference) {
                if (assignedSerializationNodes == null) {
                    assignedSerializationNodes = new ArrayList<AssignedSerializationNode>();
                }
                assignedSerializationNodes.add(assignedSerializationNode);
            }
        } else if (serializationNode instanceof SequenceSerializationNode) {
            for (SerializationNode nestedSerializationNode : ((SequenceSerializationNode)serializationNode).getSerializationNodes()) {
                assignedSerializationNodes = this.gatherAssignedSerializationNodes(eReference, nestedSerializationNode, assignedSerializationNodes);
            }
        }
        return assignedSerializationNodes;
    }

    protected void generateContainmentChecks(@NonNull List<@NonNull SerializationMatchStep> steps) {
        Map<@NonNull EReference, @NonNull Map<@NonNull ParserRuleAnalysis, @NonNull GrammarCardinality>> eReference2ruleAnalysis2grammarCardinality2 = this.eReference2ruleAnalysis2grammarCardinality;
        if (eReference2ruleAnalysis2grammarCardinality2 != null) {
            ArrayList<@NonNull EReference> eContainments = null;
            for (EReference eReference : eReference2ruleAnalysis2grammarCardinality2.keySet()) {
                if (!eReference.isContainment()) continue;
                if (eContainments == null) {
                    eContainments = new ArrayList<EReference>();
                }
                eContainments.add(eReference);
            }
            if (eContainments != null) {
                Collections.sort(eContainments, SerializationUtils.ENAMED_ELEMENT_COMPARATOR);
                for (EReference eReference : eContainments) {
                    Map<@NonNull ParserRuleAnalysis, @NonNull GrammarCardinality> value = eReference2ruleAnalysis2grammarCardinality2.get(eReference);
                    assert (value != null);
                    GrammarRuleVector grammarRuleVector = new GrammarRuleVector();
                    for (ParserRuleAnalysis assignedRuleAnalysis : value.keySet()) {
                        for (ParserRuleAnalysis subRuleAnalysis : assignedRuleAnalysis.getSubRuleAnalysesClosure()) {
                            grammarRuleVector.set(subRuleAnalysis.getIndex());
                        }
                    }
                    steps.add((SerializationMatchStep)new SerializationMatchStep.MatchStep_RuleCheck(eReference, grammarRuleVector));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected void generateMatchSteps() {
        block25: {
            this.generateContainmentChecks(this.matchSteps);
            residualExpressions = this.getExpressionsToSolve();
            variables = Lists.newArrayList(this.getVariables());
            Collections.sort(variables, SerializationUtils.INDEXED_COMPARATOR);
            for (CardinalityVariable variable : variables) {
                if (!SerializationRuleAnalysis.$assertionsDisabled && variable.isOne()) {
                    throw new AssertionError();
                }
            }
            do {
                i2 = oldSize = residualExpressions.size();
                while (--i2 >= 0) {
                    residualExpression2 = (CardinalityExpression)SerializationUtils.nonNullState((Object)residualExpressions.get(i2));
                    if (!residualExpression2.generateLinear(this, false)) continue;
                    residualExpressions.remove(i2);
                }
            } while (residualExpressions.size() < oldSize);
            do {
                oldSize = residualExpressions.size();
                gotOne = false;
                i = oldSize;
                while (--i >= 0) {
                    residualExpression = (CardinalityExpression)SerializationUtils.nonNullState((Object)residualExpressions.get(i));
                    if (!residualExpression.generateMayBeZeroCommonFactors(this, false)) continue;
                    gotOne = true;
                    break;
                }
                if (!gotOne) continue;
                i = oldSize;
                while (--i >= 0) {
                    residualExpression = (CardinalityExpression)SerializationUtils.nonNullState((Object)residualExpressions.get(i));
                    if (!residualExpression.generateLinear(this, false)) continue;
                    residualExpressions.remove(i);
                }
            } while (gotOne || residualExpressions.size() < oldSize);
            do {
                oldSize = residualExpressions.size();
                gotOne = false;
                i = oldSize;
                while (--i >= 0) {
                    residualExpression = (CardinalityExpression)SerializationUtils.nonNullState((Object)residualExpressions.get(i));
                    if (!residualExpression.generateMayBeZeroCommonFactors(this, true)) continue;
                    gotOne = true;
                    break;
                }
                if (!gotOne) continue;
                i = oldSize;
                while (--i >= 0) {
                    residualExpression = (CardinalityExpression)SerializationUtils.nonNullState((Object)residualExpressions.get(i));
                    if (!residualExpression.generateLinear(this, true)) continue;
                    residualExpressions.remove(i);
                }
            } while (gotOne || residualExpressions.size() < oldSize);
            if (residualExpressions.size() <= 0) break block25;
            expression2unsolvedVariables = this.computeExpression2unsolvedVariables(residualExpressions);
            unsolvedVariable2expressions = this.computeVariable2expressions(expression2unsolvedVariables);
            unsolvedVariable2unsolvedVariableGroups = this.computeUnsolvedVariableGroups(unsolvedVariable2expressions, expression2unsolvedVariables);
            unsolvedVariableGroups = new ArrayList<V>(new HashSet<V>(unsolvedVariable2unsolvedVariableGroups.values()));
            for (Set unsolvedVariableGroup : unsolvedVariableGroups) {
                block26: {
                    unresolvedExpressions = this.computeExpressions(unsolvedVariableGroup, unsolvedVariable2expressions);
                    size = Iterables.size(unresolvedExpressions);
                    if (size != 1) break block26;
                    residualExpression3 = (CardinalityExpression)SerializationUtils.nonNullState((Object)unresolvedExpressions.iterator().next());
                    if (residualExpression3.generateRedundantProducts(this)) continue;
                    runtimeMatchTerm = new SerializationMatchTermRuntime(unsolvedVariableGroup, unresolvedExpressions);
                    unsolvedVariables = new ArrayList<E>(unsolvedVariableGroup);
                    Collections.sort(unsolvedVariables, SerializationUtils.INDEXED_COMPARATOR);
                    var17_24 = unsolvedVariableGroup.iterator();
                    if (true) ** GOTO lbl77
                }
                runtimeMatchTerm = new SerializationMatchTermRuntime(unsolvedVariableGroup, unresolvedExpressions);
                var15_22 = unsolvedVariableGroup.iterator();
                if (true) ** GOTO lbl82
                do {
                    unresolvedVariable = (CardinalityVariable)var17_24.next();
                    this.addMatchTerm(unresolvedVariable, runtimeMatchTerm);
lbl77:
                    // 2 sources

                } while (var17_24.hasNext());
                continue;
                do {
                    unresolvedVariable = (CardinalityVariable)var15_22.next();
                    this.addMatchTerm(unresolvedVariable, runtimeMatchTerm);
lbl82:
                    // 2 sources

                } while (var15_22.hasNext());
            }
        }
        for (CardinalityVariable variable : variables) {
            if (!SerializationRuleAnalysis.$assertionsDisabled && variable.isOne()) {
                throw new AssertionError();
            }
            if (this.basicGetMatchTerm(variable) != null) continue;
            if (residualExpressions.isEmpty()) {
                this.addMatchTerm(variable, (SerializationMatchTerm)new SerializationMatchTerm.SerializationMatchTermInteger(variable.mayBeNone() != false ? 0 : 1));
                continue;
            }
            this.addMatchTerm(variable, (SerializationMatchTerm)new SerializationMatchTerm.SerializationMatchTermUnsupported());
        }
        eStructuralFeaturesSet = new HashSet<EStructuralFeature>();
        for (EStructuralFeature eFeature : this.producedEClass.getEAllStructuralFeatures()) {
            if (!SerializationRuleAnalysis.$assertionsDisabled && eFeature == null) {
                throw new AssertionError();
            }
            if (eFeature.isDerived() || eFeature.isTransient() || eFeature.isVolatile()) continue;
            if (eFeature instanceof EReference) {
                if (((EReference)eFeature).isContainer()) continue;
                eStructuralFeaturesSet.add(eFeature);
                continue;
            }
            eStructuralFeaturesSet.add(eFeature);
        }
        for (SerializationMatchStep matchStep : this.matchSteps) {
            for (SerializationMatchTerm matchTerm : matchStep.getMatchTermClosure()) {
                if (matchTerm instanceof SerializationMatchTerm.SerializationMatchTermEAttributeSize) {
                    eStructuralFeaturesSet.remove(((SerializationMatchTerm.SerializationMatchTermEAttributeSize)matchTerm).getEAttribute());
                    continue;
                }
                if (matchTerm instanceof SerializationMatchTerm.SerializationMatchTermEReferenceSize) {
                    eStructuralFeaturesSet.remove(((SerializationMatchTerm.SerializationMatchTermEReferenceSize)matchTerm).getEReference());
                    continue;
                }
                if (!(matchTerm instanceof SerializationMatchTerm.SerializationMatchTermEStructuralFeatureSize)) continue;
                eStructuralFeaturesSet.remove(((SerializationMatchTerm.SerializationMatchTermEStructuralFeatureSize)matchTerm).getEStructuralFeature());
            }
        }
        if (!eStructuralFeaturesSet.isEmpty()) {
            insertIndex = 0;
            eStructuralFeatures = new ArrayList<E>(eStructuralFeaturesSet);
            Collections.sort(eStructuralFeatures, SerializationUtils.ENAMED_ELEMENT_COMPARATOR);
            for (EStructuralFeature eStructuralFeature : eStructuralFeatures) {
                matchTerm = new SerializationMatchTerm.SerializationMatchTermEStructuralFeatureSize(eStructuralFeature);
                matchStep = new SerializationMatchStep.MatchStep_Assert((SerializationMatchTerm)matchTerm);
                this.matchSteps.add(insertIndex++, (SerializationMatchStep)matchStep);
            }
        }
    }

    protected List<@NonNull CardinalityExpression> getExpressionsToSolve() {
        ArrayList<@NonNull CardinalityExpression> residualExpressions = new ArrayList<CardinalityExpression>();
        for (CardinalityExpression expression : this.eStructuralFeature2requiredSlotsExpression.values()) {
            Iterable<@NonNull CardinalityExpression> cardinalityExpressions = expression.getCardinalityExpressions();
            if (cardinalityExpressions != null) {
                for (CardinalityExpression cardinalityExpression : cardinalityExpressions) {
                    residualExpressions.add(cardinalityExpression);
                }
                continue;
            }
            residualExpressions.add(expression);
        }
        Collections.sort(residualExpressions, SerializationUtils.NAMEABLE_COMPARATOR);
        return residualExpressions;
    }

    public @Nullable Iterable<@NonNull AssignedSerializationNode> getAssignedSerializationNodes(@NonNull EReference eReference) {
        return this.gatherAssignedSerializationNodes(eReference, this.rootSerializationNode, null);
    }

    public int getCardinalityVariableIndex(@NonNull SerializationNode serializationNode) {
        CardinalityVariable cardinalityVariable = (CardinalityVariable)SerializationUtils.maybeNull((Object)this.node2variable.get(serializationNode));
        return cardinalityVariable != null ? cardinalityVariable.getIndex() : -1;
    }

    public @NonNull Map<@NonNull EAttribute, @NonNull Set<@NonNull EnumerationValue>> getEAttribute2EnumerationValues() {
        Map<@NonNull EAttribute, @NonNull Set<@NonNull EnumerationValue>> eAttribute2enumerationValues2 = this.eAttribute2enumerationValues;
        if (eAttribute2enumerationValues2 == null) {
            this.eAttribute2enumerationValues = eAttribute2enumerationValues2 = new HashMap<EAttribute, Set<EnumerationValue>>();
            this.getEAttribute2EnumerationValues(this.rootSerializationNode, eAttribute2enumerationValues2);
        }
        if (eAttribute2enumerationValues2.size() > 0) {
            for (Map.Entry<EAttribute, Set<EnumerationValue>> entry : eAttribute2enumerationValues2.entrySet()) {
                @NonNull Set<@NonNull EnumerationValue> assignedRuleIndexes = entry.getValue();
                eAttribute2enumerationValues2.put(entry.getKey(), assignedRuleIndexes);
            }
        }
        return eAttribute2enumerationValues2;
    }

    private void getEAttribute2EnumerationValues(@NonNull SerializationNode serializationNode, @NonNull Map<@NonNull EAttribute, @NonNull Set<@NonNull EnumerationValue>> eAttribute2enumerationValues) {
        if (serializationNode instanceof AlternativeAssignedKeywordsSerializationNode) {
            AlternativeAssignedKeywordsSerializationNode assignedKeywordsSerializationNode = (AlternativeAssignedKeywordsSerializationNode)serializationNode;
            EAttribute eAttribute = (EAttribute)assignedKeywordsSerializationNode.getEStructuralFeature();
            HashSet<@NonNull EnumerationValue> enumerationValues = (HashSet<EnumerationValue>)SerializationUtils.maybeNull(eAttribute2enumerationValues.get(eAttribute));
            if (enumerationValues == null) {
                enumerationValues = new HashSet<EnumerationValue>();
                eAttribute2enumerationValues.put(eAttribute, enumerationValues);
            }
            EnumerationValue enumerationValue = assignedKeywordsSerializationNode.getEnumerationValue();
            enumerationValues.add(enumerationValue);
        } else if (serializationNode instanceof AlternativeAssignsSerializationNode) {
            AlternativeAssignsSerializationNode assignsSerializationNode = (AlternativeAssignsSerializationNode)serializationNode;
            EStructuralFeature eStructuralFeature = assignsSerializationNode.getEStructuralFeature();
            if (eStructuralFeature instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)eStructuralFeature;
                EnumerationValue enumerationValue = assignsSerializationNode.getEnumerationValue();
                HashSet<@NonNull EnumerationValue> enumerationValues = (HashSet<EnumerationValue>)SerializationUtils.maybeNull(eAttribute2enumerationValues.get(eAttribute));
                if (enumerationValues == null) {
                    enumerationValues = new HashSet<EnumerationValue>();
                    eAttribute2enumerationValues.put(eAttribute, enumerationValues);
                }
                enumerationValues.add(enumerationValue);
            }
        } else if (serializationNode instanceof AssignedKeywordSerializationNode) {
            AssignedKeywordSerializationNode assignedKeywordSerializationNode = (AssignedKeywordSerializationNode)serializationNode;
            EAttribute eAttribute = (EAttribute)assignedKeywordSerializationNode.getEStructuralFeature();
            HashSet<@NonNull EnumerationValue> enumerationValues = (HashSet<EnumerationValue>)SerializationUtils.maybeNull(eAttribute2enumerationValues.get(eAttribute));
            if (enumerationValues == null) {
                enumerationValues = new HashSet<EnumerationValue>();
                eAttribute2enumerationValues.put(eAttribute, enumerationValues);
            }
            EnumerationValue enumerationValue = assignedKeywordSerializationNode.getEnumerationValue();
            enumerationValues.add(enumerationValue);
        } else if (serializationNode instanceof SequenceSerializationNode) {
            for (SerializationNode nestedSerializationNode : ((SequenceSerializationNode)serializationNode).getSerializationNodes()) {
                this.getEAttribute2EnumerationValues(nestedSerializationNode, eAttribute2enumerationValues);
            }
        }
    }

    public @NonNull Map<@NonNull EReference, @NonNull GrammarRuleVector> getEReference2AssignedRuleValueIndexes() {
        Map<@NonNull EReference, @NonNull GrammarRuleVector> eReference2assignedRuleIndexes2 = this.eReference2assignedRuleIndexes;
        if (eReference2assignedRuleIndexes2 == null) {
            this.eReference2assignedRuleIndexes = eReference2assignedRuleIndexes2 = new HashMap<EReference, GrammarRuleVector>();
            this.getEReference2AssignedRuleIndexes(this.rootSerializationNode, eReference2assignedRuleIndexes2);
        }
        return eReference2assignedRuleIndexes2;
    }

    private void getEReference2AssignedRuleIndexes(@NonNull SerializationNode serializationNode, @NonNull Map<@NonNull EReference, @NonNull GrammarRuleVector> eReference2assignedRuleIndexes) {
        if (serializationNode instanceof AssignedRuleCallSerializationNode || serializationNode instanceof AlternativeAssignsSerializationNode) {
            AssignedSerializationNode assignedSerializationNode = (AssignedSerializationNode)serializationNode;
            EStructuralFeature eStructuralFeature = assignedSerializationNode.getEStructuralFeature();
            if (eStructuralFeature instanceof EReference) {
                EReference eReference = (EReference)eStructuralFeature;
                GrammarRuleVector netGrammarRuleVector = (GrammarRuleVector)SerializationUtils.maybeNull((Object)eReference2assignedRuleIndexes.get(eReference));
                if (netGrammarRuleVector == null) {
                    netGrammarRuleVector = new GrammarRuleVector();
                    eReference2assignedRuleIndexes.put(eReference, netGrammarRuleVector);
                }
                GrammarRuleVector grammarRuleVector = assignedSerializationNode.getAssignedGrammarRuleVector();
                netGrammarRuleVector.setAll(grammarRuleVector);
            }
        } else if (serializationNode instanceof SequenceSerializationNode) {
            for (SerializationNode nestedSerializationNode : ((SequenceSerializationNode)serializationNode).getSerializationNodes()) {
                this.getEReference2AssignedRuleIndexes(nestedSerializationNode, eReference2assignedRuleIndexes);
            }
        }
    }

    public @NonNull Map<@NonNull EStructuralFeature, @NonNull CardinalityExpression> getEStructuralFeature2requiredSlotsExpression() {
        return this.eStructuralFeature2requiredSlotsExpression;
    }

    public @Nullable Set<@NonNull EnumerationValue> getEnumerationValues(@NonNull EAttribute eAttribute) {
        return this.getEAttribute2EnumerationValues().get(eAttribute);
    }

    public @NonNull GrammarAnalysis getGrammarAnalysis() {
        return this.grammarAnalysis;
    }

    public @Nullable GrammarCardinality getGrammarCardinality(@NonNull EStructuralFeature eStructuralFeature) {
        Map enumerationValue2grammarCardinality;
        assert (this.hasMatchAnalyses);
        if (this.eAttribute2enumerationValue2grammarCardinality != null && (enumerationValue2grammarCardinality = (Map)SerializationUtils.maybeNull(this.eAttribute2enumerationValue2grammarCardinality.get(eStructuralFeature))) != null) {
            return (GrammarCardinality)enumerationValue2grammarCardinality.get(null);
        }
        return null;
    }

    public @Nullable GrammarCardinality getGrammarCardinality(@NonNull EAttribute eAttribute, @NonNull EnumerationValue enumerationValue) {
        Map enumerationValue2grammarCardinality;
        assert (this.hasMatchAnalyses);
        if (this.eAttribute2enumerationValue2grammarCardinality != null && (enumerationValue2grammarCardinality = (Map)SerializationUtils.maybeNull(this.eAttribute2enumerationValue2grammarCardinality.get(eAttribute))) != null) {
            return (GrammarCardinality)enumerationValue2grammarCardinality.get(enumerationValue);
        }
        return null;
    }

    public @Nullable GrammarCardinality getGrammarCardinality(@NonNull EReference eReference, @NonNull ParserRuleAnalysis ruleAnalysis) {
        Map ruleAnalysis2grammarCardinality;
        assert (this.hasMatchAnalyses);
        if (this.eReference2ruleAnalysis2grammarCardinality != null && (ruleAnalysis2grammarCardinality = (Map)SerializationUtils.maybeNull(this.eReference2ruleAnalysis2grammarCardinality.get(eReference))) != null) {
            return (GrammarCardinality)ruleAnalysis2grammarCardinality.get(ruleAnalysis);
        }
        return null;
    }

    public @Nullable GrammarCardinality getGrammarCardinality(@NonNull EReference eReference, @NonNull ParserRuleValue ruleValue) {
        Map ruleAnalysis2grammarCardinality;
        assert (this.hasMatchAnalyses);
        if (this.eReference2ruleAnalysis2grammarCardinality != null && (ruleAnalysis2grammarCardinality = (Map)SerializationUtils.maybeNull(this.eReference2ruleAnalysis2grammarCardinality.get(eReference))) != null) {
            for (ParserRuleAnalysis parserRuleAnalysis : ruleAnalysis2grammarCardinality.keySet()) {
                if (parserRuleAnalysis.getRuleValue() != ruleValue) continue;
                return (GrammarCardinality)ruleAnalysis2grammarCardinality.get(parserRuleAnalysis);
            }
        }
        return null;
    }

    public GrammarRuleValue getGrammarRuleValue(int ruleValueIndex) {
        return this.grammarAnalysis.getRuleAnalysis(ruleValueIndex).getRuleValue();
    }

    private void getIdiomMatches(@NonNull SerializationNode serializationNode, @NonNull Iterable<@NonNull Idiom> idioms, @Nullable IdiomSerializationMatch @NonNull [] idiomMatches) {
        int idiomIndex = 0;
        for (Idiom idiom : idioms) {
            IdiomSerializationMatch idiomMatch = idiomMatches[idiomIndex];
            if (idiomMatch == null) {
                SubIdiom firstSubIdiom = (SubIdiom)idiom.getOwnedSubIdioms().get(0);
                assert (firstSubIdiom != null);
                boolean firstSubIdiomMatches = this.matches(firstSubIdiom, serializationNode);
                idiomMatches[idiomIndex] = firstSubIdiomMatches ? this.grammarAnalysis.createIdiomMatch(idiom, serializationNode) : null;
            } else {
                idiomMatch.nextMatch(serializationNode, this);
            }
            ++idiomIndex;
        }
        if (serializationNode instanceof SequenceSerializationNode) {
            for (SerializationNode nestedSerializationNode : ((SequenceSerializationNode)serializationNode).getSerializationNodes()) {
                this.getIdiomMatches(nestedSerializationNode, idioms, idiomMatches);
            }
        }
    }

    public @NonNull String getName() {
        return this.ruleAnalysis.getName();
    }

    public @Nullable SerializationNode getParent(@NonNull SerializationNode serializationNode) {
        Map<@NonNull SerializationNode, @Nullable SerializationNode> node2parent2 = this.node2parent;
        if (node2parent2 == null) {
            node2parent2 = this.node2parent = new HashMap<SerializationNode, SerializationNode>();
            node2parent2.put(this.rootSerializationNode, null);
            this.getParentInternal(node2parent2, this.rootSerializationNode);
        }
        return node2parent2.get(serializationNode);
    }

    private void getParentInternal(@NonNull Map<@NonNull SerializationNode, @Nullable SerializationNode> node2parent2, @NonNull SerializationNode serializationNode) {
        if (serializationNode instanceof SequenceSerializationNode) {
            for (SerializationNode childNode : ((SequenceSerializationNode)serializationNode).getSerializationNodes()) {
                node2parent2.put(childNode, serializationNode);
                this.getParentInternal(node2parent2, childNode);
            }
        } else assert (!(serializationNode instanceof CompositeSerializationNode));
    }

    public @NonNull EClass getProducedEClass() {
        return this.producedEClass;
    }

    public @NonNull SerializationNode getRootSerializationNode() {
        return this.rootSerializationNode;
    }

    public @NonNull ParserRuleAnalysis getRuleAnalysis() {
        return this.ruleAnalysis;
    }

    public int getRuleValueIndex() {
        return this.ruleAnalysis.getIndex();
    }

    public @NonNull Iterable<@NonNull SerializationMatchStep> getSerializationMatchSteps() {
        assert (this.hasMatchAnalyses);
        return this.matchSteps;
    }

    public @NonNull Map<@NonNull SerializationNode, @NonNull List<@NonNull SubIdiom>> getSerializationNode2subIdioms() {
        Map<@NonNull SerializationNode, @NonNull List<@NonNull SubIdiom>> serializationNode2subIdioms2 = this.serializationNode2subIdioms;
        if (serializationNode2subIdioms2 == null) {
            assert (this.hasMatchAnalyses);
            EClass producedEClass = this.getProducedEClass();
            ArrayList<@NonNull Idiom> idioms = new ArrayList<Idiom>();
            for (Idiom idiom : this.grammarAnalysis.getIdioms()) {
                Matcher matcher;
                Pattern pattern;
                boolean isOk = true;
                EClass inEClass = idiom.getForEClass();
                if (inEClass != null && !AnalysisUtils.isSuperTypeOf(inEClass, producedEClass)) {
                    isOk = false;
                }
                if ((pattern = idiom.getRegexPattern()) != null && !(matcher = pattern.matcher(this.getName())).matches()) {
                    isOk = false;
                }
                if (!isOk) continue;
                idioms.add(idiom);
            }
            @Nullable IdiomSerializationMatch @NonNull [] idiomMatches = new IdiomSerializationMatch[Iterables.size(idioms)];
            this.getIdiomMatches(this.rootSerializationNode, idioms, idiomMatches);
            serializationNode2subIdioms2 = new HashMap<SerializationNode, List<SubIdiom>>();
            IdiomSerializationMatch[] idiomSerializationMatchArray = idiomMatches;
            int n = idiomMatches.length;
            int n2 = 0;
            while (n2 < n) {
                IdiomSerializationMatch idiomMatch = idiomSerializationMatchArray[n2];
                if (idiomMatch != null) {
                    idiomMatch.installIn(serializationNode2subIdioms2);
                }
                ++n2;
            }
            this.serializationNode2subIdioms = serializationNode2subIdioms2;
        }
        return serializationNode2subIdioms2;
    }

    public @NonNull SerializationRule getSerializationRule() {
        SerializationRule serializationRule2 = this.serializationRule;
        if (serializationRule2 == null) {
            this.analyzeMatches();
            serializationRule2 = this.serializationRule;
            if (serializationRule2 == null) {
                @NonNull SerializationMatchStep @NonNull [] matchStepsArray = (SerializationMatchStep[])SerializationUtils.nonNullState((Object)this.matchSteps.toArray(new SerializationMatchStep[this.matchSteps.size()]));
                ArrayList<@NonNull SerializationStep> stepsList = new ArrayList<SerializationStep>();
                Map<@NonNull SerializationNode, @NonNull List<@NonNull SubIdiom>> serializationNode2subIdioms = this.getSerializationNode2subIdioms();
                this.rootSerializationNode.gatherStepsAndSubIdioms(this, stepsList, serializationNode2subIdioms);
                int size = stepsList.size();
                @NonNull SerializationStep @NonNull [] serializationSteps = (SerializationStep[])SerializationUtils.nonNullState((Object)stepsList.toArray(new SerializationStep[size]));
                this.serializationRule = serializationRule2 = new SerializationRule((SerializationRuleHelper)this, this.getVariantName(), this.ruleAnalysis.getIndex(), matchStepsArray, serializationSteps, this.basicGetSerializationFeatures());
                SerializationRule old = (SerializationRule)SerializationUtils.maybeNull((Object)debugMap.put(this, serializationRule2));
                assert (old == null);
            }
        }
        return serializationRule2;
    }

    public @Nullable Integer getSize(@NonNull EStructuralFeature eStructuralFeature) {
        throw new UnsupportedOperationException();
    }

    public @Nullable Integer getSize(@NonNull EAttribute eAttribute, @NonNull EnumerationValue enumerationValue) {
        throw new UnsupportedOperationException();
    }

    public @Nullable Integer getSize(@NonNull EReference eReference, @NonNull GrammarRuleVector grammarRuleVector) {
        throw new UnsupportedOperationException();
    }

    public @Nullable List<@NonNull SubIdiom> getSubIdioms(@NonNull SerializationNode serializationNode) {
        return this.getSerializationNode2subIdioms().get(serializationNode);
    }

    public @NonNull Iterable<@NonNull CardinalityVariable> getVariables() {
        assert (this.hasMatchAnalyses);
        return (Iterable)SerializationUtils.nonNullState(this.variable2node.keySet());
    }

    protected boolean isOrderedAndHeterogeneous() {
        List<CardinalityExpression> cardinalityExpressions;
        if ("PropertyContextDeclCS".equals(this.getName())) {
            this.getClass();
        }
        if ((cardinalityExpressions = this.getExpressionsToSolve()).size() <= 0) {
            return false;
        }
        for (CardinalityExpression cardinalityExpression : cardinalityExpressions) {
            if (!cardinalityExpression.isOrderedAndHeterogeneous()) continue;
            return true;
        }
        return false;
    }

    public boolean matches(@NonNull SubIdiom subIdiom, @NonNull SerializationNode serializationNode) {
        Locator locator = subIdiom.getOwnedLocator();
        if (locator == null) {
            return false;
        }
        return this.matches(locator, serializationNode);
    }

    protected boolean matches(@NonNull Locator locator, @NonNull SerializationNode serializationNode) {
        LocatorImpl locatorImpl;
        LocatorHelper locatorHelper;
        if (locator instanceof ReferredLocator) {
            locator = IdiomsUtils.getOwnedLocator((LocatorDeclaration)IdiomsUtils.getLocatorDeclaration((ReferredLocator)((ReferredLocator)locator)));
        }
        if ((locatorHelper = (LocatorHelper)(locatorImpl = (LocatorImpl)locator).basicGetHelper()) == null) {
            LocatorHelper.LocatorSwitch subIdiomLocatorSwitch = this.grammarAnalysis.getLocatorSwitch();
            locatorHelper = (LocatorHelper)subIdiomLocatorSwitch.doSwitch((EObject)locator);
            locatorImpl.setHelper((Object)locatorHelper);
        }
        if (locatorHelper == null) {
            return false;
        }
        return locatorHelper.matches(locator, serializationNode, this);
    }

    private @NonNull GrammarCardinality refineGrammarCardinality(@NonNull GrammarCardinality netGrammarCardinality, @Nullable GrammarCardinality oldGrammarCardinality) {
        if (oldGrammarCardinality == null) {
            return netGrammarCardinality;
        }
        boolean newMayBeMany = netGrammarCardinality.mayBeMany();
        boolean newMayBeZero = netGrammarCardinality.mayBeZero();
        boolean oldMayBeMany = oldGrammarCardinality.mayBeMany();
        boolean oldMayBeZero = oldGrammarCardinality.mayBeZero();
        if (!oldMayBeZero) {
            newMayBeZero = false;
        }
        if (oldMayBeMany) {
            newMayBeMany = true;
        }
        return newMayBeMany ? (newMayBeZero ? GrammarCardinality.ZERO_OR_MORE : GrammarCardinality.ONE_OR_MORE) : (newMayBeZero ? GrammarCardinality.ZERO_OR_ONE : GrammarCardinality.ONE);
    }

    protected @NonNull EClass refineProducedEClass(@NonNull SerializationNode serializationNode, @NonNull EClass producedEClass) {
        if (serializationNode instanceof AssignedSerializationNode) {
            EClass assignedEClass = ((AssignedSerializationNode)serializationNode).getAssignedEClass();
            producedEClass = SerializationUtils.getSubTypeOf((EClass)producedEClass, (EClass)assignedEClass);
        } else if (serializationNode instanceof AbstractUnassignedSerializationNode) {
            EClass assignedEClass = ((AbstractUnassignedSerializationNode)serializationNode).getProducedEClass();
            producedEClass = SerializationUtils.getSubTypeOf((EClass)producedEClass, (EClass)assignedEClass);
        } else if (serializationNode instanceof SequenceSerializationNode) {
            for (SerializationNode nestedSerializationNode : ((SequenceSerializationNode)serializationNode).getSerializationNodes()) {
                producedEClass = this.refineProducedEClass(nestedSerializationNode, producedEClass);
            }
        }
        return producedEClass;
    }

    public EClass getSuperTypeOf(EClass producedEClass, EClass assignedEClass) {
        if (producedEClass.isSuperTypeOf(assignedEClass)) {
            producedEClass = assignedEClass;
        } else assert (assignedEClass.isSuperTypeOf(producedEClass));
        return producedEClass;
    }

    public @NonNull String getVariantName() {
        return this.variantName;
    }

    public void toDebugString(@NonNull StringBuilder s, int depth) {
        this.rootSerializationNode.toString(new DiagnosticStringBuilder(s), -1);
    }

    public void toRuleString(@NonNull DiagnosticStringBuilder s, int depth) {
        s.append(this.ruleAnalysis.getQualifiedName());
        s.append("-");
        s.appendObject((Object)this.variantNumber);
        s.append("(");
        EClass producedEClass = this.getProducedEClass();
        s.appendObject((Object)producedEClass.getEPackage().getName());
        s.append("::");
        s.appendObject((Object)producedEClass.getName());
        s.append("): ");
        this.rootSerializationNode.toString(s, depth);
    }

    public final @NonNull String toString() {
        DiagnosticStringBuilder.DiagnosticStringBuilderWithHelper s = new DiagnosticStringBuilder.DiagnosticStringBuilderWithHelper((SerializationRuleHelper)this);
        this.toRuleString((DiagnosticStringBuilder)s, -1);
        return s.toString();
    }
}

