/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.internal.serialization;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.modisco.facet.util.emf.core.serialization.ISerializer;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.java.discoverer.internal.JavaActivator;

public class JavaProjectSerializer
implements ISerializer<IJavaProject> {
    public Class<IJavaProject> getType() {
        return IJavaProject.class;
    }

    public String serialize(IJavaProject javaProject) {
        return javaProject.getElementName();
    }

    public IJavaProject deserialize(String serializedValue) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(serializedValue);
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                return JavaCore.create((IProject)project);
            }
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
        }
        return null;
    }
}

