/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.builder;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.Messages;
import org.eclipse.xtend.shared.ui.core.builder.IMarkerFactory;
import org.eclipse.xtend.shared.ui.core.builder.MarkerObject;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendXpandMarkerManager {
    private static final String MARKER_FACTORY_ID = "org.eclipse.xtend.shared.ui.markerFactory";
    private static IMarkerFactory markerFactory;
    private static Map<IFile, Set<MarkerObject>> markers;

    static {
        markers = new HashMap<IFile, Set<MarkerObject>>();
    }

    public static final String getMARKER_TYPE() {
        return String.valueOf(Activator.getId()) + ".problem";
    }

    public static void addMarker(IFile file, AnalysationIssue issue) {
        int severity = issue.isError() ? 2 : 1;
        int start = -1;
        int end = -1;
        if (issue.getElement() != null) {
            start = issue.getElement().getStart();
            end = issue.getElement().getEnd();
        }
        XtendXpandMarkerManager.internalAddMarker(file, issue.getMessage(), severity, start, end, issue.getType().toString());
    }

    public static void addErrorMarker(IFile file, String message, int severity, int start, int end) {
        XtendXpandMarkerManager.internalAddMarker(file, message, severity, start, end, null);
    }

    public static void addErrorMarker(IFile file, String message, int severity, int start, int end, String issueType) {
        XtendXpandMarkerManager.internalAddMarker(file, message, severity, start, end, issueType);
    }

    public static void addWarningMarker(IFile file, String message, int severity, int start, int end) {
        XtendXpandMarkerManager.internalAddMarker(file, message, severity, start, end, null);
    }

    private static final void internalAddMarker(IFile file, String message, int severity, int start, int end, String issueType) {
        MarkerObject mo = new MarkerObject(message, severity, start, end, issueType);
        if (markers.get(file) == null) {
            HashSet<MarkerObject> mos = new HashSet<MarkerObject>();
            mos.add(mo);
            markers.put(file, mos);
        } else {
            markers.get(file).add(mo);
        }
    }

    public static void finishBuild() {
        for (IFile file : markers.keySet()) {
            XtendXpandMarkerManager.createMarkersForFile(file, markers.get(file));
        }
        markers.clear();
    }

    private static void createMarkersForFile(final IFile iFile, final Set<MarkerObject> mos) {
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    block9: {
                        iFile.deleteMarkers(XtendXpandMarkerManager.getMARKER_TYPE(), true, 2);
                        ITextFileBufferManager mgr = FileBuffers.getTextFileBufferManager();
                        IPath location = iFile.getFullPath();
                        if (mgr != null) {
                            try {
                                try {
                                    mgr.connect(location, LocationKind.NORMALIZE, (IProgressMonitor)new NullProgressMonitor());
                                    ITextFileBuffer buff = mgr.getTextFileBuffer(iFile.getFullPath(), LocationKind.NORMALIZE);
                                    if (buff == null) break block9;
                                    IDocument doc = buff.getDocument();
                                    for (MarkerObject markerObject : mos) {
                                        int line = 0;
                                        try {
                                            line = doc.getLineOfOffset(markerObject.getStart());
                                        }
                                        catch (BadLocationException e) {
                                            XtendLog.logError(e);
                                        }
                                        XtendXpandMarkerManager.getMarkerFactory().createMarker((IResource)iFile, markerObject.getMessage(), markerObject.getSeverity(), markerObject.getStart(), markerObject.getEnd(), line, String.valueOf(Messages.XtendXpandMarkerManager_Line) + line, markerObject.getIssueType());
                                    }
                                }
                                catch (CoreException e) {
                                    XtendLog.logError(e);
                                    mgr.disconnect(location, LocationKind.NORMALIZE, (IProgressMonitor)new NullProgressMonitor());
                                }
                            }
                            finally {
                                mgr.disconnect(location, LocationKind.NORMALIZE, (IProgressMonitor)new NullProgressMonitor());
                            }
                        }
                    }
                }
            }.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            XtendLog.logError(e);
        }
    }

    public static void deleteMarkers(final IResource file) {
        try {
            if (file.exists()) {
                new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        file.deleteMarkers(XtendXpandMarkerManager.getMARKER_TYPE(), true, 2);
                    }
                }.run((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception ce) {
            XtendLog.logError(ce);
        }
    }

    private static synchronized IMarkerFactory getMarkerFactory() {
        if (markerFactory == null) {
            IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extPoint = extRegistry.getExtensionPoint(MARKER_FACTORY_ID);
            if (extPoint != null) {
                IExtension[] extensions = extPoint.getExtensions();
                if (extensions.length >= 1) {
                    IExtension extension = extensions[0];
                    IConfigurationElement[] configElements = extension.getConfigurationElements();
                    if (configElements.length >= 1) {
                        try {
                            markerFactory = (IMarkerFactory)configElements[0].createExecutableExtension("class");
                        }
                        catch (CoreException e) {
                            markerFactory = new IMarkerFactory.Default();
                            XtendLog.logError("Problem with extension \"" + configElements[0].getName() + "\" using default implementation instead", e);
                        }
                    }
                    if (configElements.length > 1) {
                        XtendLog.logInfo("more than one MarkerFactory defined. Taking\"" + configElements[0].getName() + "\"");
                    }
                }
                if (extensions.length > 1) {
                    XtendLog.logInfo("more than one MarkerFactory defined. Taking\"" + extensions[0].getExtensionPointUniqueIdentifier() + "\"");
                }
                if (extensions.length == 0) {
                    markerFactory = new IMarkerFactory.Default();
                    XtendLog.logInfo("No MarkerFactory defined. Taking default implementation");
                }
            } else {
                markerFactory = new IMarkerFactory.Default();
                XtendLog.logInfo("No MarkerFactory defined. Taking default implementation");
            }
        }
        return markerFactory;
    }
}

