/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor.search.query;

import com.ibm.icu.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.xtend.shared.ui.Messages;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.search.SearchMatch;
import org.eclipse.xtend.shared.ui.editor.search.query.XtendXpandSearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XtendXpandSearchQuery
implements ISearchQuery {
    private final String identifier;
    private final IXtendXpandProject project;
    private XtendXpandSearchResult result;

    public XtendXpandSearchQuery(IXtendXpandProject project, String identifier) {
        this.project = project;
        this.identifier = identifier;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return Messages.XtendXpandSearchQuery_Label;
    }

    public String getResultLabel(int matchCount) {
        String result = null;
        String searchText = this.identifier;
        String scope = "project";
        result = matchCount == 1 ? MessageFormat.format((String)"''{0}'' - 1 match in {1}", (Object[])new Object[]{searchText, scope}) : (matchCount >= 2 ? MessageFormat.format((String)"''{0}'' - {1} matches in {2}", (Object[])new Object[]{searchText, matchCount, scope}) : MessageFormat.format((String)"''{0}'' - no match found in {1}", (Object[])new Object[]{searchText, scope}));
        return result;
    }

    public ISearchResult getSearchResult() {
        if (this.result == null) {
            this.result = new XtendXpandSearchResult(this);
        }
        return this.result;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        ISearchResult searchResult = this.getSearchResult();
        if (searchResult instanceof AbstractTextSearchResult) {
            AbstractTextSearchResult result = (AbstractTextSearchResult)searchResult;
            result.removeAll();
        }
        List<SearchMatch> matches = this.performSearch();
        for (SearchMatch searchMatch : matches) {
            this.result.addMatch(new Match((Object)searchMatch.getFile(), searchMatch.getOffSet() - 1, searchMatch.getLength()));
        }
        return Status.OK_STATUS;
    }

    protected abstract List<SearchMatch> performSearch();

    public String getIdentifier() {
        return this.identifier;
    }

    public IXtendXpandProject getProject() {
        return this.project;
    }
}

