/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.xtend.shared.ui.editor.preferences.Messages;

public class FontstyleFieldEditor
extends FieldEditor {
    private boolean changed = false;
    private int value = 0;
    private Button boldButton;
    private Button italicButton;
    private Button underlineButton;
    private Composite cbPanel;

    public FontstyleFieldEditor(String name, String labeltext, Composite fieldEditorParent) {
        this.init(name, labeltext);
        this.createControl(fieldEditorParent);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label labelControl = this.getLabelControl();
        if (labelControl != null && labelControl.getLayoutData() instanceof GridData) {
            GridData data = (GridData)labelControl.getLayoutData();
            data.horizontalSpan = numColumns;
        }
        if (this.cbPanel.getLayoutData() instanceof GridData) {
            GridData layoutData = (GridData)this.cbPanel.getLayoutData();
            layoutData.horizontalSpan = numColumns;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.cbPanel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(numColumns, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 8;
        this.cbPanel.setLayout((Layout)layout);
        this.cbPanel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, numColumns, 1));
        this.boldButton = new Button(this.cbPanel, 16416);
        this.boldButton.setText(Messages.xtendxpanduipref_bold);
        this.boldButton.addSelectionListener((SelectionListener)new StyleButtonSelectionAdapter(this.boldButton, 1));
        this.italicButton = new Button(this.cbPanel, 16416);
        this.italicButton.setText(Messages.xtendxpanduipref_italic);
        this.italicButton.addSelectionListener((SelectionListener)new StyleButtonSelectionAdapter(this.italicButton, 2));
        this.underlineButton = new Button(this.cbPanel, 16416);
        this.underlineButton.setText(Messages.xtendxpanduipref_underline);
        this.underlineButton.addSelectionListener((SelectionListener)new StyleButtonSelectionAdapter(this.underlineButton, 0x40000000));
    }

    protected void doLoad() {
        String value = this.getPreferenceStore().getString(this.getPreferenceName());
        this.doLoadInternal(value);
    }

    protected void doLoadDefault() {
        String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.doLoadInternal(value);
    }

    private void doLoadInternal(String valueString) {
        this.changed = false;
        if (valueString != null) {
            try {
                this.value = Integer.parseInt(valueString);
                this.boldButton.setSelection((this.value & 1) > 0);
                this.italicButton.setSelection((this.value & 2) > 0);
                this.underlineButton.setSelection((this.value & 0x40000000) > 0);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.value = 0;
        this.boldButton.setSelection(false);
        this.italicButton.setSelection(false);
        this.underlineButton.setSelection(false);
    }

    protected void doStore() {
        if (!this.changed) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
        } else {
            this.getPreferenceStore().setValue(this.getPreferenceName(), Integer.toString(this.value));
        }
    }

    public int getNumberOfControls() {
        return 3;
    }

    private final class StyleButtonSelectionAdapter
    extends SelectionAdapter {
        private final Button control;
        private final int flag;

        public StyleButtonSelectionAdapter(Button control, int flag) {
            this.control = control;
            this.flag = flag;
        }

        public void widgetSelected(SelectionEvent event) {
            if (this.control.getSelection() != (FontstyleFieldEditor.this.value & this.flag) > 0) {
                int oldValue = FontstyleFieldEditor.this.value;
                FontstyleFieldEditor fontstyleFieldEditor = FontstyleFieldEditor.this;
                fontstyleFieldEditor.value = fontstyleFieldEditor.value ^ this.flag;
                FontstyleFieldEditor.this.changed = true;
                FontstyleFieldEditor.this.setPresentsDefaultValue(false);
                FontstyleFieldEditor.this.fireValueChanged("field_editor_value", oldValue > -1 ? Integer.toString(oldValue) : null, Integer.toString(FontstyleFieldEditor.this.value));
            }
        }
    }
}

