/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.profiler;

import java.util.List;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.container.CompositeComponent;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.internal.xpand2.ast.AbstractDefinition;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.xtend.ast.AbstractExtension;
import org.eclipse.internal.xtend.xtend.ast.Check;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.VetoableCallback;
import org.eclipse.xtend.profiler.CycleDetector;
import org.eclipse.xtend.profiler.Profiler;
import org.eclipse.xtend.profiler.profilermodel.ModelFactory;
import org.eclipse.xtend.profiler.profilermodel.ModelPackage;
import org.eclipse.xtend.profiler.profilermodel.ProfilingResult;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilerComponent
extends CompositeComponent
implements VetoableCallback {
    private String resultSlot;
    private Profiler profiler;

    static {
        EPackage.Registry.INSTANCE.put((Object)"http://org.eclipse.xtend.profiler", (Object)ModelPackage.eINSTANCE);
    }

    public ProfilerComponent() {
        super("Profiler");
    }

    public void setResultSlot(String resultSlot) {
        this.resultSlot = resultSlot;
    }

    public String getResultSlot() {
        return this.resultSlot;
    }

    public ProfilingResult getProfilingResult() {
        return this.profiler.getProfilingResult();
    }

    public void checkConfiguration(Issues issues) throws ConfigurationException {
        super.checkConfiguration(issues);
        if (this.resultSlot == null) {
            issues.addError("resultSlot not specified");
        }
    }

    public void invoke(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        this.prepareProfiler();
        super.invoke(ctx, monitor, issues);
        this.finalizeProfiler();
        ctx.set(this.resultSlot, (Object)this.profiler.getProfilingResult());
    }

    public void finalizeProfiler() {
        CycleDetector detector = new CycleDetector(this.profiler.getProfilingResult());
        detector.detectCycles();
    }

    public void prepareProfiler() {
        this.profiler = new Profiler(ModelFactory.eINSTANCE.createProfilingResult());
    }

    public boolean pre(SyntaxElement ele, ExecutionContext ctx) {
        String key = this.findKeyFor(ele, ctx);
        this.profiler.beginRoutine(key);
        return true;
    }

    public void post(SyntaxElement ele, ExecutionContext ctx, Object expressionResult) {
        this.profiler.endRoutine();
    }

    private String findKeyFor(SyntaxElement element, ExecutionContext ctx) {
        if (element instanceof AbstractDefinition) {
            AbstractDefinition def = (AbstractDefinition)element;
            return "XPD " + def.getQualifiedName() + def.getParamString(true) + " FOR " + def.getTargetType();
        }
        if (element instanceof AbstractExtension) {
            AbstractExtension ext = (AbstractExtension)element;
            return "XTD " + ext.getQualifiedName() + this.getParamString(ext.getParameterTypes());
        }
        if (element instanceof Check) {
            Check c = (Check)element;
            return "CHK " + c.toString();
        }
        return null;
    }

    private String getParamString(List<Type> params) {
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < params.size()) {
            Type t = params.get(i);
            buff.append(t.getName());
            if (i + 1 < params.size()) {
                buff.append(",");
            }
            ++i;
        }
        return buff.append(")").toString();
    }
}

