/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.java.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.functions.AbstractFunction;
import org.eclipse.xtend.backend.functions.java.internal.JavaBuiltinConverter;
import org.eclipse.xtend.backend.functions.java.internal.JavaBuiltinConverterFactory;
import org.eclipse.xtend.backend.functions.java.internal.ParameterConverter;
import org.eclipse.xtend.backend.util.CollectionHelper;
import org.eclipse.xtend.backend.util.ErrorHandler;
import org.eclipse.xtend.backend.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaOperation
extends AbstractFunction {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final Method _mtd;
    private final List<ParameterConverter> _parameterConverters = new ArrayList<ParameterConverter>();
    private final JavaBuiltinConverter _returnValueConverter;

    public JavaOperation(Method mtd, List<BackendType> parameterTypes, BackendType returnType, ExpressionBase guard) {
        super(guard, parameterTypes, returnType, false);
        this._mtd = mtd;
        int i = 0;
        while (i < mtd.getParameterTypes().length) {
            ParameterConverter pc = JavaBuiltinConverterFactory.getParameterConverter(mtd.getParameterTypes()[i], i + 1);
            if (pc != null) {
                this._parameterConverters.add(pc);
            }
            ++i;
        }
        this._returnValueConverter = JavaBuiltinConverterFactory.getConverter(mtd.getReturnType());
    }

    @Override
    public Object invoke(ExecutionContext ctx, Object[] params) {
        for (ParameterConverter pc : this._parameterConverters) {
            pc.convert(params);
        }
        try {
            if (this._log.isDebugEnabled()) {
                Object target = params[0];
                List<Object> realParams = Arrays.asList(CollectionHelper.withoutFirst(params));
                this._log.debug((Object)("invoking method " + this._mtd + " on " + target + "[" + StringHelper.getTypeAsString(target) + "] " + "for (" + realParams + ": " + StringHelper.getTypesAsString(realParams) + ")"));
            }
            Object resultRaw = this._mtd.invoke(params[0], CollectionHelper.withoutFirst(params));
            if (this._log.isDebugEnabled()) {
                Object convertedResult = this._returnValueConverter.javaToBackend(resultRaw);
                this._log.debug((Object)("  ... result: " + convertedResult + " [" + StringHelper.getTypeAsString(convertedResult) + "]"));
            }
            return this._returnValueConverter.javaToBackend(resultRaw);
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
            return null;
        }
    }
}

