/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.type.baseimpl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.internal.xtend.type.baseimpl.TypesComparator;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.xtend.typesystem.Callable;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.Operation;
import org.eclipse.xtend.typesystem.ParameterizedCallable;
import org.eclipse.xtend.typesystem.Property;
import org.eclipse.xtend.typesystem.StaticProperty;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolymorphicResolver {
    private static final Comparator<Callable> paramFeatureComparator = new Comparator<Callable>(){

        @Override
        public int compare(Callable o1, Callable o2) {
            return typesComparator.compare(PolymorphicResolver.getParamTypes(o1), PolymorphicResolver.getParamTypes(o2));
        }
    };
    public static final Comparator<List<? extends Type>> typesComparator = new TypesComparator();

    public static final Operation getOperation(Set<? extends Callable> features, String name, Type targetType, List<? extends Type> paramTypes) {
        ArrayList<? extends Type> allParams = new ArrayList<Type>();
        allParams.add(targetType);
        allParams.addAll(paramTypes);
        return (Operation)PolymorphicResolver.getFeature(features, Operation.class, name, allParams);
    }

    public static final Property getProperty(Set<? extends Callable> features, String name, Type targetType) {
        ArrayList<Type> allParams = new ArrayList<Type>();
        allParams.add(targetType);
        return (Property)PolymorphicResolver.getFeature(features, Property.class, name, allParams);
    }

    public static StaticProperty getStaticProperty(Set<? extends Callable> features, String name, Type targetType) {
        ArrayList<Type> allParams = new ArrayList<Type>();
        allParams.add(targetType);
        return (StaticProperty)PolymorphicResolver.getFeature(features, StaticProperty.class, name, allParams);
    }

    public static final Extension getExtension(Set<? extends Callable> features, String name, List<Type> paramTypes) {
        return (Extension)PolymorphicResolver.getFeature(features, Extension.class, name, paramTypes);
    }

    public static final Callable getCallable(Set<? extends Callable> callables, String name, List<Type> paramTypes) {
        return PolymorphicResolver.getFeature(callables, Callable.class, name, paramTypes);
    }

    public static <T> Set<T> select(Set<? extends Callable> features, Class<T> type) {
        HashSet<Callable> result = new HashSet<Callable>();
        for (Callable callable : features) {
            if (!type.isInstance(callable)) continue;
            result.add(callable);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static final Callable getFeature(Set<? extends Callable> features, Class type, String name, List<? extends Type> paramTypes) {
        void var5_8;
        ArrayList<Callable> possFeatures = new ArrayList<Callable>();
        for (Callable callable : features) {
            List<? extends Type> featureParamTypes;
            if (!type.isInstance(callable) || !callable.getName().equals(name) || (featureParamTypes = PolymorphicResolver.getParamTypes(callable)).size() != paramTypes.size() || typesComparator.compare(featureParamTypes, paramTypes) < 0) continue;
            possFeatures.add(callable);
        }
        if (possFeatures.size() == 1) {
            return (Callable)possFeatures.get(0);
        }
        if (possFeatures.isEmpty()) {
            return null;
        }
        boolean bl = false;
        while (var5_8 < possFeatures.size() - 1) {
            Callable feature1 = (Callable)possFeatures.get((int)var5_8);
            void c2 = var5_8 + true;
            while (c2 < possFeatures.size()) {
                Callable feature2 = (Callable)possFeatures.get((int)c2);
                if (paramFeatureComparator.compare(feature2, feature1) > 0) {
                    possFeatures.remove((int)c2);
                    --c2;
                } else if (paramFeatureComparator.compare(feature1, feature2) > 0) {
                    possFeatures.remove((int)var5_8);
                    --var5_8;
                    break;
                }
                ++c2;
            }
            ++var5_8;
        }
        if (possFeatures.size() == 1) {
            return (Callable)possFeatures.get(0);
        }
        for (Callable callable : possFeatures) {
            if (!(callable instanceof Extension)) continue;
            throw new RuntimeException("Ambiguous operations " + ((Callable)possFeatures.get(0)).toString() + " and " + ((Callable)possFeatures.get(1)).toString() + " for param types " + paramTypes);
        }
        return (Callable)possFeatures.get(0);
    }

    static List<? extends Type> getParamTypes(Callable feature) {
        ArrayList<Type> result = new ArrayList<Type>();
        if (feature instanceof Feature) {
            result.add(((Feature)feature).getOwner());
        }
        if (feature instanceof ParameterizedCallable) {
            result.addAll(((ParameterizedCallable)feature).getParameterTypes());
        }
        return result;
    }
}

