/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.metamodel.jdt;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.internal.xtend.util.Cache;
import org.eclipse.internal.xtend.util.Pair;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.shared.ui.core.metamodel.jdt.JdtTypeImpl;
import org.eclipse.xtend.shared.ui.core.metamodel.jdt.JdtTypeStrategy;
import org.eclipse.xtend.shared.ui.internal.XtendLog;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtMetaModel
implements MetaModel,
IElementChangedListener,
IResourceChangeListener {
    protected TypeSystem typesystem;
    private final String name;
    private final JdtTypeStrategy strategy;
    private final IJavaProject project;
    private static final Map<IPath, JdtMetaModel> metaModels = new HashMap<IPath, JdtMetaModel>();
    public boolean changed = false;
    private final Cache<String, Type> typeNameCache = new Cache<String, Type>(){

        protected Type createNew(String typeName) {
            try {
                Type result = JdtMetaModel.this.getType(typeName);
                return result;
            }
            catch (Exception exception) {
                return null;
            }
        }
    };
    private final Cache<Pair<String, IType>, String> signCache = new Cache<Pair<String, IType>, String>(){

        protected String createNew(Pair<String, IType> p) {
            String signature = (String)p.getFirst();
            if ("Z".equals(signature)) {
                return "Boolean";
            }
            if ("I".equals(signature)) {
                return "Integer";
            }
            if ("J".equals(signature)) {
                return "Integer";
            }
            if ("S".equals(signature)) {
                return "Integer";
            }
            if ("C".equals(signature)) {
                return "String";
            }
            if ("B".equals(signature)) {
                return "Integer";
            }
            IType usingType = (IType)p.getSecond();
            try {
                String[][] result = usingType.resolveType(Signature.toString((String)signature));
                if (result == null) {
                    return Signature.toString((String)signature).replaceAll("\\.", "::");
                }
                if (result.length > 0) {
                    StringBuffer buff = new StringBuffer();
                    int i = 0;
                    while (i < result[0].length) {
                        String part = result[0][i];
                        buff.append(part);
                        if (i < result[0].length - 1) {
                            buff.append(".");
                        }
                        ++i;
                    }
                    String fqn = buff.toString();
                    return fqn.replaceAll("\\.", "::");
                }
            }
            catch (JavaModelException e) {
                XtendLog.logError(e);
            }
            return null;
        }
    };

    public TypeSystem getTypeSystem() {
        return this.typesystem;
    }

    public void setTypeSystem(TypeSystem typeSystem) {
        this.typesystem = typeSystem;
    }

    public void elementChanged(ElementChangedEvent event) {
        if (!this.changed && this.project.isOnClasspath(event.getDelta().getElement())) {
            this.changed = true;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.typeNameCache.isEmpty()) {
            this.typeNameCache.clear();
        }
    }

    public static final JdtMetaModel create(String name, IJavaProject project, JdtTypeStrategy strategy) {
        JdtMetaModel mm = metaModels.get(project.getPath());
        if (mm == null || mm.changed) {
            if (mm != null) {
                JavaCore.removeElementChangedListener((IElementChangedListener)mm);
            }
            mm = new JdtMetaModel(name, project, strategy);
            JavaCore.addElementChangedListener((IElementChangedListener)mm);
            JavaCore.addPreProcessingResourceChangedListener((IResourceChangeListener)mm, (int)8);
            metaModels.put(project.getPath(), mm);
        }
        return mm;
    }

    public JdtMetaModel(String name, IJavaProject project, JdtTypeStrategy strategy) {
        this.name = name;
        this.strategy = strategy;
        this.project = project;
    }

    private Type getTypeForIType(IType type) {
        if (type == null || !type.exists()) {
            return null;
        }
        try {
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            if (hierarchy.contains(type.getJavaProject().findType(List.class.getName()))) {
                return this.typesystem.getListType(this.typesystem.getObjectType());
            }
            if (hierarchy.contains(type.getJavaProject().findType(Set.class.getName()))) {
                return this.typesystem.getSetType(this.typesystem.getObjectType());
            }
            if (hierarchy.contains(type.getJavaProject().findType(Collection.class.getName()))) {
                return this.typesystem.getCollectionType(this.typesystem.getObjectType());
            }
        }
        catch (JavaModelException e) {
            XtendLog.logError(e);
            return null;
        }
        return new JdtTypeImpl(this, type, this.getName(type), this.strategy);
    }

    protected Type getType(String fqn) throws JavaModelException {
        if (fqn.indexOf("::") == -1) {
            return null;
        }
        String typeName = fqn.replaceAll("::", ".");
        IType type = this.findType(this.project, typeName);
        if (type != null) {
            return this.getTypeForIType(type);
        }
        return null;
    }

    private String getName(IType class1) {
        return class1.getFullyQualifiedName().replaceAll("\\.", "::");
    }

    public Type getTypeForName(String typeName) {
        return (Type)this.typeNameCache.get((Object)typeName);
    }

    public Type getType(Object obj) {
        throw new UnsupportedOperationException();
    }

    public Type getTypeForClass(IType clazz) {
        return this.getTypeSystem().getTypeForName(this.getName(clazz));
    }

    public Set<? extends Type> getKnownTypes() {
        HashSet result = new HashSet(this.typeNameCache.getValues());
        result.remove(null);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getFullyQualifiedName(String signature, IType usingType) {
        return (String)this.signCache.get((Object)new Pair((Object)signature, (Object)usingType));
    }

    public IType findType(IJavaProject project, String typeName) throws JavaModelException {
        IType t = project.findType(typeName);
        if (t == null) {
            String[] projects = project.getRequiredProjectNames();
            int i = 0;
            while (i < projects.length && t == null) {
                IJavaProject anotherProject = project.getJavaModel().getJavaProject(projects[i]);
                if (anotherProject != null) {
                    t = anotherProject.findType(typeName);
                }
                ++i;
            }
        }
        return t;
    }

    public Set<String> getNamespaces() {
        return new HashSet<String>();
    }
}

