/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.acceleo.common.internal.utils.AcceleoLibrariesEclipseUtil;
import org.eclipse.acceleo.common.library.connector.ILibrary;
import org.eclipse.acceleo.common.library.connector.IQuery;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.EClassifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoLibrariesRegistry {
    public static final AcceleoLibrariesRegistry INSTANCE = new AcceleoLibrariesRegistry();
    private final Set<ILibrary> registeredLibraries = new LinkedHashSet<ILibrary>();

    private AcceleoLibrariesRegistry() {
    }

    public boolean addLibrary(ILibrary library) {
        return this.registeredLibraries.add(library);
    }

    public Set<ILibrary> getAllRegisteredLibraries() {
        LinkedHashSet<ILibrary> compound = new LinkedHashSet<ILibrary>();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            compound.addAll(AcceleoLibrariesEclipseUtil.getRegisteredLibraries());
        }
        compound.addAll(this.registeredLibraries);
        return compound;
    }

    public Set<IQuery> getAllRegisteredQueries() {
        Set<ILibrary> libraries = this.getAllRegisteredLibraries();
        LinkedHashSet<IQuery> queries = new LinkedHashSet<IQuery>(libraries.size());
        for (ILibrary library : libraries) {
            for (IQuery query : library.getQueries()) {
                queries.add(query);
            }
        }
        return queries;
    }

    public Set<IQuery> getRegisteredQueries(EClassifier receiverType) {
        Set<IQuery> allQueries = this.getAllRegisteredQueries();
        LinkedHashSet<IQuery> applicableQueries = new LinkedHashSet<IQuery>(allQueries.size());
        for (IQuery query : allQueries) {
            EClassifier contextType = query.getContextType();
            if (!contextType.equals(receiverType)) continue;
            applicableQueries.add(query);
        }
        return applicableQueries;
    }

    public boolean removeLibrary(ILibrary service) {
        return this.registeredLibraries.remove(service);
    }

    public void clearRegistry() {
        this.registeredLibraries.clear();
    }
}

