/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.codeassist;

import junit.framework.TestCase;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ExpressionProposalComputer;
import org.eclipse.gmf.internal.xpand.model.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.model.Scope;
import org.eclipse.gmf.internal.xpand.model.Variable;
import org.eclipse.ocl.expressions.CollectionKind;

public class ExpressionProposalComputerTest
extends TestCase {
    private ExpressionProposalComputer.ExpressionSimpleAnalyzer expressionAnalyzer;

    protected void setUp() throws Exception {
        this.expressionAnalyzer = new ExpressionProposalComputer.ExpressionSimpleAnalyzer();
    }

    public final void testComputePrefixAndTargetExpression1() {
        String[] s = this.expressionAnalyzer.computePrefixAndTargetExpression("test");
        ExpressionProposalComputerTest.assertEquals((String)"test", (String)s[0]);
        ExpressionProposalComputerTest.assertNull((Object)s[1]);
    }

    public final void testComputePrefixAndTargetExpression2() {
        String[] s = this.expressionAnalyzer.computePrefixAndTargetExpression("test.th");
        ExpressionProposalComputerTest.assertEquals((String)"th", (String)s[0]);
        ExpressionProposalComputerTest.assertEquals((String)"test", (String)s[1]);
    }

    public final void testComputePrefixAndTargetExpression3() {
        String[] s = this.expressionAnalyzer.computePrefixAndTargetExpression("test.the.computer.now");
        ExpressionProposalComputerTest.assertEquals((String)"now", (String)s[0]);
        ExpressionProposalComputerTest.assertEquals((String)"test.the.computer", (String)s[1]);
    }

    public final void testComputePrefixAndTargetExpression4() {
        String[] s = this.expressionAnalyzer.computePrefixAndTargetExpression("test(true,\nfalse()).next");
        ExpressionProposalComputerTest.assertEquals((String)"next", (String)s[0]);
    }

    public final void testComputePrefixAndTargetExpression5() {
        this.expressionAnalyzer.computePrefixAndTargetExpression("bdlfsdfows test. bla({}).");
    }

    public final void testComputePrefixAndTargetExpression6() {
        this.expressionAnalyzer.computePrefixAndTargetExpression("test(true, {false, 'hallo',stuff.");
    }

    public final void testComputePrefixAndTargetExpression7() {
        String[] s = this.expressionAnalyzer.computePrefixAndTargetExpression("rfq.*test");
        ExpressionProposalComputerTest.assertEquals((String)"test", (String)s[0]);
        ExpressionProposalComputerTest.assertEquals(null, (String)s[1]);
    }

    public final void testComputePrefixAndTargetExpression8() {
        String[] s = this.expressionAnalyzer.computePrefixAndTargetExpression("\\x");
        ExpressionProposalComputerTest.assertEquals((String)"x", (String)s[0]);
        ExpressionProposalComputerTest.assertEquals(null, (String)s[1]);
    }

    public final void testComputePrefixAndTargetExpression9() {
        String[] s = this.expressionAnalyzer.computePrefixAndTargetExpression("FOREACH (Set[EPackage])e.all");
        ExpressionProposalComputerTest.assertEquals((String)"all", (String)s[0]);
        ExpressionProposalComputerTest.assertEquals((String)"e", (String)s[1]);
    }

    public final void testComputePrefixAndTargetExpression10() {
        String[] s = this.expressionAnalyzer.computePrefixAndTargetExpression("TEST ");
        ExpressionProposalComputerTest.assertEquals((String)"", (String)s[0]);
        ExpressionProposalComputerTest.assertEquals(null, (String)s[1]);
    }

    public final void off_testSetInState() {
        ExecutionContextImpl ctx = new ExecutionContextImpl(new Scope(){});
        EClassifier oclString = (EClassifier)ctx.getOCLEnvironment().getOCLStandardLibrary().getString();
        EClassifier listOfStrings = (EClassifier)ctx.getOCLEnvironment().getTypeResolver().resolveCollectionType(CollectionKind.SEQUENCE_LITERAL, (Object)oclString);
        ctx = (ExecutionContextImpl)ctx.cloneWithVariable(new Variable[]{new Variable("v", listOfStrings, null)});
        ExpressionProposalComputerTest.assertEquals((int)2, (int)ctx.getOCLEnvironment().getVariables().size());
        ExpressionProposalComputerTest.assertEquals((Object)listOfStrings, (Object)ctx.getOCLEnvironment().lookup("v").getType());
        ExpressionProposalComputerTest.assertEquals((Object)oclString, (Object)ctx.getOCLEnvironment().lookup("e").getType());
    }

    public final void testSetInState1() {
        ExecutionContextImpl ctx = new ExecutionContextImpl(new Scope(){});
        EClassifier oclString = (EClassifier)ctx.getOCLEnvironment().getOCLStandardLibrary().getString();
        EClassifier listOfStrings = (EClassifier)ctx.getOCLEnvironment().getTypeResolver().resolveCollectionType(CollectionKind.SEQUENCE_LITERAL, (Object)oclString);
        ctx = (ExecutionContextImpl)ctx.cloneWithVariable(new Variable[]{new Variable("v", listOfStrings, null)});
        ExpressionProposalComputerTest.assertEquals((int)1, (int)ctx.getOCLEnvironment().getVariables().size());
        ExpressionProposalComputerTest.assertEquals((Object)listOfStrings, (Object)ctx.getOCLEnvironment().lookup("v").getType());
    }

    public final void off_testSetInState2() {
        ExecutionContextImpl ctx = new ExecutionContextImpl(new Scope(){});
        EClassifier oclString = (EClassifier)ctx.getOCLEnvironment().getOCLStandardLibrary().getString();
        EClassifier oclBoolean = (EClassifier)ctx.getOCLEnvironment().getOCLStandardLibrary().getBoolean();
        EClassifier listOfStrings = (EClassifier)ctx.getOCLEnvironment().getTypeResolver().resolveCollectionType(CollectionKind.SEQUENCE_LITERAL, (Object)oclString);
        ctx = (ExecutionContextImpl)ctx.cloneWithVariable(new Variable[]{new Variable("v", listOfStrings, null)});
        ExpressionProposalComputerTest.assertEquals((int)2, (int)ctx.getOCLEnvironment().getVariables().size());
        ExpressionProposalComputerTest.assertEquals((Object)listOfStrings, (Object)ctx.getOCLEnvironment().lookup("v").getType());
        ExpressionProposalComputerTest.assertEquals((Object)oclBoolean, (Object)ctx.getOCLEnvironment().lookup("e").getType());
    }

    public final void off_testSetInState3() {
        ExecutionContextImpl ctx = new ExecutionContextImpl(new Scope(){});
        EClassifier oclString = (EClassifier)ctx.getOCLEnvironment().getOCLStandardLibrary().getString();
        EClassifier oclBoolean = (EClassifier)ctx.getOCLEnvironment().getOCLStandardLibrary().getBoolean();
        EClassifier listOfStrings = (EClassifier)ctx.getOCLEnvironment().getTypeResolver().resolveCollectionType(CollectionKind.SEQUENCE_LITERAL, (Object)oclString);
        ctx = (ExecutionContextImpl)ctx.cloneWithVariable(new Variable[]{new Variable("v", listOfStrings, null)});
        ExpressionProposalComputerTest.assertEquals((int)3, (int)ctx.getOCLEnvironment().getVariables().size());
        ExpressionProposalComputerTest.assertEquals((Object)listOfStrings, (Object)ctx.getOCLEnvironment().lookup("v").getType());
        ExpressionProposalComputerTest.assertEquals((Object)oclString, (Object)ctx.getOCLEnvironment().lookup("e").getType());
        ExpressionProposalComputerTest.assertEquals((Object)oclBoolean, (Object)ctx.getOCLEnvironment().lookup("b").getType());
    }

    public final void off_testSetInState4() {
        ExecutionContextImpl ctx = new ExecutionContextImpl(new Scope(){});
        EClassifier oclString = (EClassifier)ctx.getOCLEnvironment().getOCLStandardLibrary().getString();
        EClassifier oclBoolean = (EClassifier)ctx.getOCLEnvironment().getOCLStandardLibrary().getBoolean();
        EClassifier listOfStrings = (EClassifier)ctx.getOCLEnvironment().getTypeResolver().resolveCollectionType(CollectionKind.SEQUENCE_LITERAL, (Object)oclString);
        ctx = (ExecutionContextImpl)ctx.cloneWithVariable(new Variable[]{new Variable("this", listOfStrings, null)});
        ExpressionProposalComputerTest.assertEquals((int)3, (int)ctx.getOCLEnvironment().getVariables().size());
        ExpressionProposalComputerTest.assertEquals((Object)listOfStrings, (Object)ctx.getImplicitVariable().getType());
        ExpressionProposalComputerTest.assertEquals((Object)oclString, (Object)ctx.getOCLEnvironment().lookup("e").getType());
        ExpressionProposalComputerTest.assertEquals((Object)oclBoolean, (Object)ctx.getOCLEnvironment().lookup("b").getType());
    }

    public final void off_testSetInState5() {
        ExecutionContextImpl ctx = new ExecutionContextImpl(new Scope(){});
        EClassifier oclString = (EClassifier)ctx.getOCLEnvironment().getOCLStandardLibrary().getString();
        EClassifier oclBoolean = (EClassifier)ctx.getOCLEnvironment().getOCLStandardLibrary().getBoolean();
        EClassifier listOfStrings = (EClassifier)ctx.getOCLEnvironment().getTypeResolver().resolveCollectionType(CollectionKind.SEQUENCE_LITERAL, (Object)oclString);
        ctx = (ExecutionContextImpl)ctx.cloneWithVariable(new Variable[]{new Variable("this", listOfStrings, null)});
        ExpressionProposalComputerTest.assertEquals((int)4, (int)ctx.getOCLEnvironment().getVariables().size());
        ExpressionProposalComputerTest.assertEquals((Object)listOfStrings, (Object)ctx.getImplicitVariable().getType());
        ExpressionProposalComputerTest.assertEquals((Object)oclString, (Object)ctx.getOCLEnvironment().lookup("e").getType());
        ExpressionProposalComputerTest.assertEquals((Object)oclBoolean, (Object)ctx.getOCLEnvironment().lookup("b").getType());
        ExpressionProposalComputerTest.assertEquals((Object)oclString, (Object)ctx.getOCLEnvironment().lookup("x").getType());
    }
}

