/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.ui.properties.sections;

import junit.framework.TestCase;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.ui.properties.sections.PropertySheetEntry;
import org.eclipse.gmf.runtime.emf.ui.properties.sections.UndoableModelPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class UndoableModelPropertySectionTest
extends TestCase {
    public void testEditorValueConsistentIfOperationIsCanceled() {
        TransactionalEditingDomain domain = this.createEditingDomain();
        final Resource resource = domain.getResourceSet().createResource(URI.createURI((String)"test.ecore"));
        final EPackage testPackage = this.createEPackage("test");
        final EPackage goodPackage = this.createEPackage("good one");
        final EPackage shouldBeCanceledPackage = this.createEPackage("should be canceled");
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                resource.getContents().add((Object)testPackage);
                resource.getContents().add((Object)goodPackage);
                resource.getContents().add((Object)shouldBeCanceledPackage);
            }
        });
        UndoableModelPropertySheetEntryForTest root = new UndoableModelPropertySheetEntryForTest(OperationHistoryFactory.getOperationHistory());
        root.setEditingDomain(domain);
        IPropertySourceProvider provider = new IPropertySourceProvider(){

            public IPropertySource getPropertySource(Object value) {
                return new PropertySourceForTests((EPackage)value);
            }
        };
        root.setPropertySourceProvider(provider);
        Object[] values = new EPackage[]{testPackage};
        root.setValues(values);
        UndoableModelPropertySheetEntryForTest entry = (UndoableModelPropertySheetEntryForTest)root.createChildEntry();
        entry.setValues(values);
        entry.setPropertySourceProvider(provider);
        entry.setValue(goodPackage);
        UndoableModelPropertySectionTest.assertEquals((Object)goodPackage, (Object)entry.getValueForTest());
        this.addPostCommitListenerToCancelTransaction(domain);
        entry.setValue(shouldBeCanceledPackage);
        UndoableModelPropertySectionTest.assertEquals((Object)goodPackage, (Object)entry.getValueForTest());
    }

    private TransactionalEditingDomain createEditingDomain() {
        return TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
    }

    private EPackage createEPackage(String name) {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        ePackage.setName(name);
        return ePackage;
    }

    private void addPostCommitListenerToCancelTransaction(TransactionalEditingDomain domain) {
        domain.addResourceSetListener((ResourceSetListener)new ResourceSetListenerImpl(NotificationFilter.ANY){

            public boolean isPrecommitOnly() {
                return true;
            }

            public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                throw new RollbackException(Status.CANCEL_STATUS);
            }
        });
    }

    private final class PropertySourceForTests
    implements IPropertySource {
        private boolean isSet;
        private EPackage ePackage;

        public PropertySourceForTests(EPackage ePackage) {
            this.ePackage = ePackage;
        }

        public Object getEditableValue() {
            return this.ePackage.getName();
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return null;
        }

        public Object getPropertyValue(Object id) {
            return this.ePackage.getName();
        }

        public boolean isPropertySet(Object id) {
            return this.isSet;
        }

        public void resetPropertyValue(Object id) {
            this.isSet = false;
        }

        public void setPropertyValue(Object id, Object value) {
            this.ePackage.setName((String)value);
            this.isSet = true;
        }
    }

    private final class UndoableModelPropertySheetEntryForTest
    extends UndoableModelPropertySheetEntry {
        public UndoableModelPropertySheetEntryForTest(IOperationHistory operationHistory) {
            super(operationHistory);
            this.descriptor = new TextPropertyDescriptor((Object)"id", "display");
        }

        public void setValue(Object newValue) {
            super.setValue(newValue);
        }

        public Object getValueForTest() {
            return this.editValue;
        }

        public PropertySheetEntry createChildEntry() {
            UndoableModelPropertySheetEntryForTest child = new UndoableModelPropertySheetEntryForTest(this.getOperationHistory());
            child.parent = this;
            return child;
        }
    }
}

