/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.setup;

import java.io.IOException;
import junit.framework.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.tests.EPath;
import org.eclipse.gmf.tests.TestConfiguration;
import org.eclipse.gmf.tests.lite.Activator;
import org.eclipse.gmf.tests.lite.gen.LiteGeneratorConfiguration;
import org.eclipse.gmf.tests.setup.DiaGenFileSetup;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.DomainModelFileSetup;
import org.eclipse.gmf.tests.setup.DomainModelSource;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.MapDefFileSetup;
import org.eclipse.gmf.tests.setup.MapDefSource;
import org.eclipse.gmf.tests.setup.SessionSetup;

public class LibraryConstrainedSetup
extends SessionSetup {
    private static String modelURI = "/models/library/library.ecore";
    private static String mapURI = "/models/library/library_constrained.gmfmap";
    private static String genURI = "/models/library/library_constrained.gmfgen";

    protected LibraryConstrainedSetup(GeneratorConfiguration genConfig) {
        super(genConfig);
    }

    @TestConfiguration.FactoryMethod
    public static LibraryConstrainedSetup getInstance() {
        if (factoryClosed) {
            return null;
        }
        return new LibraryConstrainedSetup((GeneratorConfiguration)new LiteGeneratorConfiguration());
    }

    protected DomainModelSource createDomainModel() {
        DomainModelFileSetup modelSetup = new DomainModelFileSetup(){
            private EPath modelAccess;

            public DomainModelSource init(URI sourceURI) {
                DomainModelSource r = super.init(sourceURI);
                this.modelAccess = new EPath(this.getModel().eResource());
                return r;
            }

            public EClass getDiagramElement() {
                return this.modelAccess.findClass("//Library");
            }

            public DomainModelSource.NodeData getNodeA() {
                EClass n = this.modelAccess.findClass("//Writer");
                EReference c = this.modelAccess.findReference("//Library/writers");
                return new DomainModelSource.NodeData(n, null, c);
            }

            public DomainModelSource.NodeData getNodeB() {
                EClass n = this.modelAccess.findClass("//Book");
                EReference c = this.modelAccess.findReference("//Library/books");
                return new DomainModelSource.NodeData(n, null, c);
            }

            public EReference getLinkAsRef() {
                return this.modelAccess.findReference("//Book/author");
            }

            public DomainModelSource.LinkData getLinkAsClass() {
                EClass l = this.modelAccess.findClass("//Opinion");
                EReference t = this.modelAccess.findReference("//Opinion/book");
                EReference c = this.modelAccess.findReference("//Writer/opinions");
                return new DomainModelSource.LinkData(l, (EStructuralFeature)t, c);
            }
        };
        try {
            modelSetup.init(Activator.createURI(modelURI));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to setup the domain model. " + e.getLocalizedMessage()));
        }
        return modelSetup;
    }

    protected MapDefSource createMapModel() {
        MapDefFileSetup mapSetup = new MapDefFileSetup(){};
        try {
            mapSetup.init(Activator.createURI(mapURI));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to setup the gmfmap. " + e.getLocalizedMessage()));
        }
        return mapSetup;
    }

    protected DiaGenSource createGenModel() {
        DiaGenFileSetup genSetup = new DiaGenFileSetup(){};
        try {
            genSetup.init(Activator.createURI(genURI));
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to setup the gmfmap. " + e.getLocalizedMessage()));
        }
        return genSetup;
    }
}

