/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.runtime.lite;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.gmf.internal.runtime.lite.Activator;

public abstract class RegistryReader
implements IRegistryChangeListener {
    private IExtensionRegistry myExtensionRegistry;
    private String myPluginID;
    private String myExtensionPointID;
    private boolean myIsActive;

    public RegistryReader(IExtensionRegistry extensionRegistry, String pluginID, String extensionPointID) {
        this.myExtensionRegistry = extensionRegistry;
        this.myPluginID = pluginID;
        this.myExtensionPointID = extensionPointID;
    }

    protected boolean readElement(IConfigurationElement configurationElement) throws IllegalArgumentException {
        return false;
    }

    protected boolean unreadElement(IConfigurationElement configurationElement) throws IllegalArgumentException {
        return false;
    }

    public void readRegistry() {
        assert (!this.myIsActive);
        this.myIsActive = true;
        IExtensionPoint extensionPoint = this.myExtensionRegistry.getExtensionPoint(this.myPluginID, this.myExtensionPointID);
        if (extensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                this.recursiveReadElement(element, true);
                ++n2;
            }
        }
        this.myExtensionRegistry.addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void dispose() {
        if (this.myIsActive) {
            this.myExtensionRegistry.removeRegistryChangeListener((IRegistryChangeListener)this);
            this.myIsActive = false;
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] iExtensionDeltaArray = event.getExtensionDeltas(this.myPluginID, this.myExtensionPointID);
        int n = iExtensionDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionDelta extensionDelta = iExtensionDeltaArray[n2];
            boolean isAdd = extensionDelta.getKind() == 1;
            IConfigurationElement[] iConfigurationElementArray = extensionDelta.getExtension().getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                this.recursiveReadElement(element, isAdd);
                ++n4;
            }
            ++n2;
        }
    }

    private void recursiveReadElement(IConfigurationElement element, boolean isAdd) {
        try {
            boolean recurse;
            boolean bl = recurse = isAdd ? this.readElement(element) : this.unreadElement(element);
            if (recurse) {
                IConfigurationElement[] iConfigurationElementArray = element.getChildren();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement child = iConfigurationElementArray[n2];
                    this.recursiveReadElement(child, isAdd);
                    ++n2;
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.logError(element, "Exception occurred while reading plugin registry", e);
        }
    }

    protected void logError(IConfigurationElement element, String message) {
        this.logError(element, message, null);
    }

    protected void logError(IConfigurationElement element, String message, Throwable e) {
        Activator.getDefault().logError(this.formatMessage(message, element), e);
    }

    private String formatMessage(String message, IConfigurationElement context) {
        if (context == null) {
            return message;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Plugin ").append(context.getDeclaringExtension().getContributor().getName()).append(", extension ").append(context.getDeclaringExtension().getExtensionPointUniqueIdentifier()).append(": ");
        buf.append(message);
        return buf.toString();
    }
}

